// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these settings.
 */
class EsamSettings private constructor(builder: Builder) {
    /**
     * Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the manifest conditioning instructions that you provide in the setting MCC XML (mccXml).
     */
    val manifestConfirmConditionNotification: aws.sdk.kotlin.services.mediaconvert.model.EsamManifestConfirmConditionNotification? = builder.manifestConfirmConditionNotification
    /**
     * Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder places and the splice points that they refer to. If the time between the start of the asset and the SCTE-35 message is less than this value, then the transcoder places the SCTE-35 marker at the beginning of the stream.
     */
    val responseSignalPreroll: kotlin.Int? = builder.responseSignalPreroll
    /**
     * Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the signal processing instructions that you provide in the setting SCC XML (sccXml).
     */
    val signalProcessingNotification: aws.sdk.kotlin.services.mediaconvert.model.EsamSignalProcessingNotification? = builder.signalProcessingNotification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.EsamSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EsamSettings(")
        append("manifestConfirmConditionNotification=$manifestConfirmConditionNotification,")
        append("responseSignalPreroll=$responseSignalPreroll,")
        append("signalProcessingNotification=$signalProcessingNotification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = manifestConfirmConditionNotification?.hashCode() ?: 0
        result = 31 * result + (responseSignalPreroll ?: 0)
        result = 31 * result + (signalProcessingNotification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EsamSettings

        if (manifestConfirmConditionNotification != other.manifestConfirmConditionNotification) return false
        if (responseSignalPreroll != other.responseSignalPreroll) return false
        if (signalProcessingNotification != other.signalProcessingNotification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.EsamSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the manifest conditioning instructions that you provide in the setting MCC XML (mccXml).
         */
        var manifestConfirmConditionNotification: aws.sdk.kotlin.services.mediaconvert.model.EsamManifestConfirmConditionNotification? = null
        /**
         * Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder places and the splice points that they refer to. If the time between the start of the asset and the SCTE-35 message is less than this value, then the transcoder places the SCTE-35 marker at the beginning of the stream.
         */
        var responseSignalPreroll: kotlin.Int? = null
        /**
         * Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the signal processing instructions that you provide in the setting SCC XML (sccXml).
         */
        var signalProcessingNotification: aws.sdk.kotlin.services.mediaconvert.model.EsamSignalProcessingNotification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.EsamSettings) : this() {
            this.manifestConfirmConditionNotification = x.manifestConfirmConditionNotification
            this.responseSignalPreroll = x.responseSignalPreroll
            this.signalProcessingNotification = x.signalProcessingNotification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.EsamSettings = EsamSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.EsamManifestConfirmConditionNotification] inside the given [block]
         */
        fun manifestConfirmConditionNotification(block: aws.sdk.kotlin.services.mediaconvert.model.EsamManifestConfirmConditionNotification.Builder.() -> kotlin.Unit) {
            this.manifestConfirmConditionNotification = aws.sdk.kotlin.services.mediaconvert.model.EsamManifestConfirmConditionNotification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.EsamSignalProcessingNotification] inside the given [block]
         */
        fun signalProcessingNotification(block: aws.sdk.kotlin.services.mediaconvert.model.EsamSignalProcessingNotification.Builder.() -> kotlin.Unit) {
            this.signalProcessingNotification = aws.sdk.kotlin.services.mediaconvert.model.EsamSignalProcessingNotification.invoke(block)
        }
    }
}
