// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for HLS output groups
 */
class HlsSettings private constructor(builder: Builder) {
    /**
     * Specifies the group to which the audio rendition belongs.
     */
    val audioGroupId: kotlin.String? = builder.audioGroupId
    /**
     * Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an MPEG2-TS container. Keep the default value Automatic (AUTOMATIC) to create an audio-only file in a raw container. Regardless of the value that you specify here, if this output has video, the service will place the output into an MPEG2-TS container.
     */
    val audioOnlyContainer: aws.sdk.kotlin.services.mediaconvert.model.HlsAudioOnlyContainer? = builder.audioOnlyContainer
    /**
     * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
     */
    val audioRenditionSets: kotlin.String? = builder.audioRenditionSets
    /**
     * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
     */
    val audioTrackType: aws.sdk.kotlin.services.mediaconvert.model.HlsAudioTrackType? = builder.audioTrackType
    /**
     * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you choose Flag (FLAG), MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag (DONT_FLAG), MediaConvert leaves this parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple documentation.
     */
    val descriptiveVideoServiceFlag: aws.sdk.kotlin.services.mediaconvert.model.HlsDescriptiveVideoServiceFlag? = builder.descriptiveVideoServiceFlag
    /**
     * Choose Include (INCLUDE) to have MediaConvert generate a child manifest that lists only the I-frames for this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default value Exclude (EXCLUDE).
     */
    val iFrameOnlyManifest: aws.sdk.kotlin.services.mediaconvert.model.HlsIFrameOnlyManifest? = builder.iFrameOnlyManifest
    /**
     * Use this setting to add an identifying string to the filename of each segment. The service adds this string between the name modifier and segment index number. You can use format identifiers in the string. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     */
    val segmentModifier: kotlin.String? = builder.segmentModifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.HlsSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsSettings(")
        append("audioGroupId=$audioGroupId,")
        append("audioOnlyContainer=$audioOnlyContainer,")
        append("audioRenditionSets=$audioRenditionSets,")
        append("audioTrackType=$audioTrackType,")
        append("descriptiveVideoServiceFlag=$descriptiveVideoServiceFlag,")
        append("iFrameOnlyManifest=$iFrameOnlyManifest,")
        append("segmentModifier=$segmentModifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioGroupId?.hashCode() ?: 0
        result = 31 * result + (audioOnlyContainer?.hashCode() ?: 0)
        result = 31 * result + (audioRenditionSets?.hashCode() ?: 0)
        result = 31 * result + (audioTrackType?.hashCode() ?: 0)
        result = 31 * result + (descriptiveVideoServiceFlag?.hashCode() ?: 0)
        result = 31 * result + (iFrameOnlyManifest?.hashCode() ?: 0)
        result = 31 * result + (segmentModifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsSettings

        if (audioGroupId != other.audioGroupId) return false
        if (audioOnlyContainer != other.audioOnlyContainer) return false
        if (audioRenditionSets != other.audioRenditionSets) return false
        if (audioTrackType != other.audioTrackType) return false
        if (descriptiveVideoServiceFlag != other.descriptiveVideoServiceFlag) return false
        if (iFrameOnlyManifest != other.iFrameOnlyManifest) return false
        if (segmentModifier != other.segmentModifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.HlsSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the group to which the audio rendition belongs.
         */
        var audioGroupId: kotlin.String? = null
        /**
         * Use this setting only in audio-only outputs. Choose MPEG-2 Transport Stream (M2TS) to create a file in an MPEG2-TS container. Keep the default value Automatic (AUTOMATIC) to create an audio-only file in a raw container. Regardless of the value that you specify here, if this output has video, the service will place the output into an MPEG2-TS container.
         */
        var audioOnlyContainer: aws.sdk.kotlin.services.mediaconvert.model.HlsAudioOnlyContainer? = null
        /**
         * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
         */
        var audioRenditionSets: kotlin.String? = null
        /**
         * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
         */
        var audioTrackType: aws.sdk.kotlin.services.mediaconvert.model.HlsAudioTrackType? = null
        /**
         * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you choose Flag (FLAG), MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag (DONT_FLAG), MediaConvert leaves this parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple documentation.
         */
        var descriptiveVideoServiceFlag: aws.sdk.kotlin.services.mediaconvert.model.HlsDescriptiveVideoServiceFlag? = null
        /**
         * Choose Include (INCLUDE) to have MediaConvert generate a child manifest that lists only the I-frames for this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default value Exclude (EXCLUDE).
         */
        var iFrameOnlyManifest: aws.sdk.kotlin.services.mediaconvert.model.HlsIFrameOnlyManifest? = null
        /**
         * Use this setting to add an identifying string to the filename of each segment. The service adds this string between the name modifier and segment index number. You can use format identifiers in the string. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
         */
        var segmentModifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.HlsSettings) : this() {
            this.audioGroupId = x.audioGroupId
            this.audioOnlyContainer = x.audioOnlyContainer
            this.audioRenditionSets = x.audioRenditionSets
            this.audioTrackType = x.audioTrackType
            this.descriptiveVideoServiceFlag = x.descriptiveVideoServiceFlag
            this.iFrameOnlyManifest = x.iFrameOnlyManifest
            this.segmentModifier = x.segmentModifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.HlsSettings = HlsSettings(this)
    }
}
