// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
class Job private constructor(builder: Builder) {
    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     */
    val accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = builder.accelerationSettings
    /**
     * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings aren't compatible with accelerated transcoding, the service either fails your job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
     */
    val accelerationStatus: aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus? = builder.accelerationStatus
    /**
     * An identifier for this resource that is unique within all of AWS.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up.
     */
    val billingTagsSource: aws.sdk.kotlin.services.mediaconvert.model.BillingTagsSource? = builder.billingTagsSource
    /**
     * The time, in Unix epoch format in seconds, when the job got created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A job's phase can be PROBING, TRANSCODING OR UPLOADING
     */
    val currentPhase: aws.sdk.kotlin.services.mediaconvert.model.JobPhase? = builder.currentPhase
    /**
     * Error code for the job
     */
    val errorCode: kotlin.Int? = builder.errorCode
    /**
     * Error message of Job
     */
    val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Optional list of hop destinations.
     */
    val hopDestinations: List<HopDestination>? = builder.hopDestinations
    /**
     * A portion of the job's ARN, unique within your AWS Elemental MediaConvert resources
     */
    val id: kotlin.String? = builder.id
    /**
     * An estimate of how far your job has progressed. This estimate is shown as a percentage of the total time from when your job leaves its queue to when your output files appear in your output Amazon S3 bucket. AWS Elemental MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and in the response to GetJob and ListJobs requests. The jobPercentComplete estimate is reliable for the following input containers: Quicktime, Transport Stream, MP4, and MXF. For some jobs, the service can't provide information about job progress. In those cases, jobPercentComplete returns a null value.
     */
    val jobPercentComplete: kotlin.Int? = builder.jobPercentComplete
    /**
     * The job template that the job is created from, if it is created from a job template.
     */
    val jobTemplate: kotlin.String? = builder.jobTemplate
    /**
     * Provides messages from the service about jobs that you have already successfully submitted.
     */
    val messages: aws.sdk.kotlin.services.mediaconvert.model.JobMessages? = builder.messages
    /**
     * List of output group details
     */
    val outputGroupDetails: List<OutputGroupDetail>? = builder.outputGroupDetails
    /**
     * Relative priority on the job.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    val queue: kotlin.String? = builder.queue
    /**
     * The job's queue hopping history.
     */
    val queueTransitions: List<QueueTransition>? = builder.queueTransitions
    /**
     * The number of times that the service automatically attempted to process your job after encountering an error.
     */
    val retryCount: kotlin.Int? = builder.retryCount
    /**
     * The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
     */
    val role: kotlin.String? = builder.role
    /**
     * JobSettings contains all the transcode settings for a job.
     */
    val settings: aws.sdk.kotlin.services.mediaconvert.model.JobSettings? = builder.settings
    /**
     * Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
     */
    val simulateReservedQueue: aws.sdk.kotlin.services.mediaconvert.model.SimulateReservedQueue? = builder.simulateReservedQueue
    /**
     * A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
     */
    val status: aws.sdk.kotlin.services.mediaconvert.model.JobStatus? = builder.status
    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
     */
    val statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = builder.statusUpdateInterval
    /**
     * Information about when jobs are submitted, started, and finished is specified in Unix epoch format in seconds.
     */
    val timing: aws.sdk.kotlin.services.mediaconvert.model.Timing? = builder.timing
    /**
     * User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.
     */
    val userMetadata: Map<String, String>? = builder.userMetadata

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Job = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Job(")
        append("accelerationSettings=$accelerationSettings,")
        append("accelerationStatus=$accelerationStatus,")
        append("arn=$arn,")
        append("billingTagsSource=$billingTagsSource,")
        append("createdAt=$createdAt,")
        append("currentPhase=$currentPhase,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("hopDestinations=$hopDestinations,")
        append("id=$id,")
        append("jobPercentComplete=$jobPercentComplete,")
        append("jobTemplate=$jobTemplate,")
        append("messages=$messages,")
        append("outputGroupDetails=$outputGroupDetails,")
        append("priority=$priority,")
        append("queue=$queue,")
        append("queueTransitions=$queueTransitions,")
        append("retryCount=$retryCount,")
        append("role=$role,")
        append("settings=$settings,")
        append("simulateReservedQueue=$simulateReservedQueue,")
        append("status=$status,")
        append("statusUpdateInterval=$statusUpdateInterval,")
        append("timing=$timing,")
        append("userMetadata=$userMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerationSettings?.hashCode() ?: 0
        result = 31 * result + (accelerationStatus?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (billingTagsSource?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (currentPhase?.hashCode() ?: 0)
        result = 31 * result + (errorCode ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (hopDestinations?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (jobPercentComplete ?: 0)
        result = 31 * result + (jobTemplate?.hashCode() ?: 0)
        result = 31 * result + (messages?.hashCode() ?: 0)
        result = 31 * result + (outputGroupDetails?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (queue?.hashCode() ?: 0)
        result = 31 * result + (queueTransitions?.hashCode() ?: 0)
        result = 31 * result + (retryCount ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (simulateReservedQueue?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusUpdateInterval?.hashCode() ?: 0)
        result = 31 * result + (timing?.hashCode() ?: 0)
        result = 31 * result + (userMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Job

        if (accelerationSettings != other.accelerationSettings) return false
        if (accelerationStatus != other.accelerationStatus) return false
        if (arn != other.arn) return false
        if (billingTagsSource != other.billingTagsSource) return false
        if (createdAt != other.createdAt) return false
        if (currentPhase != other.currentPhase) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (hopDestinations != other.hopDestinations) return false
        if (id != other.id) return false
        if (jobPercentComplete != other.jobPercentComplete) return false
        if (jobTemplate != other.jobTemplate) return false
        if (messages != other.messages) return false
        if (outputGroupDetails != other.outputGroupDetails) return false
        if (priority != other.priority) return false
        if (queue != other.queue) return false
        if (queueTransitions != other.queueTransitions) return false
        if (retryCount != other.retryCount) return false
        if (role != other.role) return false
        if (settings != other.settings) return false
        if (simulateReservedQueue != other.simulateReservedQueue) return false
        if (status != other.status) return false
        if (statusUpdateInterval != other.statusUpdateInterval) return false
        if (timing != other.timing) return false
        if (userMetadata != other.userMetadata) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Job = Builder(this).apply(block).build()

    class Builder {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         */
        var accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = null
        /**
         * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings aren't compatible with accelerated transcoding, the service either fails your job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
         */
        var accelerationStatus: aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus? = null
        /**
         * An identifier for this resource that is unique within all of AWS.
         */
        var arn: kotlin.String? = null
        /**
         * The tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up.
         */
        var billingTagsSource: aws.sdk.kotlin.services.mediaconvert.model.BillingTagsSource? = null
        /**
         * The time, in Unix epoch format in seconds, when the job got created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A job's phase can be PROBING, TRANSCODING OR UPLOADING
         */
        var currentPhase: aws.sdk.kotlin.services.mediaconvert.model.JobPhase? = null
        /**
         * Error code for the job
         */
        var errorCode: kotlin.Int? = null
        /**
         * Error message of Job
         */
        var errorMessage: kotlin.String? = null
        /**
         * Optional list of hop destinations.
         */
        var hopDestinations: List<HopDestination>? = null
        /**
         * A portion of the job's ARN, unique within your AWS Elemental MediaConvert resources
         */
        var id: kotlin.String? = null
        /**
         * An estimate of how far your job has progressed. This estimate is shown as a percentage of the total time from when your job leaves its queue to when your output files appear in your output Amazon S3 bucket. AWS Elemental MediaConvert provides jobPercentComplete in CloudWatch STATUS_UPDATE events and in the response to GetJob and ListJobs requests. The jobPercentComplete estimate is reliable for the following input containers: Quicktime, Transport Stream, MP4, and MXF. For some jobs, the service can't provide information about job progress. In those cases, jobPercentComplete returns a null value.
         */
        var jobPercentComplete: kotlin.Int? = null
        /**
         * The job template that the job is created from, if it is created from a job template.
         */
        var jobTemplate: kotlin.String? = null
        /**
         * Provides messages from the service about jobs that you have already successfully submitted.
         */
        var messages: aws.sdk.kotlin.services.mediaconvert.model.JobMessages? = null
        /**
         * List of output group details
         */
        var outputGroupDetails: List<OutputGroupDetail>? = null
        /**
         * Relative priority on the job.
         */
        var priority: kotlin.Int? = null
        /**
         * When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
         */
        var queue: kotlin.String? = null
        /**
         * The job's queue hopping history.
         */
        var queueTransitions: List<QueueTransition>? = null
        /**
         * The number of times that the service automatically attempted to process your job after encountering an error.
         */
        var retryCount: kotlin.Int? = null
        /**
         * The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
         */
        var role: kotlin.String? = null
        /**
         * JobSettings contains all the transcode settings for a job.
         */
        var settings: aws.sdk.kotlin.services.mediaconvert.model.JobSettings? = null
        /**
         * Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
         */
        var simulateReservedQueue: aws.sdk.kotlin.services.mediaconvert.model.SimulateReservedQueue? = null
        /**
         * A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
         */
        var status: aws.sdk.kotlin.services.mediaconvert.model.JobStatus? = null
        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
         */
        var statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = null
        /**
         * Information about when jobs are submitted, started, and finished is specified in Unix epoch format in seconds.
         */
        var timing: aws.sdk.kotlin.services.mediaconvert.model.Timing? = null
        /**
         * User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.
         */
        var userMetadata: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Job) : this() {
            this.accelerationSettings = x.accelerationSettings
            this.accelerationStatus = x.accelerationStatus
            this.arn = x.arn
            this.billingTagsSource = x.billingTagsSource
            this.createdAt = x.createdAt
            this.currentPhase = x.currentPhase
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.hopDestinations = x.hopDestinations
            this.id = x.id
            this.jobPercentComplete = x.jobPercentComplete
            this.jobTemplate = x.jobTemplate
            this.messages = x.messages
            this.outputGroupDetails = x.outputGroupDetails
            this.priority = x.priority
            this.queue = x.queue
            this.queueTransitions = x.queueTransitions
            this.retryCount = x.retryCount
            this.role = x.role
            this.settings = x.settings
            this.simulateReservedQueue = x.simulateReservedQueue
            this.status = x.status
            this.statusUpdateInterval = x.statusUpdateInterval
            this.timing = x.timing
            this.userMetadata = x.userMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Job = Job(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings] inside the given [block]
         */
        fun accelerationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.Builder.() -> kotlin.Unit) {
            this.accelerationSettings = aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.JobMessages] inside the given [block]
         */
        fun messages(block: aws.sdk.kotlin.services.mediaconvert.model.JobMessages.Builder.() -> kotlin.Unit) {
            this.messages = aws.sdk.kotlin.services.mediaconvert.model.JobMessages.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.JobSettings] inside the given [block]
         */
        fun settings(block: aws.sdk.kotlin.services.mediaconvert.model.JobSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.mediaconvert.model.JobSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Timing] inside the given [block]
         */
        fun timing(block: aws.sdk.kotlin.services.mediaconvert.model.Timing.Builder.() -> kotlin.Unit) {
            this.timing = aws.sdk.kotlin.services.mediaconvert.model.Timing.invoke(block)
        }
    }
}
