// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to your Microsoft Smooth Streaming output package. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job specification, include this object and any required children when you set Type, under OutputGroupSettings, to MS_SMOOTH_GROUP_SETTINGS.
 */
class MsSmoothGroupSettings private constructor(builder: Builder) {
    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming output group in your job. This default manifest references every output in the output group. To create additional manifests that reference a subset of the outputs in the output group, specify a list of them here.
     */
    val additionalManifests: List<MsSmoothAdditionalManifest>? = builder.additionalManifests
    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into a single audio stream.
     */
    val audioDeduplication: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothAudioDeduplication? = builder.audioDeduplication
    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    val destination: kotlin.String? = builder.destination
    /**
     * Settings associated with the destination. Will vary based on the type of destination
     */
    val destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = builder.destinationSettings
    /**
     * If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.
     */
    val encryption: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothEncryptionSettings? = builder.encryption
    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Fragment length (FragmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    val fragmentLength: kotlin.Int? = builder.fragmentLength
    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Fragment length (FragmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    val fragmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothFragmentLengthControl? = builder.fragmentLengthControl
    /**
     * Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client manifest. Valid options are utf8 and utf16.
     */
    val manifestEncoding: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothManifestEncoding? = builder.manifestEncoding

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.MsSmoothGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MsSmoothGroupSettings(")
        append("additionalManifests=$additionalManifests,")
        append("audioDeduplication=$audioDeduplication,")
        append("destination=$destination,")
        append("destinationSettings=$destinationSettings,")
        append("encryption=$encryption,")
        append("fragmentLength=$fragmentLength,")
        append("fragmentLengthControl=$fragmentLengthControl,")
        append("manifestEncoding=$manifestEncoding)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalManifests?.hashCode() ?: 0
        result = 31 * result + (audioDeduplication?.hashCode() ?: 0)
        result = 31 * result + (destination?.hashCode() ?: 0)
        result = 31 * result + (destinationSettings?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (fragmentLength ?: 0)
        result = 31 * result + (fragmentLengthControl?.hashCode() ?: 0)
        result = 31 * result + (manifestEncoding?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MsSmoothGroupSettings

        if (additionalManifests != other.additionalManifests) return false
        if (audioDeduplication != other.audioDeduplication) return false
        if (destination != other.destination) return false
        if (destinationSettings != other.destinationSettings) return false
        if (encryption != other.encryption) return false
        if (fragmentLength != other.fragmentLength) return false
        if (fragmentLengthControl != other.fragmentLengthControl) return false
        if (manifestEncoding != other.manifestEncoding) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.MsSmoothGroupSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming output group in your job. This default manifest references every output in the output group. To create additional manifests that reference a subset of the outputs in the output group, specify a list of them here.
         */
        var additionalManifests: List<MsSmoothAdditionalManifest>? = null
        /**
         * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into a single audio stream.
         */
        var audioDeduplication: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothAudioDeduplication? = null
        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
         */
        var destination: kotlin.String? = null
        /**
         * Settings associated with the destination. Will vary based on the type of destination
         */
        var destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = null
        /**
         * If you are using DRM, set DRM System (MsSmoothEncryptionSettings) to specify the value SpekeKeyProvider.
         */
        var encryption: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothEncryptionSettings? = null
        /**
         * Specify how you want MediaConvert to determine the fragment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Fragment length (FragmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
         */
        var fragmentLength: kotlin.Int? = null
        /**
         * Specify how you want MediaConvert to determine the fragment length. Choose Exact (EXACT) to have the encoder use the exact length that you specify with the setting Fragment length (FragmentLength). This might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the next GOP boundary.
         */
        var fragmentLengthControl: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothFragmentLengthControl? = null
        /**
         * Use Manifest encoding (MsSmoothManifestEncoding) to specify the encoding format for the server and client manifest. Valid options are utf8 and utf16.
         */
        var manifestEncoding: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothManifestEncoding? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothGroupSettings) : this() {
            this.additionalManifests = x.additionalManifests
            this.audioDeduplication = x.audioDeduplication
            this.destination = x.destination
            this.destinationSettings = x.destinationSettings
            this.encryption = x.encryption
            this.fragmentLength = x.fragmentLength
            this.fragmentLengthControl = x.fragmentLengthControl
            this.manifestEncoding = x.manifestEncoding
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.MsSmoothGroupSettings = MsSmoothGroupSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings] inside the given [block]
         */
        fun destinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.Builder.() -> kotlin.Unit) {
            this.destinationSettings = aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MsSmoothEncryptionSettings] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.mediaconvert.model.MsSmoothEncryptionSettings.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.mediaconvert.model.MsSmoothEncryptionSettings.invoke(block)
        }
    }
}
