// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC.
 */
class MxfXavcProfileSettings private constructor(builder: Builder) {
    /**
     * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default value, Drop frames for compliance (DROP_FRAMES_FOR_COMPLIANCE). To include all frames from your input in this output, keep the default setting, Allow any duration (ALLOW_ANY_DURATION). The number of frames that MediaConvert excludes when you set this to Drop frames for compliance depends on the output frame rate and duration.
     */
    val durationMode: aws.sdk.kotlin.services.mediaconvert.model.MxfXavcDurationMode? = builder.durationMode
    /**
     * Specify a value for this setting only for outputs that you set up with one of these two XAVC profiles: XAVC HD Intra CBG (XAVC_HD_INTRA_CBG) or XAVC 4K Intra CBG (XAVC_4K_INTRA_CBG). Specify the amount of space in each frame that the service reserves for ancillary data, such as teletext captions. The default value for this setting is 1492 bytes per frame. This should be sufficient to prevent overflow unless you have multiple pages of teletext captions data. If you have a large amount of teletext data, specify a larger number.
     */
    val maxAncDataSize: kotlin.Int? = builder.maxAncDataSize

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.MxfXavcProfileSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MxfXavcProfileSettings(")
        append("durationMode=$durationMode,")
        append("maxAncDataSize=$maxAncDataSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationMode?.hashCode() ?: 0
        result = 31 * result + (maxAncDataSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MxfXavcProfileSettings

        if (durationMode != other.durationMode) return false
        if (maxAncDataSize != other.maxAncDataSize) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.MxfXavcProfileSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * To create an output that complies with the XAVC file format guidelines for interoperability, keep the default value, Drop frames for compliance (DROP_FRAMES_FOR_COMPLIANCE). To include all frames from your input in this output, keep the default setting, Allow any duration (ALLOW_ANY_DURATION). The number of frames that MediaConvert excludes when you set this to Drop frames for compliance depends on the output frame rate and duration.
         */
        var durationMode: aws.sdk.kotlin.services.mediaconvert.model.MxfXavcDurationMode? = null
        /**
         * Specify a value for this setting only for outputs that you set up with one of these two XAVC profiles: XAVC HD Intra CBG (XAVC_HD_INTRA_CBG) or XAVC 4K Intra CBG (XAVC_4K_INTRA_CBG). Specify the amount of space in each frame that the service reserves for ancillary data, such as teletext captions. The default value for this setting is 1492 bytes per frame. This should be sufficient to prevent overflow unless you have multiple pages of teletext captions data. If you have a large amount of teletext data, specify a larger number.
         */
        var maxAncDataSize: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.MxfXavcProfileSettings) : this() {
            this.durationMode = x.durationMode
            this.maxAncDataSize = x.maxAncDataSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.MxfXavcProfileSettings = MxfXavcProfileSettings(this)
    }
}
