// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
 */
class XavcHdProfileSettings private constructor(builder: Builder) {
    /**
     * Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
     */
    val bitrateClass: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileBitrateClass? = builder.bitrateClass
    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
     */
    val flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcFlickerAdaptiveQuantization? = builder.flickerAdaptiveQuantization
    /**
     * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
     */
    val gopBReference: aws.sdk.kotlin.services.mediaconvert.model.XavcGopBReference? = builder.gopBReference
    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
     */
    val gopClosedCadence: kotlin.Int? = builder.gopClosedCadence
    /**
     * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
     */
    val hrdBufferSize: kotlin.Int? = builder.hrdBufferSize
    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
     */
    val interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.XavcInterlaceMode? = builder.interlaceMode
    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     */
    val qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileQualityTuningLevel? = builder.qualityTuningLevel
    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    val slices: kotlin.Int? = builder.slices
    /**
     * Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
     */
    val telecine: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileTelecine? = builder.telecine

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XavcHdProfileSettings(")
        append("bitrateClass=$bitrateClass,")
        append("flickerAdaptiveQuantization=$flickerAdaptiveQuantization,")
        append("gopBReference=$gopBReference,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("hrdBufferSize=$hrdBufferSize,")
        append("interlaceMode=$interlaceMode,")
        append("qualityTuningLevel=$qualityTuningLevel,")
        append("slices=$slices,")
        append("telecine=$telecine)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitrateClass?.hashCode() ?: 0
        result = 31 * result + (flickerAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (gopBReference?.hashCode() ?: 0)
        result = 31 * result + (gopClosedCadence ?: 0)
        result = 31 * result + (hrdBufferSize ?: 0)
        result = 31 * result + (interlaceMode?.hashCode() ?: 0)
        result = 31 * result + (qualityTuningLevel?.hashCode() ?: 0)
        result = 31 * result + (slices ?: 0)
        result = 31 * result + (telecine?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XavcHdProfileSettings

        if (bitrateClass != other.bitrateClass) return false
        if (flickerAdaptiveQuantization != other.flickerAdaptiveQuantization) return false
        if (gopBReference != other.gopBReference) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (hrdBufferSize != other.hrdBufferSize) return false
        if (interlaceMode != other.interlaceMode) return false
        if (qualityTuningLevel != other.qualityTuningLevel) return false
        if (slices != other.slices) return false
        if (telecine != other.telecine) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
         */
        var bitrateClass: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileBitrateClass? = null
        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
         */
        var flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcFlickerAdaptiveQuantization? = null
        /**
         * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
         */
        var gopBReference: aws.sdk.kotlin.services.mediaconvert.model.XavcGopBReference? = null
        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
         */
        var gopClosedCadence: kotlin.Int? = null
        /**
         * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
         */
        var hrdBufferSize: kotlin.Int? = null
        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
         */
        var interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.XavcInterlaceMode? = null
        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         */
        var qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileQualityTuningLevel? = null
        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         */
        var slices: kotlin.Int? = null
        /**
         * Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
         */
        var telecine: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileTelecine? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings) : this() {
            this.bitrateClass = x.bitrateClass
            this.flickerAdaptiveQuantization = x.flickerAdaptiveQuantization
            this.gopBReference = x.gopBReference
            this.gopClosedCadence = x.gopClosedCadence
            this.hrdBufferSize = x.hrdBufferSize
            this.interlaceMode = x.interlaceMode
            this.qualityTuningLevel = x.qualityTuningLevel
            this.slices = x.slices
            this.telecine = x.telecine
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings = XavcHdProfileSettings(this)
    }
}
