// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
 */
class XavcSettings private constructor(builder: Builder) {
    /**
     * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
     */
    val adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcAdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
     */
    val entropyEncoding: aws.sdk.kotlin.services.mediaconvert.model.XavcEntropyEncoding? = builder.entropyEncoding
    /**
     * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
     */
    val framerateControl: aws.sdk.kotlin.services.mediaconvert.model.XavcFramerateControl? = builder.framerateControl
    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
     */
    val framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.XavcFramerateConversionAlgorithm? = builder.framerateConversionAlgorithm
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
     */
    val framerateDenominator: kotlin.Int? = builder.framerateDenominator
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateNumerator: kotlin.Int? = builder.framerateNumerator
    /**
     * Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
     */
    val profile: aws.sdk.kotlin.services.mediaconvert.model.XavcProfile? = builder.profile
    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     */
    val slowPal: aws.sdk.kotlin.services.mediaconvert.model.XavcSlowPal? = builder.slowPal
    /**
     * Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
     */
    val softness: kotlin.Int? = builder.softness
    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     */
    val spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcSpatialAdaptiveQuantization? = builder.spatialAdaptiveQuantization
    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
     */
    val temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcTemporalAdaptiveQuantization? = builder.temporalAdaptiveQuantization
    /**
     * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
     */
    val xavc4KIntraCbgProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraCbgProfileSettings? = builder.xavc4KIntraCbgProfileSettings
    /**
     * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
     */
    val xavc4KIntraVbrProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraVbrProfileSettings? = builder.xavc4KIntraVbrProfileSettings
    /**
     * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
     */
    val xavc4KProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings? = builder.xavc4KProfileSettings
    /**
     * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
     */
    val xavcHdIntraCbgProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.XavcHdIntraCbgProfileSettings? = builder.xavcHdIntraCbgProfileSettings
    /**
     * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
     */
    val xavcHdProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings? = builder.xavcHdProfileSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.XavcSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XavcSettings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("entropyEncoding=$entropyEncoding,")
        append("framerateControl=$framerateControl,")
        append("framerateConversionAlgorithm=$framerateConversionAlgorithm,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("profile=$profile,")
        append("slowPal=$slowPal,")
        append("softness=$softness,")
        append("spatialAdaptiveQuantization=$spatialAdaptiveQuantization,")
        append("temporalAdaptiveQuantization=$temporalAdaptiveQuantization,")
        append("xavc4KIntraCbgProfileSettings=$xavc4KIntraCbgProfileSettings,")
        append("xavc4KIntraVbrProfileSettings=$xavc4KIntraVbrProfileSettings,")
        append("xavc4KProfileSettings=$xavc4KProfileSettings,")
        append("xavcHdIntraCbgProfileSettings=$xavcHdIntraCbgProfileSettings,")
        append("xavcHdProfileSettings=$xavcHdProfileSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (entropyEncoding?.hashCode() ?: 0)
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateConversionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator ?: 0)
        result = 31 * result + (framerateNumerator ?: 0)
        result = 31 * result + (profile?.hashCode() ?: 0)
        result = 31 * result + (slowPal?.hashCode() ?: 0)
        result = 31 * result + (softness ?: 0)
        result = 31 * result + (spatialAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (temporalAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (xavc4KIntraCbgProfileSettings?.hashCode() ?: 0)
        result = 31 * result + (xavc4KIntraVbrProfileSettings?.hashCode() ?: 0)
        result = 31 * result + (xavc4KProfileSettings?.hashCode() ?: 0)
        result = 31 * result + (xavcHdIntraCbgProfileSettings?.hashCode() ?: 0)
        result = 31 * result + (xavcHdProfileSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XavcSettings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (entropyEncoding != other.entropyEncoding) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateConversionAlgorithm != other.framerateConversionAlgorithm) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (profile != other.profile) return false
        if (slowPal != other.slowPal) return false
        if (softness != other.softness) return false
        if (spatialAdaptiveQuantization != other.spatialAdaptiveQuantization) return false
        if (temporalAdaptiveQuantization != other.temporalAdaptiveQuantization) return false
        if (xavc4KIntraCbgProfileSettings != other.xavc4KIntraCbgProfileSettings) return false
        if (xavc4KIntraVbrProfileSettings != other.xavc4KIntraVbrProfileSettings) return false
        if (xavc4KProfileSettings != other.xavc4KProfileSettings) return false
        if (xavcHdIntraCbgProfileSettings != other.xavcHdIntraCbgProfileSettings) return false
        if (xavcHdProfileSettings != other.xavcHdProfileSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.XavcSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
         */
        var adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcAdaptiveQuantization? = null
        /**
         * Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
         */
        var entropyEncoding: aws.sdk.kotlin.services.mediaconvert.model.XavcEntropyEncoding? = null
        /**
         * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
         */
        var framerateControl: aws.sdk.kotlin.services.mediaconvert.model.XavcFramerateControl? = null
        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         */
        var framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.XavcFramerateConversionAlgorithm? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
         */
        var framerateDenominator: kotlin.Int? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateNumerator: kotlin.Int? = null
        /**
         * Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
         */
        var profile: aws.sdk.kotlin.services.mediaconvert.model.XavcProfile? = null
        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
         */
        var slowPal: aws.sdk.kotlin.services.mediaconvert.model.XavcSlowPal? = null
        /**
         * Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
         */
        var softness: kotlin.Int? = null
        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         */
        var spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcSpatialAdaptiveQuantization? = null
        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
         */
        var temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.XavcTemporalAdaptiveQuantization? = null
        /**
         * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
         */
        var xavc4KIntraCbgProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraCbgProfileSettings? = null
        /**
         * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
         */
        var xavc4KIntraVbrProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraVbrProfileSettings? = null
        /**
         * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
         */
        var xavc4KProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings? = null
        /**
         * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
         */
        var xavcHdIntraCbgProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.XavcHdIntraCbgProfileSettings? = null
        /**
         * Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
         */
        var xavcHdProfileSettings: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.XavcSettings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.entropyEncoding = x.entropyEncoding
            this.framerateControl = x.framerateControl
            this.framerateConversionAlgorithm = x.framerateConversionAlgorithm
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.profile = x.profile
            this.slowPal = x.slowPal
            this.softness = x.softness
            this.spatialAdaptiveQuantization = x.spatialAdaptiveQuantization
            this.temporalAdaptiveQuantization = x.temporalAdaptiveQuantization
            this.xavc4KIntraCbgProfileSettings = x.xavc4KIntraCbgProfileSettings
            this.xavc4KIntraVbrProfileSettings = x.xavc4KIntraVbrProfileSettings
            this.xavc4KProfileSettings = x.xavc4KProfileSettings
            this.xavcHdIntraCbgProfileSettings = x.xavcHdIntraCbgProfileSettings
            this.xavcHdProfileSettings = x.xavcHdProfileSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.XavcSettings = XavcSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraCbgProfileSettings] inside the given [block]
         */
        fun xavc4KIntraCbgProfileSettings(block: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraCbgProfileSettings.Builder.() -> kotlin.Unit) {
            this.xavc4KIntraCbgProfileSettings = aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraCbgProfileSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraVbrProfileSettings] inside the given [block]
         */
        fun xavc4KIntraVbrProfileSettings(block: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraVbrProfileSettings.Builder.() -> kotlin.Unit) {
            this.xavc4KIntraVbrProfileSettings = aws.sdk.kotlin.services.mediaconvert.model.Xavc4KIntraVbrProfileSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings] inside the given [block]
         */
        fun xavc4KProfileSettings(block: aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings.Builder.() -> kotlin.Unit) {
            this.xavc4KProfileSettings = aws.sdk.kotlin.services.mediaconvert.model.Xavc4KProfileSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.XavcHdIntraCbgProfileSettings] inside the given [block]
         */
        fun xavcHdIntraCbgProfileSettings(block: aws.sdk.kotlin.services.mediaconvert.model.XavcHdIntraCbgProfileSettings.Builder.() -> kotlin.Unit) {
            this.xavcHdIntraCbgProfileSettings = aws.sdk.kotlin.services.mediaconvert.model.XavcHdIntraCbgProfileSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings] inside the given [block]
         */
        fun xavcHdProfileSettings(block: aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings.Builder.() -> kotlin.Unit) {
            this.xavcHdProfileSettings = aws.sdk.kotlin.services.mediaconvert.model.XavcHdProfileSettings.invoke(block)
        }
    }
}
