// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.transform

import aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings
import aws.sdk.kotlin.services.mediaconvert.model.BillingTagsSource
import aws.sdk.kotlin.services.mediaconvert.model.CreateJobRequest
import aws.sdk.kotlin.services.mediaconvert.model.HopDestination
import aws.sdk.kotlin.services.mediaconvert.model.JobSettings
import aws.sdk.kotlin.services.mediaconvert.model.SimulateReservedQueue
import aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateJobOperationSerializer: HttpSerialize<CreateJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/2017-08-29/jobs"
        }

        val payload = serializeCreateJobOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateJobOperationBody(context: ExecutionContext, input: CreateJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCELERATIONSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accelerationSettings"))
    val BILLINGTAGSSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("billingTagsSource"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val HOPDESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hopDestinations"))
    val JOBTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobTemplate"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val QUEUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queue"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("role"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("settings"))
    val SIMULATERESERVEDQUEUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("simulateReservedQueue"))
    val STATUSUPDATEINTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusUpdateInterval"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val USERMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("userMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCELERATIONSETTINGS_DESCRIPTOR)
        field(BILLINGTAGSSOURCE_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(HOPDESTINATIONS_DESCRIPTOR)
        field(JOBTEMPLATE_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(QUEUE_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
        field(SIMULATERESERVEDQUEUE_DESCRIPTOR)
        field(STATUSUPDATEINTERVAL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(USERMETADATA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accelerationSettings?.let { field(ACCELERATIONSETTINGS_DESCRIPTOR, it, ::serializeAccelerationSettingsDocument) }
        input.billingTagsSource?.let { field(BILLINGTAGSSOURCE_DESCRIPTOR, it.value) }
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.hopDestinations != null) {
            listField(HOPDESTINATIONS_DESCRIPTOR) {
                for (el0 in input.hopDestinations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeHopDestinationDocument))
                }
            }
        }
        input.jobTemplate?.let { field(JOBTEMPLATE_DESCRIPTOR, it) }
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
        input.queue?.let { field(QUEUE_DESCRIPTOR, it) }
        input.role?.let { field(ROLE_DESCRIPTOR, it) }
        input.settings?.let { field(SETTINGS_DESCRIPTOR, it, ::serializeJobSettingsDocument) }
        input.simulateReservedQueue?.let { field(SIMULATERESERVEDQUEUE_DESCRIPTOR, it.value) }
        input.statusUpdateInterval?.let { field(STATUSUPDATEINTERVAL_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.userMetadata != null) {
            mapField(USERMETADATA_DESCRIPTOR) {
                input.userMetadata.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
