// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.mediaconvert.model.*
import aws.sdk.kotlin.services.mediaconvert.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "MediaConvert"
const val ServiceApiVersion: String = "2017-08-29"
const val SdkVersion: String = "0.16.7-beta"

internal class DefaultMediaConvertClient(override val config: MediaConvertClient.Config) : MediaConvertClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
     */
    override suspend fun associateCertificate(input: AssociateCertificateRequest): AssociateCertificateResponse {
        val op = SdkHttpOperation.build<AssociateCertificateRequest, AssociateCertificateResponse> {
            serializer = AssociateCertificateOperationSerializer()
            deserializer = AssociateCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "AssociateCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.
     */
    override suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse {
        val op = SdkHttpOperation.build<CancelJobRequest, CancelJobResponse> {
            serializer = CancelJobOperationSerializer()
            deserializer = CancelJobOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CancelJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    override suspend fun createJob(input: CreateJobRequest): CreateJobResponse {
        val op = SdkHttpOperation.build<CreateJobRequest, CreateJobResponse> {
            serializer = CreateJobOperationSerializer()
            deserializer = CreateJobOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    override suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse {
        val op = SdkHttpOperation.build<CreateJobTemplateRequest, CreateJobTemplateResponse> {
            serializer = CreateJobTemplateOperationSerializer()
            deserializer = CreateJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    override suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse {
        val op = SdkHttpOperation.build<CreatePresetRequest, CreatePresetResponse> {
            serializer = CreatePresetOperationSerializer()
            deserializer = CreatePresetOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
     */
    override suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse {
        val op = SdkHttpOperation.build<CreateQueueRequest, CreateQueueResponse> {
            serializer = CreateQueueOperationSerializer()
            deserializer = CreateQueueOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently delete a job template you have created.
     */
    override suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse {
        val op = SdkHttpOperation.build<DeleteJobTemplateRequest, DeleteJobTemplateResponse> {
            serializer = DeleteJobTemplateOperationSerializer()
            deserializer = DeleteJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently delete a policy that you created.
     */
    override suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse {
        val op = SdkHttpOperation.build<DeletePolicyRequest, DeletePolicyResponse> {
            serializer = DeletePolicyOperationSerializer()
            deserializer = DeletePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently delete a preset you have created.
     */
    override suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse {
        val op = SdkHttpOperation.build<DeletePresetRequest, DeletePresetResponse> {
            serializer = DeletePresetOperationSerializer()
            deserializer = DeletePresetOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeletePreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently delete a queue you have created.
     */
    override suspend fun deleteQueue(input: DeleteQueueRequest): DeleteQueueResponse {
        val op = SdkHttpOperation.build<DeleteQueueRequest, DeleteQueueResponse> {
            serializer = DeleteQueueOperationSerializer()
            deserializer = DeleteQueueOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
     */
    override suspend fun describeEndpoints(input: DescribeEndpointsRequest): DescribeEndpointsResponse {
        val op = SdkHttpOperation.build<DescribeEndpointsRequest, DescribeEndpointsResponse> {
            serializer = DescribeEndpointsOperationSerializer()
            deserializer = DescribeEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.
     */
    override suspend fun disassociateCertificate(input: DisassociateCertificateRequest): DisassociateCertificateResponse {
        val op = SdkHttpOperation.build<DisassociateCertificateRequest, DisassociateCertificateResponse> {
            serializer = DisassociateCertificateOperationSerializer()
            deserializer = DisassociateCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DisassociateCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the JSON for a specific completed transcoding job.
     */
    override suspend fun getJob(input: GetJobRequest): GetJobResponse {
        val op = SdkHttpOperation.build<GetJobRequest, GetJobResponse> {
            serializer = GetJobOperationSerializer()
            deserializer = GetJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the JSON for a specific job template.
     */
    override suspend fun getJobTemplate(input: GetJobTemplateRequest): GetJobTemplateResponse {
        val op = SdkHttpOperation.build<GetJobTemplateRequest, GetJobTemplateResponse> {
            serializer = GetJobTemplateOperationSerializer()
            deserializer = GetJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the JSON for your policy.
     */
    override suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse {
        val op = SdkHttpOperation.build<GetPolicyRequest, GetPolicyResponse> {
            serializer = GetPolicyOperationSerializer()
            deserializer = GetPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the JSON for a specific preset.
     */
    override suspend fun getPreset(input: GetPresetRequest): GetPresetResponse {
        val op = SdkHttpOperation.build<GetPresetRequest, GetPresetResponse> {
            serializer = GetPresetOperationSerializer()
            deserializer = GetPresetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the JSON for a specific queue.
     */
    override suspend fun getQueue(input: GetQueueRequest): GetQueueResponse {
        val op = SdkHttpOperation.build<GetQueueRequest, GetQueueResponse> {
            serializer = GetQueueOperationSerializer()
            deserializer = GetQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
     */
    override suspend fun listJobTemplates(input: ListJobTemplatesRequest): ListJobTemplatesResponse {
        val op = SdkHttpOperation.build<ListJobTemplatesRequest, ListJobTemplatesResponse> {
            serializer = ListJobTemplatesOperationSerializer()
            deserializer = ListJobTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.
     */
    override suspend fun listJobs(input: ListJobsRequest): ListJobsResponse {
        val op = SdkHttpOperation.build<ListJobsRequest, ListJobsResponse> {
            serializer = ListJobsOperationSerializer()
            deserializer = ListJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
     */
    override suspend fun listPresets(input: ListPresetsRequest): ListPresetsResponse {
        val op = SdkHttpOperation.build<ListPresetsRequest, ListPresetsResponse> {
            serializer = ListPresetsOperationSerializer()
            deserializer = ListPresetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPresets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.
     */
    override suspend fun listQueues(input: ListQueuesRequest): ListQueuesResponse {
        val op = SdkHttpOperation.build<ListQueuesRequest, ListQueuesResponse> {
            serializer = ListQueuesOperationSerializer()
            deserializer = ListQueuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListQueues"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the tags for a MediaConvert resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create or change your policy. For more information about policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    override suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse {
        val op = SdkHttpOperation.build<PutPolicyRequest, PutPolicyResponse> {
            serializer = PutPolicyOperationSerializer()
            deserializer = PutPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify one of your existing job templates.
     */
    override suspend fun updateJobTemplate(input: UpdateJobTemplateRequest): UpdateJobTemplateResponse {
        val op = SdkHttpOperation.build<UpdateJobTemplateRequest, UpdateJobTemplateResponse> {
            serializer = UpdateJobTemplateOperationSerializer()
            deserializer = UpdateJobTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateJobTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify one of your existing presets.
     */
    override suspend fun updatePreset(input: UpdatePresetRequest): UpdatePresetResponse {
        val op = SdkHttpOperation.build<UpdatePresetRequest, UpdatePresetResponse> {
            serializer = UpdatePresetOperationSerializer()
            deserializer = UpdatePresetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modify one of your existing queues.
     */
    override suspend fun updateQueue(input: UpdateQueueRequest): UpdateQueueResponse {
        val op = SdkHttpOperation.build<UpdateQueueRequest, UpdateQueueResponse> {
            serializer = UpdateQueueOperationSerializer()
            deserializer = UpdateQueueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateQueue"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "mediaconvert"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "mediaconvert")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
