// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediaconvert.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediaconvert.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Elemental MediaConvert
 */
interface MediaConvertClient : SdkClient {

    override val serviceName: String
        get() = "MediaConvert"
    /**
     * MediaConvertClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): MediaConvertClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaConvertClient(config)
        }

        operator fun invoke(config: Config): MediaConvertClient = DefaultMediaConvertClient(config)

        /**
         * Construct a [MediaConvertClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaConvertClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultMediaConvertClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
     */
    suspend fun associateCertificate(input: AssociateCertificateRequest): AssociateCertificateResponse

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
     */
    suspend fun associateCertificate(block: AssociateCertificateRequest.Builder.() -> Unit) = associateCertificate(AssociateCertificateRequest.Builder().apply(block).build())

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.
     */
    suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.
     */
    suspend fun cancelJob(block: CancelJobRequest.Builder.() -> Unit) = cancelJob(CancelJobRequest.Builder().apply(block).build())

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun createJob(block: CreateJobRequest.Builder.() -> Unit) = createJob(CreateJobRequest.Builder().apply(block).build())

    /**
     * Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse

    /**
     * Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun createJobTemplate(block: CreateJobTemplateRequest.Builder.() -> Unit) = createJobTemplate(CreateJobTemplateRequest.Builder().apply(block).build())

    /**
     * Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse

    /**
     * Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun createPreset(block: CreatePresetRequest.Builder.() -> Unit) = createPreset(CreatePresetRequest.Builder().apply(block).build())

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
     */
    suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
     */
    suspend fun createQueue(block: CreateQueueRequest.Builder.() -> Unit) = createQueue(CreateQueueRequest.Builder().apply(block).build())

    /**
     * Permanently delete a job template you have created.
     */
    suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse

    /**
     * Permanently delete a job template you have created.
     */
    suspend fun deleteJobTemplate(block: DeleteJobTemplateRequest.Builder.() -> Unit) = deleteJobTemplate(DeleteJobTemplateRequest.Builder().apply(block).build())

    /**
     * Permanently delete a policy that you created.
     */
    suspend fun deletePolicy(input: DeletePolicyRequest = DeletePolicyRequest {}): DeletePolicyResponse

    /**
     * Permanently delete a policy that you created.
     */
    suspend fun deletePolicy(block: DeletePolicyRequest.Builder.() -> Unit) = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

    /**
     * Permanently delete a preset you have created.
     */
    suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse

    /**
     * Permanently delete a preset you have created.
     */
    suspend fun deletePreset(block: DeletePresetRequest.Builder.() -> Unit) = deletePreset(DeletePresetRequest.Builder().apply(block).build())

    /**
     * Permanently delete a queue you have created.
     */
    suspend fun deleteQueue(input: DeleteQueueRequest): DeleteQueueResponse

    /**
     * Permanently delete a queue you have created.
     */
    suspend fun deleteQueue(block: DeleteQueueRequest.Builder.() -> Unit) = deleteQueue(DeleteQueueRequest.Builder().apply(block).build())

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
     */
    suspend fun describeEndpoints(input: DescribeEndpointsRequest = DescribeEndpointsRequest {}): DescribeEndpointsResponse

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
     */
    suspend fun describeEndpoints(block: DescribeEndpointsRequest.Builder.() -> Unit) = describeEndpoints(DescribeEndpointsRequest.Builder().apply(block).build())

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.
     */
    suspend fun disassociateCertificate(input: DisassociateCertificateRequest): DisassociateCertificateResponse

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.
     */
    suspend fun disassociateCertificate(block: DisassociateCertificateRequest.Builder.() -> Unit) = disassociateCertificate(DisassociateCertificateRequest.Builder().apply(block).build())

    /**
     * Retrieve the JSON for a specific completed transcoding job.
     */
    suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Retrieve the JSON for a specific completed transcoding job.
     */
    suspend fun getJob(block: GetJobRequest.Builder.() -> Unit) = getJob(GetJobRequest.Builder().apply(block).build())

    /**
     * Retrieve the JSON for a specific job template.
     */
    suspend fun getJobTemplate(input: GetJobTemplateRequest): GetJobTemplateResponse

    /**
     * Retrieve the JSON for a specific job template.
     */
    suspend fun getJobTemplate(block: GetJobTemplateRequest.Builder.() -> Unit) = getJobTemplate(GetJobTemplateRequest.Builder().apply(block).build())

    /**
     * Retrieve the JSON for your policy.
     */
    suspend fun getPolicy(input: GetPolicyRequest = GetPolicyRequest {}): GetPolicyResponse

    /**
     * Retrieve the JSON for your policy.
     */
    suspend fun getPolicy(block: GetPolicyRequest.Builder.() -> Unit) = getPolicy(GetPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieve the JSON for a specific preset.
     */
    suspend fun getPreset(input: GetPresetRequest): GetPresetResponse

    /**
     * Retrieve the JSON for a specific preset.
     */
    suspend fun getPreset(block: GetPresetRequest.Builder.() -> Unit) = getPreset(GetPresetRequest.Builder().apply(block).build())

    /**
     * Retrieve the JSON for a specific queue.
     */
    suspend fun getQueue(input: GetQueueRequest): GetQueueResponse

    /**
     * Retrieve the JSON for a specific queue.
     */
    suspend fun getQueue(block: GetQueueRequest.Builder.() -> Unit) = getQueue(GetQueueRequest.Builder().apply(block).build())

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
     */
    suspend fun listJobTemplates(input: ListJobTemplatesRequest = ListJobTemplatesRequest {}): ListJobTemplatesResponse

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
     */
    suspend fun listJobTemplates(block: ListJobTemplatesRequest.Builder.() -> Unit) = listJobTemplates(ListJobTemplatesRequest.Builder().apply(block).build())

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.
     */
    suspend fun listJobs(input: ListJobsRequest = ListJobsRequest {}): ListJobsResponse

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.
     */
    suspend fun listJobs(block: ListJobsRequest.Builder.() -> Unit) = listJobs(ListJobsRequest.Builder().apply(block).build())

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
     */
    suspend fun listPresets(input: ListPresetsRequest = ListPresetsRequest {}): ListPresetsResponse

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
     */
    suspend fun listPresets(block: ListPresetsRequest.Builder.() -> Unit) = listPresets(ListPresetsRequest.Builder().apply(block).build())

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.
     */
    suspend fun listQueues(input: ListQueuesRequest = ListQueuesRequest {}): ListQueuesResponse

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.
     */
    suspend fun listQueues(block: ListQueuesRequest.Builder.() -> Unit) = listQueues(ListQueuesRequest.Builder().apply(block).build())

    /**
     * Retrieve the tags for a MediaConvert resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieve the tags for a MediaConvert resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Create or change your policy. For more information about policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse

    /**
     * Create or change your policy. For more information about policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    suspend fun putPolicy(block: PutPolicyRequest.Builder.() -> Unit) = putPolicy(PutPolicyRequest.Builder().apply(block).build())

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Modify one of your existing job templates.
     */
    suspend fun updateJobTemplate(input: UpdateJobTemplateRequest): UpdateJobTemplateResponse

    /**
     * Modify one of your existing job templates.
     */
    suspend fun updateJobTemplate(block: UpdateJobTemplateRequest.Builder.() -> Unit) = updateJobTemplate(UpdateJobTemplateRequest.Builder().apply(block).build())

    /**
     * Modify one of your existing presets.
     */
    suspend fun updatePreset(input: UpdatePresetRequest): UpdatePresetResponse

    /**
     * Modify one of your existing presets.
     */
    suspend fun updatePreset(block: UpdatePresetRequest.Builder.() -> Unit) = updatePreset(UpdatePresetRequest.Builder().apply(block).build())

    /**
     * Modify one of your existing queues.
     */
    suspend fun updateQueue(input: UpdateQueueRequest): UpdateQueueResponse

    /**
     * Modify one of your existing queues.
     */
    suspend fun updateQueue(block: UpdateQueueRequest.Builder.() -> Unit) = updateQueue(UpdateQueueRequest.Builder().apply(block).build())
}
