// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import kotlin.collections.List

/**
 * Describes whether the current job is running with accelerated transcoding. For jobs that have Acceleration (AccelerationMode) set to DISABLED, AccelerationStatus is always NOT_APPLICABLE. For jobs that have Acceleration (AccelerationMode) set to ENABLED or PREFERRED, AccelerationStatus is one of the other states. AccelerationStatus is IN_PROGRESS initially, while the service determines whether the input files and job settings are compatible with accelerated transcoding. If they are, AcclerationStatus is ACCELERATED. If your input files and job settings aren't compatible with accelerated transcoding, the service either fails your job or runs it without accelerated transcoding, depending on how you set Acceleration (AccelerationMode). When the service runs your job without accelerated transcoding, AccelerationStatus is NOT_ACCELERATED.
 */
sealed class AccelerationStatus {

    abstract val value: kotlin.String

    object Accelerated : aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus() {
        override val value: kotlin.String = "ACCELERATED"
        override fun toString(): kotlin.String = value
    }

    object InProgress : aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus() {
        override val value: kotlin.String = "IN_PROGRESS"
        override fun toString(): kotlin.String = value
    }

    object NotAccelerated : aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus() {
        override val value: kotlin.String = "NOT_ACCELERATED"
        override fun toString(): kotlin.String = value
    }

    object NotApplicable : aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus() {
        override val value: kotlin.String = "NOT_APPLICABLE"
        override fun toString(): kotlin.String = value
    }

    data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus() {
        override fun toString(): kotlin.String = value
    }

    companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        fun fromValue(str: kotlin.String): aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus = when(str) {
            "ACCELERATED" -> Accelerated
            "IN_PROGRESS" -> InProgress
            "NOT_ACCELERATED" -> NotAccelerated
            "NOT_APPLICABLE" -> NotApplicable
            else -> SdkUnknown(str)
        }

        /**
         * Get a list of all possible variants
         */
        fun values(): kotlin.collections.List<aws.sdk.kotlin.services.mediaconvert.model.AccelerationStatus> = listOf(
            Accelerated,
            InProgress,
            NotAccelerated,
            NotApplicable
        )
    }
}
