// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use Allowed renditions to specify a list of possible resolutions in your ABR stack. * MediaConvert will create an ABR stack exclusively from the list of resolutions that you specify. * Some resolutions in the Allowed renditions list may not be included, however you can force a resolution to be included by setting Required to ENABLED. * You must specify at least one resolution that is greater than or equal to any resolutions that you specify in Min top rendition size or Min bottom rendition size. * If you specify Allowed renditions, you must not specify a separate rule for Force include renditions.
 */
class AllowedRenditionSize private constructor(builder: Builder) {
    /**
     * Use Height to define the video resolution height, in pixels, for this rule.
     */
    val height: kotlin.Int? = builder.height
    /**
     * Set to ENABLED to force a rendition to be included.
     */
    val required: aws.sdk.kotlin.services.mediaconvert.model.RequiredFlag? = builder.required
    /**
     * Use Width to define the video resolution width, in pixels, for this rule.
     */
    val width: kotlin.Int? = builder.width

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AllowedRenditionSize = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AllowedRenditionSize(")
        append("height=$height,")
        append("required=$required,")
        append("width=$width)")
    }

    override fun hashCode(): kotlin.Int {
        var result = height ?: 0
        result = 31 * result + (required?.hashCode() ?: 0)
        result = 31 * result + (width ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AllowedRenditionSize

        if (height != other.height) return false
        if (required != other.required) return false
        if (width != other.width) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AllowedRenditionSize = Builder(this).apply(block).build()

    class Builder {
        /**
         * Use Height to define the video resolution height, in pixels, for this rule.
         */
        var height: kotlin.Int? = null
        /**
         * Set to ENABLED to force a rendition to be included.
         */
        var required: aws.sdk.kotlin.services.mediaconvert.model.RequiredFlag? = null
        /**
         * Use Width to define the video resolution width, in pixels, for this rule.
         */
        var width: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AllowedRenditionSize) : this() {
            this.height = x.height
            this.required = x.required
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AllowedRenditionSize = AllowedRenditionSize(this)
    }
}
