// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to audio encoding. The settings in this group vary depending on the value that you choose for your audio codec.
 */
class AudioCodecSettings private constructor(builder: Builder) {
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values depend on the rate control mode.
     */
    val aacSettings: aws.sdk.kotlin.services.mediaconvert.model.AacSettings? = builder.aacSettings
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
     */
    val ac3Settings: aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings? = builder.ac3Settings
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.
     */
    val aiffSettings: aws.sdk.kotlin.services.mediaconvert.model.AiffSettings? = builder.aiffSettings
    /**
     * Choose the audio codec for this output. Note that the option Dolby Digital passthrough (PASSTHROUGH) applies only to Dolby Digital and Dolby Digital Plus audio inputs. Make sure that you choose a codec that's supported with your output container: https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers.html#reference-codecs-containers-output-audio For audio-only outputs, make sure that both your input audio codec and your output audio codec are supported for audio-only workflows. For more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers-input.html#reference-codecs-containers-input-audio-only and https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers.html#audio-only-output
     */
    val codec: aws.sdk.kotlin.services.mediaconvert.model.AudioCodec? = builder.codec
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
     */
    val eac3AtmosSettings: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings? = builder.eac3AtmosSettings
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
     */
    val eac3Settings: aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings? = builder.eac3Settings
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.
     */
    val mp2Settings: aws.sdk.kotlin.services.mediaconvert.model.Mp2Settings? = builder.mp2Settings
    /**
     * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value MP3.
     */
    val mp3Settings: aws.sdk.kotlin.services.mediaconvert.model.Mp3Settings? = builder.mp3Settings
    /**
     * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value OPUS.
     */
    val opusSettings: aws.sdk.kotlin.services.mediaconvert.model.OpusSettings? = builder.opusSettings
    /**
     * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value Vorbis.
     */
    val vorbisSettings: aws.sdk.kotlin.services.mediaconvert.model.VorbisSettings? = builder.vorbisSettings
    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.
     */
    val wavSettings: aws.sdk.kotlin.services.mediaconvert.model.WavSettings? = builder.wavSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioCodecSettings(")
        append("aacSettings=$aacSettings,")
        append("ac3Settings=$ac3Settings,")
        append("aiffSettings=$aiffSettings,")
        append("codec=$codec,")
        append("eac3AtmosSettings=$eac3AtmosSettings,")
        append("eac3Settings=$eac3Settings,")
        append("mp2Settings=$mp2Settings,")
        append("mp3Settings=$mp3Settings,")
        append("opusSettings=$opusSettings,")
        append("vorbisSettings=$vorbisSettings,")
        append("wavSettings=$wavSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aacSettings?.hashCode() ?: 0
        result = 31 * result + (ac3Settings?.hashCode() ?: 0)
        result = 31 * result + (aiffSettings?.hashCode() ?: 0)
        result = 31 * result + (codec?.hashCode() ?: 0)
        result = 31 * result + (eac3AtmosSettings?.hashCode() ?: 0)
        result = 31 * result + (eac3Settings?.hashCode() ?: 0)
        result = 31 * result + (mp2Settings?.hashCode() ?: 0)
        result = 31 * result + (mp3Settings?.hashCode() ?: 0)
        result = 31 * result + (opusSettings?.hashCode() ?: 0)
        result = 31 * result + (vorbisSettings?.hashCode() ?: 0)
        result = 31 * result + (wavSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioCodecSettings

        if (aacSettings != other.aacSettings) return false
        if (ac3Settings != other.ac3Settings) return false
        if (aiffSettings != other.aiffSettings) return false
        if (codec != other.codec) return false
        if (eac3AtmosSettings != other.eac3AtmosSettings) return false
        if (eac3Settings != other.eac3Settings) return false
        if (mp2Settings != other.mp2Settings) return false
        if (mp3Settings != other.mp3Settings) return false
        if (opusSettings != other.opusSettings) return false
        if (vorbisSettings != other.vorbisSettings) return false
        if (wavSettings != other.wavSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values depend on the rate control mode.
         */
        var aacSettings: aws.sdk.kotlin.services.mediaconvert.model.AacSettings? = null
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
         */
        var ac3Settings: aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings? = null
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.
         */
        var aiffSettings: aws.sdk.kotlin.services.mediaconvert.model.AiffSettings? = null
        /**
         * Choose the audio codec for this output. Note that the option Dolby Digital passthrough (PASSTHROUGH) applies only to Dolby Digital and Dolby Digital Plus audio inputs. Make sure that you choose a codec that's supported with your output container: https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers.html#reference-codecs-containers-output-audio For audio-only outputs, make sure that both your input audio codec and your output audio codec are supported for audio-only workflows. For more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers-input.html#reference-codecs-containers-input-audio-only and https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers.html#audio-only-output
         */
        var codec: aws.sdk.kotlin.services.mediaconvert.model.AudioCodec? = null
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
         */
        var eac3AtmosSettings: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings? = null
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
         */
        var eac3Settings: aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings? = null
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.
         */
        var mp2Settings: aws.sdk.kotlin.services.mediaconvert.model.Mp2Settings? = null
        /**
         * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value MP3.
         */
        var mp3Settings: aws.sdk.kotlin.services.mediaconvert.model.Mp3Settings? = null
        /**
         * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value OPUS.
         */
        var opusSettings: aws.sdk.kotlin.services.mediaconvert.model.OpusSettings? = null
        /**
         * Required when you set Codec, under AudioDescriptions>CodecSettings, to the value Vorbis.
         */
        var vorbisSettings: aws.sdk.kotlin.services.mediaconvert.model.VorbisSettings? = null
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.
         */
        var wavSettings: aws.sdk.kotlin.services.mediaconvert.model.WavSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings) : this() {
            this.aacSettings = x.aacSettings
            this.ac3Settings = x.ac3Settings
            this.aiffSettings = x.aiffSettings
            this.codec = x.codec
            this.eac3AtmosSettings = x.eac3AtmosSettings
            this.eac3Settings = x.eac3Settings
            this.mp2Settings = x.mp2Settings
            this.mp3Settings = x.mp3Settings
            this.opusSettings = x.opusSettings
            this.vorbisSettings = x.vorbisSettings
            this.wavSettings = x.wavSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings = AudioCodecSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AacSettings] inside the given [block]
         */
        fun aacSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AacSettings.Builder.() -> kotlin.Unit) {
            this.aacSettings = aws.sdk.kotlin.services.mediaconvert.model.AacSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings] inside the given [block]
         */
        fun ac3Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings.Builder.() -> kotlin.Unit) {
            this.ac3Settings = aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AiffSettings] inside the given [block]
         */
        fun aiffSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AiffSettings.Builder.() -> kotlin.Unit) {
            this.aiffSettings = aws.sdk.kotlin.services.mediaconvert.model.AiffSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings] inside the given [block]
         */
        fun eac3AtmosSettings(block: aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings.Builder.() -> kotlin.Unit) {
            this.eac3AtmosSettings = aws.sdk.kotlin.services.mediaconvert.model.Eac3AtmosSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings] inside the given [block]
         */
        fun eac3Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings.Builder.() -> kotlin.Unit) {
            this.eac3Settings = aws.sdk.kotlin.services.mediaconvert.model.Eac3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Mp2Settings] inside the given [block]
         */
        fun mp2Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Mp2Settings.Builder.() -> kotlin.Unit) {
            this.mp2Settings = aws.sdk.kotlin.services.mediaconvert.model.Mp2Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Mp3Settings] inside the given [block]
         */
        fun mp3Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Mp3Settings.Builder.() -> kotlin.Unit) {
            this.mp3Settings = aws.sdk.kotlin.services.mediaconvert.model.Mp3Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.OpusSettings] inside the given [block]
         */
        fun opusSettings(block: aws.sdk.kotlin.services.mediaconvert.model.OpusSettings.Builder.() -> kotlin.Unit) {
            this.opusSettings = aws.sdk.kotlin.services.mediaconvert.model.OpusSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.VorbisSettings] inside the given [block]
         */
        fun vorbisSettings(block: aws.sdk.kotlin.services.mediaconvert.model.VorbisSettings.Builder.() -> kotlin.Unit) {
            this.vorbisSettings = aws.sdk.kotlin.services.mediaconvert.model.VorbisSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.WavSettings] inside the given [block]
         */
        fun wavSettings(block: aws.sdk.kotlin.services.mediaconvert.model.WavSettings.Builder.() -> kotlin.Unit) {
            this.wavSettings = aws.sdk.kotlin.services.mediaconvert.model.WavSettings.invoke(block)
        }
    }
}
