// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to one audio tab on the MediaConvert console. In your job JSON, an instance of AudioDescription is equivalent to one audio tab in the console. Usually, one audio tab corresponds to one output audio track. Depending on how you set up your input audio selectors and whether you use audio selector groups, one audio tab can correspond to a group of output audio tracks.
 */
class AudioDescription private constructor(builder: Builder) {
    /**
     * When you mimic a multi-channel audio layout with multiple mono-channel tracks, you can tag each channel layout manually. For example, you would tag the tracks that contain your left, right, and center audio with Left (L), Right (R), and Center (C), respectively. When you don't specify a value, MediaConvert labels your track as Center (C) by default. To use audio layout tagging, your output must be in a QuickTime (.mov) container; your audio codec must be AAC, WAV, or AIFF; and you must set up your audio track to have only one channel.
     */
    val audioChannelTaggingSettings: aws.sdk.kotlin.services.mediaconvert.model.AudioChannelTaggingSettings? = builder.audioChannelTaggingSettings
    /**
     * Advanced audio normalization settings. Ignore these settings unless you need to comply with a loudness standard.
     */
    val audioNormalizationSettings: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings? = builder.audioNormalizationSettings
    /**
     * Specifies which audio data to use from each input. In the simplest case, specify an "Audio Selector":#inputs-audio_selector by name based on its order within each input. For example if you specify "Audio Selector 3", then the third audio selector will be used from each input. If an input does not have an "Audio Selector 3", then the audio selector marked as "default" in that input will be used. If there is no audio selector marked as "default", silence will be inserted for the duration of that input. Alternatively, an "Audio Selector Group":#inputs-audio_selector_group name may be specified, with similar default/silence behavior. If no audio_source_name is specified, then "Audio Selector 1" will be chosen automatically.
     */
    val audioSourceName: kotlin.String? = builder.audioSourceName
    /**
     * Applies only if Follow Input Audio Type is unchecked (false). A number between 0 and 255. The following are defined in ISO-IEC 13818-1: 0 = Undefined, 1 = Clean Effects, 2 = Hearing Impaired, 3 = Visually Impaired Commentary, 4-255 = Reserved.
     */
    val audioType: kotlin.Int? = builder.audioType
    /**
     * When set to FOLLOW_INPUT, if the input contains an ISO 639 audio_type, then that value is passed through to the output. If the input contains no ISO 639 audio_type, the value in Audio Type is included in the output. Otherwise the value in Audio Type is included in the output. Note that this field and audioType are both ignored if audioDescriptionBroadcasterMix is set to BROADCASTER_MIXED_AD.
     */
    val audioTypeControl: aws.sdk.kotlin.services.mediaconvert.model.AudioTypeControl? = builder.audioTypeControl
    /**
     * Settings related to audio encoding. The settings in this group vary depending on the value that you choose for your audio codec.
     */
    val codecSettings: aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings? = builder.codecSettings
    /**
     * Specify the language for this audio output track. The service puts this language code into your output audio track when you set Language code control (AudioLanguageCodeControl) to Use configured (USE_CONFIGURED). The service also uses your specified custom language code when you set Language code control (AudioLanguageCodeControl) to Follow input (FOLLOW_INPUT), but your input file doesn't specify a language code. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
     */
    val customLanguageCode: kotlin.String? = builder.customLanguageCode
    /**
     * Indicates the language of the audio output track. The ISO 639 language specified in the 'Language Code' drop down will be used when 'Follow Input Language Code' is not selected or when 'Follow Input Language Code' is selected but there is no ISO 639 language code specified by the input.
     */
    val languageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = builder.languageCode
    /**
     * Specify which source for language code takes precedence for this audio track. When you choose Follow input (FOLLOW_INPUT), the service uses the language code from the input track if it's present. If there's no languge code on the input track, the service uses the code that you specify in the setting Language code (languageCode or customLanguageCode). When you choose Use configured (USE_CONFIGURED), the service uses the language code that you specify.
     */
    val languageCodeControl: aws.sdk.kotlin.services.mediaconvert.model.AudioLanguageCodeControl? = builder.languageCodeControl
    /**
     * Advanced audio remixing settings.
     */
    val remixSettings: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings? = builder.remixSettings
    /**
     * Specify a label for this output audio stream. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer's player device. For outputs in other output groups, the service ignores this setting.
     */
    val streamName: kotlin.String? = builder.streamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AudioDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioDescription(")
        append("audioChannelTaggingSettings=$audioChannelTaggingSettings,")
        append("audioNormalizationSettings=$audioNormalizationSettings,")
        append("audioSourceName=$audioSourceName,")
        append("audioType=$audioType,")
        append("audioTypeControl=$audioTypeControl,")
        append("codecSettings=$codecSettings,")
        append("customLanguageCode=$customLanguageCode,")
        append("languageCode=$languageCode,")
        append("languageCodeControl=$languageCodeControl,")
        append("remixSettings=$remixSettings,")
        append("streamName=$streamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioChannelTaggingSettings?.hashCode() ?: 0
        result = 31 * result + (audioNormalizationSettings?.hashCode() ?: 0)
        result = 31 * result + (audioSourceName?.hashCode() ?: 0)
        result = 31 * result + (audioType ?: 0)
        result = 31 * result + (audioTypeControl?.hashCode() ?: 0)
        result = 31 * result + (codecSettings?.hashCode() ?: 0)
        result = 31 * result + (customLanguageCode?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (languageCodeControl?.hashCode() ?: 0)
        result = 31 * result + (remixSettings?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioDescription

        if (audioChannelTaggingSettings != other.audioChannelTaggingSettings) return false
        if (audioNormalizationSettings != other.audioNormalizationSettings) return false
        if (audioSourceName != other.audioSourceName) return false
        if (audioType != other.audioType) return false
        if (audioTypeControl != other.audioTypeControl) return false
        if (codecSettings != other.codecSettings) return false
        if (customLanguageCode != other.customLanguageCode) return false
        if (languageCode != other.languageCode) return false
        if (languageCodeControl != other.languageCodeControl) return false
        if (remixSettings != other.remixSettings) return false
        if (streamName != other.streamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AudioDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * When you mimic a multi-channel audio layout with multiple mono-channel tracks, you can tag each channel layout manually. For example, you would tag the tracks that contain your left, right, and center audio with Left (L), Right (R), and Center (C), respectively. When you don't specify a value, MediaConvert labels your track as Center (C) by default. To use audio layout tagging, your output must be in a QuickTime (.mov) container; your audio codec must be AAC, WAV, or AIFF; and you must set up your audio track to have only one channel.
         */
        var audioChannelTaggingSettings: aws.sdk.kotlin.services.mediaconvert.model.AudioChannelTaggingSettings? = null
        /**
         * Advanced audio normalization settings. Ignore these settings unless you need to comply with a loudness standard.
         */
        var audioNormalizationSettings: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings? = null
        /**
         * Specifies which audio data to use from each input. In the simplest case, specify an "Audio Selector":#inputs-audio_selector by name based on its order within each input. For example if you specify "Audio Selector 3", then the third audio selector will be used from each input. If an input does not have an "Audio Selector 3", then the audio selector marked as "default" in that input will be used. If there is no audio selector marked as "default", silence will be inserted for the duration of that input. Alternatively, an "Audio Selector Group":#inputs-audio_selector_group name may be specified, with similar default/silence behavior. If no audio_source_name is specified, then "Audio Selector 1" will be chosen automatically.
         */
        var audioSourceName: kotlin.String? = null
        /**
         * Applies only if Follow Input Audio Type is unchecked (false). A number between 0 and 255. The following are defined in ISO-IEC 13818-1: 0 = Undefined, 1 = Clean Effects, 2 = Hearing Impaired, 3 = Visually Impaired Commentary, 4-255 = Reserved.
         */
        var audioType: kotlin.Int? = null
        /**
         * When set to FOLLOW_INPUT, if the input contains an ISO 639 audio_type, then that value is passed through to the output. If the input contains no ISO 639 audio_type, the value in Audio Type is included in the output. Otherwise the value in Audio Type is included in the output. Note that this field and audioType are both ignored if audioDescriptionBroadcasterMix is set to BROADCASTER_MIXED_AD.
         */
        var audioTypeControl: aws.sdk.kotlin.services.mediaconvert.model.AudioTypeControl? = null
        /**
         * Settings related to audio encoding. The settings in this group vary depending on the value that you choose for your audio codec.
         */
        var codecSettings: aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings? = null
        /**
         * Specify the language for this audio output track. The service puts this language code into your output audio track when you set Language code control (AudioLanguageCodeControl) to Use configured (USE_CONFIGURED). The service also uses your specified custom language code when you set Language code control (AudioLanguageCodeControl) to Follow input (FOLLOW_INPUT), but your input file doesn't specify a language code. For all outputs, you can use an ISO 639-2 or ISO 639-3 code. For streaming outputs, you can also use any other code in the full RFC-5646 specification. Streaming outputs are those that are in one of the following output groups: CMAF, DASH ISO, Apple HLS, or Microsoft Smooth Streaming.
         */
        var customLanguageCode: kotlin.String? = null
        /**
         * Indicates the language of the audio output track. The ISO 639 language specified in the 'Language Code' drop down will be used when 'Follow Input Language Code' is not selected or when 'Follow Input Language Code' is selected but there is no ISO 639 language code specified by the input.
         */
        var languageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = null
        /**
         * Specify which source for language code takes precedence for this audio track. When you choose Follow input (FOLLOW_INPUT), the service uses the language code from the input track if it's present. If there's no languge code on the input track, the service uses the code that you specify in the setting Language code (languageCode or customLanguageCode). When you choose Use configured (USE_CONFIGURED), the service uses the language code that you specify.
         */
        var languageCodeControl: aws.sdk.kotlin.services.mediaconvert.model.AudioLanguageCodeControl? = null
        /**
         * Advanced audio remixing settings.
         */
        var remixSettings: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings? = null
        /**
         * Specify a label for this output audio stream. For example, "English", "Director commentary", or "track_2". For streaming outputs, MediaConvert passes this information into destination manifests for display on the end-viewer's player device. For outputs in other output groups, the service ignores this setting.
         */
        var streamName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AudioDescription) : this() {
            this.audioChannelTaggingSettings = x.audioChannelTaggingSettings
            this.audioNormalizationSettings = x.audioNormalizationSettings
            this.audioSourceName = x.audioSourceName
            this.audioType = x.audioType
            this.audioTypeControl = x.audioTypeControl
            this.codecSettings = x.codecSettings
            this.customLanguageCode = x.customLanguageCode
            this.languageCode = x.languageCode
            this.languageCodeControl = x.languageCodeControl
            this.remixSettings = x.remixSettings
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AudioDescription = AudioDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AudioChannelTaggingSettings] inside the given [block]
         */
        fun audioChannelTaggingSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AudioChannelTaggingSettings.Builder.() -> kotlin.Unit) {
            this.audioChannelTaggingSettings = aws.sdk.kotlin.services.mediaconvert.model.AudioChannelTaggingSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings] inside the given [block]
         */
        fun audioNormalizationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings.Builder.() -> kotlin.Unit) {
            this.audioNormalizationSettings = aws.sdk.kotlin.services.mediaconvert.model.AudioNormalizationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings] inside the given [block]
         */
        fun codecSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings.Builder.() -> kotlin.Unit) {
            this.codecSettings = aws.sdk.kotlin.services.mediaconvert.model.AudioCodecSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.RemixSettings] inside the given [block]
         */
        fun remixSettings(block: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings.Builder.() -> kotlin.Unit) {
            this.remixSettings = aws.sdk.kotlin.services.mediaconvert.model.RemixSettings.invoke(block)
        }
    }
}
