// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your outputs. You can use multiple Audio selectors per input.
 */
class AudioSelector private constructor(builder: Builder) {
    /**
     * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the audio timing in your input and determines which correction setting to use, if needed. * Track: Adjust the duration of each audio frame by a constant amount to align the audio track length with STTS duration. Track-level correction does not affect pitch, and is recommended for tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a variable amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames. Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio content such as speech or percussion.
     */
    val audioDurationCorrection: aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection? = builder.audioDurationCorrection
    /**
     * Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter language code
     */
    val customLanguageCode: kotlin.String? = builder.customLanguageCode
    /**
     * Enable this setting on one audio selector to set it as the default for the job. The service uses this default for outputs where it can't find the specified input audio. If you don't set a default, those outputs have no audio.
     */
    val defaultSelection: aws.sdk.kotlin.services.mediaconvert.model.AudioDefaultSelection? = builder.defaultSelection
    /**
     * Specifies audio data from an external file source.
     */
    val externalAudioFileInput: kotlin.String? = builder.externalAudioFileInput
    /**
     * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among the alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are specified, the default audio track within the video segment is chosen. If there is no audio within video segment, the alternative audio with DEFAULT=YES is chosen instead.
     */
    val hlsRenditionGroupSettings: aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings? = builder.hlsRenditionGroupSettings
    /**
     * Selects a specific language code from within an audio source.
     */
    val languageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = builder.languageCode
    /**
     * Specifies a time delta in milliseconds to offset the audio from the input video.
     */
    val offset: kotlin.Int? = builder.offset
    /**
     * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
     */
    val pids: List<Int>? = builder.pids
    /**
     * Use this setting for input streams that contain Dolby E, to have the service extract specific program data from the track. To select multiple programs, create multiple selectors with the same Track and different Program numbers. In the console, this setting is visible when you set Selector type to Track. Choose the program number from the dropdown list. If you are sending a JSON file, provide the program ID, which is part of the audio metadata. If your input file has incorrect metadata, you can choose All channels instead of a program number to have the service ignore the program IDs and include all the programs in the track.
     */
    val programSelection: kotlin.Int? = builder.programSelection
    /**
     * Use these settings to reorder the audio channels of one input to match those of another input. This allows you to combine the two files into a single output, one after the other.
     */
    val remixSettings: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings? = builder.remixSettings
    /**
     * Specifies the type of the audio selector.
     */
    val selectorType: aws.sdk.kotlin.services.mediaconvert.model.AudioSelectorType? = builder.selectorType
    /**
     * Identify a track from the input audio to include in this selector by entering the track index number. To include several tracks in a single audio selector, specify multiple tracks as follows. Using the console, enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly in your JSON job file, provide the track numbers in an array. For example, "tracks": &#91;1,2,3&#93;.
     */
    val tracks: List<Int>? = builder.tracks

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AudioSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioSelector(")
        append("audioDurationCorrection=$audioDurationCorrection,")
        append("customLanguageCode=$customLanguageCode,")
        append("defaultSelection=$defaultSelection,")
        append("externalAudioFileInput=$externalAudioFileInput,")
        append("hlsRenditionGroupSettings=$hlsRenditionGroupSettings,")
        append("languageCode=$languageCode,")
        append("offset=$offset,")
        append("pids=$pids,")
        append("programSelection=$programSelection,")
        append("remixSettings=$remixSettings,")
        append("selectorType=$selectorType,")
        append("tracks=$tracks)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioDurationCorrection?.hashCode() ?: 0
        result = 31 * result + (customLanguageCode?.hashCode() ?: 0)
        result = 31 * result + (defaultSelection?.hashCode() ?: 0)
        result = 31 * result + (externalAudioFileInput?.hashCode() ?: 0)
        result = 31 * result + (hlsRenditionGroupSettings?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (offset ?: 0)
        result = 31 * result + (pids?.hashCode() ?: 0)
        result = 31 * result + (programSelection ?: 0)
        result = 31 * result + (remixSettings?.hashCode() ?: 0)
        result = 31 * result + (selectorType?.hashCode() ?: 0)
        result = 31 * result + (tracks?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioSelector

        if (audioDurationCorrection != other.audioDurationCorrection) return false
        if (customLanguageCode != other.customLanguageCode) return false
        if (defaultSelection != other.defaultSelection) return false
        if (externalAudioFileInput != other.externalAudioFileInput) return false
        if (hlsRenditionGroupSettings != other.hlsRenditionGroupSettings) return false
        if (languageCode != other.languageCode) return false
        if (offset != other.offset) return false
        if (pids != other.pids) return false
        if (programSelection != other.programSelection) return false
        if (remixSettings != other.remixSettings) return false
        if (selectorType != other.selectorType) return false
        if (tracks != other.tracks) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AudioSelector = Builder(this).apply(block).build()

    class Builder {
        /**
         * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the audio timing in your input and determines which correction setting to use, if needed. * Track: Adjust the duration of each audio frame by a constant amount to align the audio track length with STTS duration. Track-level correction does not affect pitch, and is recommended for tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a variable amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames. Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio content such as speech or percussion.
         */
        var audioDurationCorrection: aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection? = null
        /**
         * Selects a specific language code from within an audio source, using the ISO 639-2 or ISO 639-3 three-letter language code
         */
        var customLanguageCode: kotlin.String? = null
        /**
         * Enable this setting on one audio selector to set it as the default for the job. The service uses this default for outputs where it can't find the specified input audio. If you don't set a default, those outputs have no audio.
         */
        var defaultSelection: aws.sdk.kotlin.services.mediaconvert.model.AudioDefaultSelection? = null
        /**
         * Specifies audio data from an external file source.
         */
        var externalAudioFileInput: kotlin.String? = null
        /**
         * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique audio track among the alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks match the properties provided, the job fails. If no properties in hlsRenditionGroupSettings are specified, the default audio track within the video segment is chosen. If there is no audio within video segment, the alternative audio with DEFAULT=YES is chosen instead.
         */
        var hlsRenditionGroupSettings: aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings? = null
        /**
         * Selects a specific language code from within an audio source.
         */
        var languageCode: aws.sdk.kotlin.services.mediaconvert.model.LanguageCode? = null
        /**
         * Specifies a time delta in milliseconds to offset the audio from the input video.
         */
        var offset: kotlin.Int? = null
        /**
         * Selects a specific PID from within an audio source (e.g. 257 selects PID 0x101).
         */
        var pids: List<Int>? = null
        /**
         * Use this setting for input streams that contain Dolby E, to have the service extract specific program data from the track. To select multiple programs, create multiple selectors with the same Track and different Program numbers. In the console, this setting is visible when you set Selector type to Track. Choose the program number from the dropdown list. If you are sending a JSON file, provide the program ID, which is part of the audio metadata. If your input file has incorrect metadata, you can choose All channels instead of a program number to have the service ignore the program IDs and include all the programs in the track.
         */
        var programSelection: kotlin.Int? = null
        /**
         * Use these settings to reorder the audio channels of one input to match those of another input. This allows you to combine the two files into a single output, one after the other.
         */
        var remixSettings: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings? = null
        /**
         * Specifies the type of the audio selector.
         */
        var selectorType: aws.sdk.kotlin.services.mediaconvert.model.AudioSelectorType? = null
        /**
         * Identify a track from the input audio to include in this selector by entering the track index number. To include several tracks in a single audio selector, specify multiple tracks as follows. Using the console, enter a comma-separated list. For examle, type "1,2,3" to include tracks 1 through 3. Specifying directly in your JSON job file, provide the track numbers in an array. For example, "tracks": &#91;1,2,3&#93;.
         */
        var tracks: List<Int>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AudioSelector) : this() {
            this.audioDurationCorrection = x.audioDurationCorrection
            this.customLanguageCode = x.customLanguageCode
            this.defaultSelection = x.defaultSelection
            this.externalAudioFileInput = x.externalAudioFileInput
            this.hlsRenditionGroupSettings = x.hlsRenditionGroupSettings
            this.languageCode = x.languageCode
            this.offset = x.offset
            this.pids = x.pids
            this.programSelection = x.programSelection
            this.remixSettings = x.remixSettings
            this.selectorType = x.selectorType
            this.tracks = x.tracks
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AudioSelector = AudioSelector(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings] inside the given [block]
         */
        fun hlsRenditionGroupSettings(block: aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings.Builder.() -> kotlin.Unit) {
            this.hlsRenditionGroupSettings = aws.sdk.kotlin.services.mediaconvert.model.HlsRenditionGroupSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.RemixSettings] inside the given [block]
         */
        fun remixSettings(block: aws.sdk.kotlin.services.mediaconvert.model.RemixSettings.Builder.() -> kotlin.Unit) {
            this.remixSettings = aws.sdk.kotlin.services.mediaconvert.model.RemixSettings.invoke(block)
        }
    }
}
