// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Specify one or more Automated ABR rule types. Note: Force include and Allowed renditions are mutually exclusive.
 */
class AutomatedAbrRule private constructor(builder: Builder) {
    /**
     * When customer adds the allowed renditions rule for auto ABR ladder, they are required to add at leat one rendition to allowedRenditions list
     */
    val allowedRenditions: List<AllowedRenditionSize>? = builder.allowedRenditions
    /**
     * When customer adds the force include renditions rule for auto ABR ladder, they are required to add at leat one rendition to forceIncludeRenditions list
     */
    val forceIncludeRenditions: List<ForceIncludeRenditionSize>? = builder.forceIncludeRenditions
    /**
     * Use Min bottom rendition size to specify a minimum size for the lowest resolution in your ABR stack. * The lowest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 640x360 the lowest resolution in your ABR stack will be equal to or greater than to 640x360. * If you specify a Min top rendition size rule, the value that you specify for Min bottom rendition size must be less than, or equal to, Min top rendition size.
     */
    val minBottomRenditionSize: aws.sdk.kotlin.services.mediaconvert.model.MinBottomRenditionSize? = builder.minBottomRenditionSize
    /**
     * Use Min top rendition size to specify a minimum size for the highest resolution in your ABR stack. * The highest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 1280x720 the highest resolution in your ABR stack will be equal to or greater than 1280x720. * If you specify a value for Max resolution, the value that you specify for Min top rendition size must be less than, or equal to, Max resolution.
     */
    val minTopRenditionSize: aws.sdk.kotlin.services.mediaconvert.model.MinTopRenditionSize? = builder.minTopRenditionSize
    /**
     * Use Min top rendition size to specify a minimum size for the highest resolution in your ABR stack. * The highest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 1280x720 the highest resolution in your ABR stack will be equal to or greater than 1280x720. * If you specify a value for Max resolution, the value that you specify for Min top rendition size must be less than, or equal to, Max resolution. Use Min bottom rendition size to specify a minimum size for the lowest resolution in your ABR stack. * The lowest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 640x360 the lowest resolution in your ABR stack will be equal to or greater than to 640x360. * If you specify a Min top rendition size rule, the value that you specify for Min bottom rendition size must be less than, or equal to, Min top rendition size. Use Force include renditions to specify one or more resolutions to include your ABR stack. * (Recommended) To optimize automated ABR, specify as few resolutions as possible. * (Required) The number of resolutions that you specify must be equal to, or less than, the Max renditions setting. * If you specify a Min top rendition size rule, specify at least one resolution that is equal to, or greater than, Min top rendition size. * If you specify a Min bottom rendition size rule, only specify resolutions that are equal to, or greater than, Min bottom rendition size. * If you specify a Force include renditions rule, do not specify a separate rule for Allowed renditions. * Note: The ABR stack may include other resolutions that you do not specify here, depending on the Max renditions setting. Use Allowed renditions to specify a list of possible resolutions in your ABR stack. * (Required) The number of resolutions that you specify must be equal to, or greater than, the Max renditions setting. * MediaConvert will create an ABR stack exclusively from the list of resolutions that you specify. * Some resolutions in the Allowed renditions list may not be included, however you can force a resolution to be included by setting Required to ENABLED. * You must specify at least one resolution that is greater than or equal to any resolutions that you specify in Min top rendition size or Min bottom rendition size. * If you specify Allowed renditions, you must not specify a separate rule for Force include renditions.
     */
    val type: aws.sdk.kotlin.services.mediaconvert.model.RuleType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomatedAbrRule(")
        append("allowedRenditions=$allowedRenditions,")
        append("forceIncludeRenditions=$forceIncludeRenditions,")
        append("minBottomRenditionSize=$minBottomRenditionSize,")
        append("minTopRenditionSize=$minTopRenditionSize,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedRenditions?.hashCode() ?: 0
        result = 31 * result + (forceIncludeRenditions?.hashCode() ?: 0)
        result = 31 * result + (minBottomRenditionSize?.hashCode() ?: 0)
        result = 31 * result + (minTopRenditionSize?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomatedAbrRule

        if (allowedRenditions != other.allowedRenditions) return false
        if (forceIncludeRenditions != other.forceIncludeRenditions) return false
        if (minBottomRenditionSize != other.minBottomRenditionSize) return false
        if (minTopRenditionSize != other.minTopRenditionSize) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * When customer adds the allowed renditions rule for auto ABR ladder, they are required to add at leat one rendition to allowedRenditions list
         */
        var allowedRenditions: List<AllowedRenditionSize>? = null
        /**
         * When customer adds the force include renditions rule for auto ABR ladder, they are required to add at leat one rendition to forceIncludeRenditions list
         */
        var forceIncludeRenditions: List<ForceIncludeRenditionSize>? = null
        /**
         * Use Min bottom rendition size to specify a minimum size for the lowest resolution in your ABR stack. * The lowest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 640x360 the lowest resolution in your ABR stack will be equal to or greater than to 640x360. * If you specify a Min top rendition size rule, the value that you specify for Min bottom rendition size must be less than, or equal to, Min top rendition size.
         */
        var minBottomRenditionSize: aws.sdk.kotlin.services.mediaconvert.model.MinBottomRenditionSize? = null
        /**
         * Use Min top rendition size to specify a minimum size for the highest resolution in your ABR stack. * The highest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 1280x720 the highest resolution in your ABR stack will be equal to or greater than 1280x720. * If you specify a value for Max resolution, the value that you specify for Min top rendition size must be less than, or equal to, Max resolution.
         */
        var minTopRenditionSize: aws.sdk.kotlin.services.mediaconvert.model.MinTopRenditionSize? = null
        /**
         * Use Min top rendition size to specify a minimum size for the highest resolution in your ABR stack. * The highest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 1280x720 the highest resolution in your ABR stack will be equal to or greater than 1280x720. * If you specify a value for Max resolution, the value that you specify for Min top rendition size must be less than, or equal to, Max resolution. Use Min bottom rendition size to specify a minimum size for the lowest resolution in your ABR stack. * The lowest resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify 640x360 the lowest resolution in your ABR stack will be equal to or greater than to 640x360. * If you specify a Min top rendition size rule, the value that you specify for Min bottom rendition size must be less than, or equal to, Min top rendition size. Use Force include renditions to specify one or more resolutions to include your ABR stack. * (Recommended) To optimize automated ABR, specify as few resolutions as possible. * (Required) The number of resolutions that you specify must be equal to, or less than, the Max renditions setting. * If you specify a Min top rendition size rule, specify at least one resolution that is equal to, or greater than, Min top rendition size. * If you specify a Min bottom rendition size rule, only specify resolutions that are equal to, or greater than, Min bottom rendition size. * If you specify a Force include renditions rule, do not specify a separate rule for Allowed renditions. * Note: The ABR stack may include other resolutions that you do not specify here, depending on the Max renditions setting. Use Allowed renditions to specify a list of possible resolutions in your ABR stack. * (Required) The number of resolutions that you specify must be equal to, or greater than, the Max renditions setting. * MediaConvert will create an ABR stack exclusively from the list of resolutions that you specify. * Some resolutions in the Allowed renditions list may not be included, however you can force a resolution to be included by setting Required to ENABLED. * You must specify at least one resolution that is greater than or equal to any resolutions that you specify in Min top rendition size or Min bottom rendition size. * If you specify Allowed renditions, you must not specify a separate rule for Force include renditions.
         */
        var type: aws.sdk.kotlin.services.mediaconvert.model.RuleType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrRule) : this() {
            this.allowedRenditions = x.allowedRenditions
            this.forceIncludeRenditions = x.forceIncludeRenditions
            this.minBottomRenditionSize = x.minBottomRenditionSize
            this.minTopRenditionSize = x.minTopRenditionSize
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrRule = AutomatedAbrRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MinBottomRenditionSize] inside the given [block]
         */
        fun minBottomRenditionSize(block: aws.sdk.kotlin.services.mediaconvert.model.MinBottomRenditionSize.Builder.() -> kotlin.Unit) {
            this.minBottomRenditionSize = aws.sdk.kotlin.services.mediaconvert.model.MinBottomRenditionSize.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MinTopRenditionSize] inside the given [block]
         */
        fun minTopRenditionSize(block: aws.sdk.kotlin.services.mediaconvert.model.MinTopRenditionSize.Builder.() -> kotlin.Unit) {
            this.minTopRenditionSize = aws.sdk.kotlin.services.mediaconvert.model.MinTopRenditionSize.invoke(block)
        }
    }
}
