// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for quality-defined variable bitrate encoding with the AV1 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
 */
class Av1QvbrSettings private constructor(builder: Builder) {
    /**
     * Use this setting only when you set Rate control mode (RateControlMode) to QVBR. Specify the target quality level for this output. MediaConvert determines the right number of bits to use for each part of the video to maintain the video quality that you specify. When you keep the default value, AUTO, MediaConvert picks a quality level for you, based on characteristics of your input video. If you prefer to specify a quality level, specify a number from 1 through 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
     */
    val qvbrQualityLevel: kotlin.Int? = builder.qvbrQualityLevel
    /**
     * Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
     */
    val qvbrQualityLevelFineTune: kotlin.Double? = builder.qvbrQualityLevelFineTune

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Av1QvbrSettings(")
        append("qvbrQualityLevel=$qvbrQualityLevel,")
        append("qvbrQualityLevelFineTune=$qvbrQualityLevelFineTune)")
    }

    override fun hashCode(): kotlin.Int {
        var result = qvbrQualityLevel ?: 0
        result = 31 * result + (qvbrQualityLevelFineTune?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Av1QvbrSettings

        if (qvbrQualityLevel != other.qvbrQualityLevel) return false
        if (qvbrQualityLevelFineTune != other.qvbrQualityLevelFineTune) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Use this setting only when you set Rate control mode (RateControlMode) to QVBR. Specify the target quality level for this output. MediaConvert determines the right number of bits to use for each part of the video to maintain the video quality that you specify. When you keep the default value, AUTO, MediaConvert picks a quality level for you, based on characteristics of your input video. If you prefer to specify a quality level, specify a number from 1 through 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
         */
        var qvbrQualityLevel: kotlin.Int? = null
        /**
         * Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
         */
        var qvbrQualityLevelFineTune: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings) : this() {
            this.qvbrQualityLevel = x.qvbrQualityLevel
            this.qvbrQualityLevelFineTune = x.qvbrQualityLevelFineTune
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings = Av1QvbrSettings(this)
    }
}
