// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to one captions tab on the MediaConvert console. In your job JSON, an instance of captions DestinationSettings is equivalent to one captions tab in the console. Usually, one captions tab corresponds to one output captions track. Depending on your output captions format, one tab might correspond to a set of output captions tracks. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/including-captions.html.
 */
class CaptionDestinationSettings private constructor(builder: Builder) {
    /**
     * Burn-in is a captions delivery method, rather than a captions format. Burn-in writes the captions directly on your video frames, replacing pixels of video content with the captions. Set up burn-in captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to BURN_IN.
     */
    val burninDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings? = builder.burninDestinationSettings
    /**
     * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Note that your choice of video output container constrains your choice of output captions format. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
     */
    val destinationType: aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationType? = builder.destinationType
    /**
     * Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to DVB_SUB.
     */
    val dvbSubDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings? = builder.dvbSubDestinationSettings
    /**
     * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
     */
    val embeddedDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings? = builder.embeddedDestinationSettings
    /**
     * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to IMSC.
     */
    val imscDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings? = builder.imscDestinationSettings
    /**
     * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to SCC.
     */
    val sccDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings? = builder.sccDestinationSettings
    /**
     * Settings related to SRT captions. SRT is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to SRT.
     */
    val srtDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.SrtDestinationSettings? = builder.srtDestinationSettings
    /**
     * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to TELETEXT.
     */
    val teletextDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings? = builder.teletextDestinationSettings
    /**
     * Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to TTML.
     */
    val ttmlDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.TtmlDestinationSettings? = builder.ttmlDestinationSettings
    /**
     * Settings related to WebVTT captions. WebVTT is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to WebVTT.
     */
    val webvttDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings? = builder.webvttDestinationSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CaptionDestinationSettings(")
        append("burninDestinationSettings=$burninDestinationSettings,")
        append("destinationType=$destinationType,")
        append("dvbSubDestinationSettings=$dvbSubDestinationSettings,")
        append("embeddedDestinationSettings=$embeddedDestinationSettings,")
        append("imscDestinationSettings=$imscDestinationSettings,")
        append("sccDestinationSettings=$sccDestinationSettings,")
        append("srtDestinationSettings=$srtDestinationSettings,")
        append("teletextDestinationSettings=$teletextDestinationSettings,")
        append("ttmlDestinationSettings=$ttmlDestinationSettings,")
        append("webvttDestinationSettings=$webvttDestinationSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = burninDestinationSettings?.hashCode() ?: 0
        result = 31 * result + (destinationType?.hashCode() ?: 0)
        result = 31 * result + (dvbSubDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (embeddedDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (imscDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (sccDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (srtDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (teletextDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (ttmlDestinationSettings?.hashCode() ?: 0)
        result = 31 * result + (webvttDestinationSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CaptionDestinationSettings

        if (burninDestinationSettings != other.burninDestinationSettings) return false
        if (destinationType != other.destinationType) return false
        if (dvbSubDestinationSettings != other.dvbSubDestinationSettings) return false
        if (embeddedDestinationSettings != other.embeddedDestinationSettings) return false
        if (imscDestinationSettings != other.imscDestinationSettings) return false
        if (sccDestinationSettings != other.sccDestinationSettings) return false
        if (srtDestinationSettings != other.srtDestinationSettings) return false
        if (teletextDestinationSettings != other.teletextDestinationSettings) return false
        if (ttmlDestinationSettings != other.ttmlDestinationSettings) return false
        if (webvttDestinationSettings != other.webvttDestinationSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Burn-in is a captions delivery method, rather than a captions format. Burn-in writes the captions directly on your video frames, replacing pixels of video content with the captions. Set up burn-in captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/burn-in-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to BURN_IN.
         */
        var burninDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings? = null
        /**
         * Specify the format for this set of captions on this output. The default format is embedded without SCTE-20. Note that your choice of video output container constrains your choice of output captions format. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/captions-support-tables.html. If you are using SCTE-20 and you want to create an output that complies with the SCTE-43 spec, choose SCTE-20 plus embedded (SCTE20_PLUS_EMBEDDED). To create a non-compliant output where the embedded captions come first, choose Embedded plus SCTE-20 (EMBEDDED_PLUS_SCTE20).
         */
        var destinationType: aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationType? = null
        /**
         * Settings related to DVB-Sub captions. Set up DVB-Sub captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to DVB_SUB.
         */
        var dvbSubDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings? = null
        /**
         * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to EMBEDDED, EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
         */
        var embeddedDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings? = null
        /**
         * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to IMSC.
         */
        var imscDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings? = null
        /**
         * Settings related to SCC captions. SCC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/scc-srt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to SCC.
         */
        var sccDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings? = null
        /**
         * Settings related to SRT captions. SRT is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to SRT.
         */
        var srtDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.SrtDestinationSettings? = null
        /**
         * Settings related to teletext captions. Set up teletext captions in the same output as your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/teletext-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to TELETEXT.
         */
        var teletextDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings? = null
        /**
         * Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to TTML.
         */
        var ttmlDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.TtmlDestinationSettings? = null
        /**
         * Settings related to WebVTT captions. WebVTT is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to WebVTT.
         */
        var webvttDestinationSettings: aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings) : this() {
            this.burninDestinationSettings = x.burninDestinationSettings
            this.destinationType = x.destinationType
            this.dvbSubDestinationSettings = x.dvbSubDestinationSettings
            this.embeddedDestinationSettings = x.embeddedDestinationSettings
            this.imscDestinationSettings = x.imscDestinationSettings
            this.sccDestinationSettings = x.sccDestinationSettings
            this.srtDestinationSettings = x.srtDestinationSettings
            this.teletextDestinationSettings = x.teletextDestinationSettings
            this.ttmlDestinationSettings = x.ttmlDestinationSettings
            this.webvttDestinationSettings = x.webvttDestinationSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CaptionDestinationSettings = CaptionDestinationSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings] inside the given [block]
         */
        fun burninDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings.Builder.() -> kotlin.Unit) {
            this.burninDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.BurninDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings] inside the given [block]
         */
        fun dvbSubDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings.Builder.() -> kotlin.Unit) {
            this.dvbSubDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.DvbSubDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings] inside the given [block]
         */
        fun embeddedDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings.Builder.() -> kotlin.Unit) {
            this.embeddedDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.EmbeddedDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings] inside the given [block]
         */
        fun imscDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings.Builder.() -> kotlin.Unit) {
            this.imscDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings] inside the given [block]
         */
        fun sccDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings.Builder.() -> kotlin.Unit) {
            this.sccDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.SccDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.SrtDestinationSettings] inside the given [block]
         */
        fun srtDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.SrtDestinationSettings.Builder.() -> kotlin.Unit) {
            this.srtDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.SrtDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings] inside the given [block]
         */
        fun teletextDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings.Builder.() -> kotlin.Unit) {
            this.teletextDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.TeletextDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.TtmlDestinationSettings] inside the given [block]
         */
        fun ttmlDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.TtmlDestinationSettings.Builder.() -> kotlin.Unit) {
            this.ttmlDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.TtmlDestinationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings] inside the given [block]
         */
        fun webvttDestinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings.Builder.() -> kotlin.Unit) {
            this.webvttDestinationSettings = aws.sdk.kotlin.services.mediaconvert.model.WebvttDestinationSettings.invoke(block)
        }
    }
}
