// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for color correction.
 */
class ColorCorrector private constructor(builder: Builder) {
    /**
     * Brightness level.
     */
    val brightness: kotlin.Int? = builder.brightness
    /**
     * Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
     */
    val colorSpaceConversion: aws.sdk.kotlin.services.mediaconvert.model.ColorSpaceConversion? = builder.colorSpaceConversion
    /**
     * Contrast level.
     */
    val contrast: kotlin.Int? = builder.contrast
    /**
     * Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
     */
    val hdr10Metadata: aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata? = builder.hdr10Metadata
    /**
     * Hue in degrees.
     */
    val hue: kotlin.Int? = builder.hue
    /**
     * Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
     */
    val sampleRangeConversion: aws.sdk.kotlin.services.mediaconvert.model.SampleRangeConversion? = builder.sampleRangeConversion
    /**
     * Saturation level.
     */
    val saturation: kotlin.Int? = builder.saturation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.ColorCorrector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ColorCorrector(")
        append("brightness=$brightness,")
        append("colorSpaceConversion=$colorSpaceConversion,")
        append("contrast=$contrast,")
        append("hdr10Metadata=$hdr10Metadata,")
        append("hue=$hue,")
        append("sampleRangeConversion=$sampleRangeConversion,")
        append("saturation=$saturation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brightness ?: 0
        result = 31 * result + (colorSpaceConversion?.hashCode() ?: 0)
        result = 31 * result + (contrast ?: 0)
        result = 31 * result + (hdr10Metadata?.hashCode() ?: 0)
        result = 31 * result + (hue ?: 0)
        result = 31 * result + (sampleRangeConversion?.hashCode() ?: 0)
        result = 31 * result + (saturation ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ColorCorrector

        if (brightness != other.brightness) return false
        if (colorSpaceConversion != other.colorSpaceConversion) return false
        if (contrast != other.contrast) return false
        if (hdr10Metadata != other.hdr10Metadata) return false
        if (hue != other.hue) return false
        if (sampleRangeConversion != other.sampleRangeConversion) return false
        if (saturation != other.saturation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.ColorCorrector = Builder(this).apply(block).build()

    class Builder {
        /**
         * Brightness level.
         */
        var brightness: kotlin.Int? = null
        /**
         * Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
         */
        var colorSpaceConversion: aws.sdk.kotlin.services.mediaconvert.model.ColorSpaceConversion? = null
        /**
         * Contrast level.
         */
        var contrast: kotlin.Int? = null
        /**
         * Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
         */
        var hdr10Metadata: aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata? = null
        /**
         * Hue in degrees.
         */
        var hue: kotlin.Int? = null
        /**
         * Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
         */
        var sampleRangeConversion: aws.sdk.kotlin.services.mediaconvert.model.SampleRangeConversion? = null
        /**
         * Saturation level.
         */
        var saturation: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.ColorCorrector) : this() {
            this.brightness = x.brightness
            this.colorSpaceConversion = x.colorSpaceConversion
            this.contrast = x.contrast
            this.hdr10Metadata = x.hdr10Metadata
            this.hue = x.hue
            this.sampleRangeConversion = x.sampleRangeConversion
            this.saturation = x.saturation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.ColorCorrector = ColorCorrector(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata] inside the given [block]
         */
        fun hdr10Metadata(block: aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata.Builder.() -> kotlin.Unit) {
            this.hdr10Metadata = aws.sdk.kotlin.services.mediaconvert.model.Hdr10Metadata.invoke(block)
        }
    }
}
