// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Specifies DRM settings for DASH outputs.
 */
class DashIsoEncryptionSettings private constructor(builder: Builder) {
    /**
     * This setting can improve the compatibility of your output with video players on obsolete devices. It applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI, for that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.
     */
    val playbackDeviceCompatibility: aws.sdk.kotlin.services.mediaconvert.model.DashIsoPlaybackDeviceCompatibility? = builder.playbackDeviceCompatibility
    /**
     * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
     */
    val spekeKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider? = builder.spekeKeyProvider

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DashIsoEncryptionSettings(")
        append("playbackDeviceCompatibility=$playbackDeviceCompatibility,")
        append("spekeKeyProvider=$spekeKeyProvider)")
    }

    override fun hashCode(): kotlin.Int {
        var result = playbackDeviceCompatibility?.hashCode() ?: 0
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DashIsoEncryptionSettings

        if (playbackDeviceCompatibility != other.playbackDeviceCompatibility) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * This setting can improve the compatibility of your output with video players on obsolete devices. It applies only to DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI, for that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.
         */
        var playbackDeviceCompatibility: aws.sdk.kotlin.services.mediaconvert.model.DashIsoPlaybackDeviceCompatibility? = null
        /**
         * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
         */
        var spekeKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings) : this() {
            this.playbackDeviceCompatibility = x.playbackDeviceCompatibility
            this.spekeKeyProvider = x.spekeKeyProvider
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.DashIsoEncryptionSettings = DashIsoEncryptionSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider] inside the given [block]
         */
        fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider.invoke(block)
        }
    }
}
