// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for H265 codec
 */
class H265Settings private constructor(builder: Builder) {
    /**
     * When you set Adaptive Quantization (H265AdaptiveQuantization) to Auto (AUTO), or leave blank, MediaConvert automatically applies quantization to improve the video quality of your output. Set Adaptive Quantization to Low (LOW), Medium (MEDIUM), High (HIGH), Higher (HIGHER), or Max (MAX) to manually control the strength of the quantization filter. When you do, you can specify a value for Spatial Adaptive Quantization (H265SpatialAdaptiveQuantization), Temporal Adaptive Quantization (H265TemporalAdaptiveQuantization), and Flicker Adaptive Quantization (H265FlickerAdaptiveQuantization), to further control the quantization filter. Set Adaptive Quantization to Off (OFF) to apply no quantization to your output.
     */
    val adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265AdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
     */
    val alternateTransferFunctionSei: aws.sdk.kotlin.services.mediaconvert.model.H265AlternateTransferFunctionSei? = builder.alternateTransferFunctionSei
    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * H.265 Level.
     */
    val codecLevel: aws.sdk.kotlin.services.mediaconvert.model.H265CodecLevel? = builder.codecLevel
    /**
     * Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as &#91;Profile&#93; / &#91;Tier&#93;, so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
     */
    val codecProfile: aws.sdk.kotlin.services.mediaconvert.model.H265CodecProfile? = builder.codecProfile
    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     */
    val dynamicSubGop: aws.sdk.kotlin.services.mediaconvert.model.H265DynamicSubGop? = builder.dynamicSubGop
    /**
     * Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
     */
    val flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265FlickerAdaptiveQuantization? = builder.flickerAdaptiveQuantization
    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
     */
    val framerateControl: aws.sdk.kotlin.services.mediaconvert.model.H265FramerateControl? = builder.framerateControl
    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
     */
    val framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.H265FramerateConversionAlgorithm? = builder.framerateConversionAlgorithm
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateDenominator: kotlin.Int? = builder.framerateDenominator
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateNumerator: kotlin.Int? = builder.framerateNumerator
    /**
     * If enable, use reference B frames for GOP structures that have B frames > 1.
     */
    val gopBReference: aws.sdk.kotlin.services.mediaconvert.model.H265GopBReference? = builder.gopBReference
    /**
     * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open GOPs and then require a closed GOP, set this value to 5. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. If you do explicitly specify a value, for segmented outputs, don't set this value to 0.
     */
    val gopClosedCadence: kotlin.Int? = builder.gopClosedCadence
    /**
     * Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of seconds. MediaConvert will interpret this value as frames or seconds depending on the value you choose for GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP size, leave GOP size blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS, DASH, or CMAF, leave GOP size blank and set GOP mode control to Auto in each output in your output group.
     */
    val gopSize: kotlin.Double? = builder.gopSize
    /**
     * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
     */
    val gopSizeUnits: aws.sdk.kotlin.services.mediaconvert.model.H265GopSizeUnits? = builder.gopSizeUnits
    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    val hrdBufferInitialFillPercentage: kotlin.Int? = builder.hrdBufferInitialFillPercentage
    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    val hrdBufferSize: kotlin.Int? = builder.hrdBufferSize
    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
     */
    val interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.H265InterlaceMode? = builder.interlaceMode
    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
     */
    val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. When you explicitly specify a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
     */
    val minIInterval: kotlin.Int? = builder.minIInterval
    /**
     * Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
     */
    val numberBFramesBetweenReferenceFrames: kotlin.Int? = builder.numberBFramesBetweenReferenceFrames
    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
     */
    val numberReferenceFrames: kotlin.Int? = builder.numberReferenceFrames
    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     */
    val parControl: aws.sdk.kotlin.services.mediaconvert.model.H265ParControl? = builder.parControl
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    val parDenominator: kotlin.Int? = builder.parDenominator
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    val parNumerator: kotlin.Int? = builder.parNumerator
    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     */
    val qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.H265QualityTuningLevel? = builder.qualityTuningLevel
    /**
     * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
     */
    val qvbrSettings: aws.sdk.kotlin.services.mediaconvert.model.H265QvbrSettings? = builder.qvbrSettings
    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
     */
    val rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.H265RateControlMode? = builder.rateControlMode
    /**
     * Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based on content
     */
    val sampleAdaptiveOffsetFilterMode: aws.sdk.kotlin.services.mediaconvert.model.H265SampleAdaptiveOffsetFilterMode? = builder.sampleAdaptiveOffsetFilterMode
    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     */
    val scanTypeConversionMode: aws.sdk.kotlin.services.mediaconvert.model.H265ScanTypeConversionMode? = builder.scanTypeConversionMode
    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     */
    val sceneChangeDetect: aws.sdk.kotlin.services.mediaconvert.model.H265SceneChangeDetect? = builder.sceneChangeDetect
    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    val slices: kotlin.Int? = builder.slices
    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     */
    val slowPal: aws.sdk.kotlin.services.mediaconvert.model.H265SlowPal? = builder.slowPal
    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     */
    val spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265SpatialAdaptiveQuantization? = builder.spatialAdaptiveQuantization
    /**
     * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
     */
    val telecine: aws.sdk.kotlin.services.mediaconvert.model.H265Telecine? = builder.telecine
    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
     */
    val temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265TemporalAdaptiveQuantization? = builder.temporalAdaptiveQuantization
    /**
     * Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
     */
    val temporalIds: aws.sdk.kotlin.services.mediaconvert.model.H265TemporalIds? = builder.temporalIds
    /**
     * Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
     */
    val tiles: aws.sdk.kotlin.services.mediaconvert.model.H265Tiles? = builder.tiles
    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     */
    val unregisteredSeiTimecode: aws.sdk.kotlin.services.mediaconvert.model.H265UnregisteredSeiTimecode? = builder.unregisteredSeiTimecode
    /**
     * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
     */
    val writeMp4PackagingType: aws.sdk.kotlin.services.mediaconvert.model.H265WriteMp4PackagingType? = builder.writeMp4PackagingType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.H265Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("H265Settings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("alternateTransferFunctionSei=$alternateTransferFunctionSei,")
        append("bitrate=$bitrate,")
        append("codecLevel=$codecLevel,")
        append("codecProfile=$codecProfile,")
        append("dynamicSubGop=$dynamicSubGop,")
        append("flickerAdaptiveQuantization=$flickerAdaptiveQuantization,")
        append("framerateControl=$framerateControl,")
        append("framerateConversionAlgorithm=$framerateConversionAlgorithm,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopBReference=$gopBReference,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("gopSize=$gopSize,")
        append("gopSizeUnits=$gopSizeUnits,")
        append("hrdBufferInitialFillPercentage=$hrdBufferInitialFillPercentage,")
        append("hrdBufferSize=$hrdBufferSize,")
        append("interlaceMode=$interlaceMode,")
        append("maxBitrate=$maxBitrate,")
        append("minIInterval=$minIInterval,")
        append("numberBFramesBetweenReferenceFrames=$numberBFramesBetweenReferenceFrames,")
        append("numberReferenceFrames=$numberReferenceFrames,")
        append("parControl=$parControl,")
        append("parDenominator=$parDenominator,")
        append("parNumerator=$parNumerator,")
        append("qualityTuningLevel=$qualityTuningLevel,")
        append("qvbrSettings=$qvbrSettings,")
        append("rateControlMode=$rateControlMode,")
        append("sampleAdaptiveOffsetFilterMode=$sampleAdaptiveOffsetFilterMode,")
        append("scanTypeConversionMode=$scanTypeConversionMode,")
        append("sceneChangeDetect=$sceneChangeDetect,")
        append("slices=$slices,")
        append("slowPal=$slowPal,")
        append("spatialAdaptiveQuantization=$spatialAdaptiveQuantization,")
        append("telecine=$telecine,")
        append("temporalAdaptiveQuantization=$temporalAdaptiveQuantization,")
        append("temporalIds=$temporalIds,")
        append("tiles=$tiles,")
        append("unregisteredSeiTimecode=$unregisteredSeiTimecode,")
        append("writeMp4PackagingType=$writeMp4PackagingType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (alternateTransferFunctionSei?.hashCode() ?: 0)
        result = 31 * result + (bitrate ?: 0)
        result = 31 * result + (codecLevel?.hashCode() ?: 0)
        result = 31 * result + (codecProfile?.hashCode() ?: 0)
        result = 31 * result + (dynamicSubGop?.hashCode() ?: 0)
        result = 31 * result + (flickerAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateConversionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator ?: 0)
        result = 31 * result + (framerateNumerator ?: 0)
        result = 31 * result + (gopBReference?.hashCode() ?: 0)
        result = 31 * result + (gopClosedCadence ?: 0)
        result = 31 * result + (gopSize?.hashCode() ?: 0)
        result = 31 * result + (gopSizeUnits?.hashCode() ?: 0)
        result = 31 * result + (hrdBufferInitialFillPercentage ?: 0)
        result = 31 * result + (hrdBufferSize ?: 0)
        result = 31 * result + (interlaceMode?.hashCode() ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (minIInterval ?: 0)
        result = 31 * result + (numberBFramesBetweenReferenceFrames ?: 0)
        result = 31 * result + (numberReferenceFrames ?: 0)
        result = 31 * result + (parControl?.hashCode() ?: 0)
        result = 31 * result + (parDenominator ?: 0)
        result = 31 * result + (parNumerator ?: 0)
        result = 31 * result + (qualityTuningLevel?.hashCode() ?: 0)
        result = 31 * result + (qvbrSettings?.hashCode() ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        result = 31 * result + (sampleAdaptiveOffsetFilterMode?.hashCode() ?: 0)
        result = 31 * result + (scanTypeConversionMode?.hashCode() ?: 0)
        result = 31 * result + (sceneChangeDetect?.hashCode() ?: 0)
        result = 31 * result + (slices ?: 0)
        result = 31 * result + (slowPal?.hashCode() ?: 0)
        result = 31 * result + (spatialAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (telecine?.hashCode() ?: 0)
        result = 31 * result + (temporalAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (temporalIds?.hashCode() ?: 0)
        result = 31 * result + (tiles?.hashCode() ?: 0)
        result = 31 * result + (unregisteredSeiTimecode?.hashCode() ?: 0)
        result = 31 * result + (writeMp4PackagingType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as H265Settings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (alternateTransferFunctionSei != other.alternateTransferFunctionSei) return false
        if (bitrate != other.bitrate) return false
        if (codecLevel != other.codecLevel) return false
        if (codecProfile != other.codecProfile) return false
        if (dynamicSubGop != other.dynamicSubGop) return false
        if (flickerAdaptiveQuantization != other.flickerAdaptiveQuantization) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateConversionAlgorithm != other.framerateConversionAlgorithm) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopBReference != other.gopBReference) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (gopSize != other.gopSize) return false
        if (gopSizeUnits != other.gopSizeUnits) return false
        if (hrdBufferInitialFillPercentage != other.hrdBufferInitialFillPercentage) return false
        if (hrdBufferSize != other.hrdBufferSize) return false
        if (interlaceMode != other.interlaceMode) return false
        if (maxBitrate != other.maxBitrate) return false
        if (minIInterval != other.minIInterval) return false
        if (numberBFramesBetweenReferenceFrames != other.numberBFramesBetweenReferenceFrames) return false
        if (numberReferenceFrames != other.numberReferenceFrames) return false
        if (parControl != other.parControl) return false
        if (parDenominator != other.parDenominator) return false
        if (parNumerator != other.parNumerator) return false
        if (qualityTuningLevel != other.qualityTuningLevel) return false
        if (qvbrSettings != other.qvbrSettings) return false
        if (rateControlMode != other.rateControlMode) return false
        if (sampleAdaptiveOffsetFilterMode != other.sampleAdaptiveOffsetFilterMode) return false
        if (scanTypeConversionMode != other.scanTypeConversionMode) return false
        if (sceneChangeDetect != other.sceneChangeDetect) return false
        if (slices != other.slices) return false
        if (slowPal != other.slowPal) return false
        if (spatialAdaptiveQuantization != other.spatialAdaptiveQuantization) return false
        if (telecine != other.telecine) return false
        if (temporalAdaptiveQuantization != other.temporalAdaptiveQuantization) return false
        if (temporalIds != other.temporalIds) return false
        if (tiles != other.tiles) return false
        if (unregisteredSeiTimecode != other.unregisteredSeiTimecode) return false
        if (writeMp4PackagingType != other.writeMp4PackagingType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.H265Settings = Builder(this).apply(block).build()

    class Builder {
        /**
         * When you set Adaptive Quantization (H265AdaptiveQuantization) to Auto (AUTO), or leave blank, MediaConvert automatically applies quantization to improve the video quality of your output. Set Adaptive Quantization to Low (LOW), Medium (MEDIUM), High (HIGH), Higher (HIGHER), or Max (MAX) to manually control the strength of the quantization filter. When you do, you can specify a value for Spatial Adaptive Quantization (H265SpatialAdaptiveQuantization), Temporal Adaptive Quantization (H265TemporalAdaptiveQuantization), and Flicker Adaptive Quantization (H265FlickerAdaptiveQuantization), to further control the quantization filter. Set Adaptive Quantization to Off (OFF) to apply no quantization to your output.
         */
        var adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265AdaptiveQuantization? = null
        /**
         * Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
         */
        var alternateTransferFunctionSei: aws.sdk.kotlin.services.mediaconvert.model.H265AlternateTransferFunctionSei? = null
        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
         */
        var bitrate: kotlin.Int? = null
        /**
         * H.265 Level.
         */
        var codecLevel: aws.sdk.kotlin.services.mediaconvert.model.H265CodecLevel? = null
        /**
         * Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as &#91;Profile&#93; / &#91;Tier&#93;, so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
         */
        var codecProfile: aws.sdk.kotlin.services.mediaconvert.model.H265CodecProfile? = null
        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         */
        var dynamicSubGop: aws.sdk.kotlin.services.mediaconvert.model.H265DynamicSubGop? = null
        /**
         * Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
         */
        var flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265FlickerAdaptiveQuantization? = null
        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         */
        var framerateControl: aws.sdk.kotlin.services.mediaconvert.model.H265FramerateControl? = null
        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         */
        var framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.H265FramerateConversionAlgorithm? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateDenominator: kotlin.Int? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateNumerator: kotlin.Int? = null
        /**
         * If enable, use reference B frames for GOP structures that have B frames > 1.
         */
        var gopBReference: aws.sdk.kotlin.services.mediaconvert.model.H265GopBReference? = null
        /**
         * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open GOPs and then require a closed GOP, set this value to 5. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. If you do explicitly specify a value, for segmented outputs, don't set this value to 0.
         */
        var gopClosedCadence: kotlin.Int? = null
        /**
         * Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of seconds. MediaConvert will interpret this value as frames or seconds depending on the value you choose for GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP size, leave GOP size blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS, DASH, or CMAF, leave GOP size blank and set GOP mode control to Auto in each output in your output group.
         */
        var gopSize: kotlin.Double? = null
        /**
         * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
         */
        var gopSizeUnits: aws.sdk.kotlin.services.mediaconvert.model.H265GopSizeUnits? = null
        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         */
        var hrdBufferInitialFillPercentage: kotlin.Int? = null
        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         */
        var hrdBufferSize: kotlin.Int? = null
        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
         */
        var interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.H265InterlaceMode? = null
        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
         */
        var maxBitrate: kotlin.Int? = null
        /**
         * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. When you explicitly specify a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
         */
        var minIInterval: kotlin.Int? = null
        /**
         * Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
         */
        var numberBFramesBetweenReferenceFrames: kotlin.Int? = null
        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
         */
        var numberReferenceFrames: kotlin.Int? = null
        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
         */
        var parControl: aws.sdk.kotlin.services.mediaconvert.model.H265ParControl? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         */
        var parDenominator: kotlin.Int? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         */
        var parNumerator: kotlin.Int? = null
        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         */
        var qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.H265QualityTuningLevel? = null
        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
         */
        var qvbrSettings: aws.sdk.kotlin.services.mediaconvert.model.H265QvbrSettings? = null
        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
         */
        var rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.H265RateControlMode? = null
        /**
         * Specify Sample Adaptive Offset (SAO) filter strength. Adaptive mode dynamically selects best strength based on content
         */
        var sampleAdaptiveOffsetFilterMode: aws.sdk.kotlin.services.mediaconvert.model.H265SampleAdaptiveOffsetFilterMode? = null
        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         */
        var scanTypeConversionMode: aws.sdk.kotlin.services.mediaconvert.model.H265ScanTypeConversionMode? = null
        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         */
        var sceneChangeDetect: aws.sdk.kotlin.services.mediaconvert.model.H265SceneChangeDetect? = null
        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         */
        var slices: kotlin.Int? = null
        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
         */
        var slowPal: aws.sdk.kotlin.services.mediaconvert.model.H265SlowPal? = null
        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         */
        var spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265SpatialAdaptiveQuantization? = null
        /**
         * This field applies only if the Streams > Advanced > Framerate (framerate) field is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode) to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
         */
        var telecine: aws.sdk.kotlin.services.mediaconvert.model.H265Telecine? = null
        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
         */
        var temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H265TemporalAdaptiveQuantization? = null
        /**
         * Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
         */
        var temporalIds: aws.sdk.kotlin.services.mediaconvert.model.H265TemporalIds? = null
        /**
         * Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
         */
        var tiles: aws.sdk.kotlin.services.mediaconvert.model.H265Tiles? = null
        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         */
        var unregisteredSeiTimecode: aws.sdk.kotlin.services.mediaconvert.model.H265UnregisteredSeiTimecode? = null
        /**
         * If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
         */
        var writeMp4PackagingType: aws.sdk.kotlin.services.mediaconvert.model.H265WriteMp4PackagingType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.H265Settings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.alternateTransferFunctionSei = x.alternateTransferFunctionSei
            this.bitrate = x.bitrate
            this.codecLevel = x.codecLevel
            this.codecProfile = x.codecProfile
            this.dynamicSubGop = x.dynamicSubGop
            this.flickerAdaptiveQuantization = x.flickerAdaptiveQuantization
            this.framerateControl = x.framerateControl
            this.framerateConversionAlgorithm = x.framerateConversionAlgorithm
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopBReference = x.gopBReference
            this.gopClosedCadence = x.gopClosedCadence
            this.gopSize = x.gopSize
            this.gopSizeUnits = x.gopSizeUnits
            this.hrdBufferInitialFillPercentage = x.hrdBufferInitialFillPercentage
            this.hrdBufferSize = x.hrdBufferSize
            this.interlaceMode = x.interlaceMode
            this.maxBitrate = x.maxBitrate
            this.minIInterval = x.minIInterval
            this.numberBFramesBetweenReferenceFrames = x.numberBFramesBetweenReferenceFrames
            this.numberReferenceFrames = x.numberReferenceFrames
            this.parControl = x.parControl
            this.parDenominator = x.parDenominator
            this.parNumerator = x.parNumerator
            this.qualityTuningLevel = x.qualityTuningLevel
            this.qvbrSettings = x.qvbrSettings
            this.rateControlMode = x.rateControlMode
            this.sampleAdaptiveOffsetFilterMode = x.sampleAdaptiveOffsetFilterMode
            this.scanTypeConversionMode = x.scanTypeConversionMode
            this.sceneChangeDetect = x.sceneChangeDetect
            this.slices = x.slices
            this.slowPal = x.slowPal
            this.spatialAdaptiveQuantization = x.spatialAdaptiveQuantization
            this.telecine = x.telecine
            this.temporalAdaptiveQuantization = x.temporalAdaptiveQuantization
            this.temporalIds = x.temporalIds
            this.tiles = x.tiles
            this.unregisteredSeiTimecode = x.unregisteredSeiTimecode
            this.writeMp4PackagingType = x.writeMp4PackagingType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.H265Settings = H265Settings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.H265QvbrSettings] inside the given [block]
         */
        fun qvbrSettings(block: aws.sdk.kotlin.services.mediaconvert.model.H265QvbrSettings.Builder.() -> kotlin.Unit) {
            this.qvbrSettings = aws.sdk.kotlin.services.mediaconvert.model.H265QvbrSettings.invoke(block)
        }
    }
}
