// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Optional. Configuration for a destination queue to which the job can hop once a customer-defined minimum wait time has passed.
 */
class HopDestination private constructor(builder: Builder) {
    /**
     * Optional. When you set up a job to use queue hopping, you can specify a different relative priority for the job in the destination queue. If you don't specify, the relative priority will remain the same as in the previous queue.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping, you can specify a destination queue. This queue cannot be the original queue to which the job is submitted. If the original queue isn't the default queue and you don't specify the destination queue, the job will move to the default queue.
     */
    val queue: kotlin.String? = builder.queue
    /**
     * Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop to the destination queue. Valid range is 1 to 1440 minutes, inclusive.
     */
    val waitMinutes: kotlin.Int? = builder.waitMinutes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.HopDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HopDestination(")
        append("priority=$priority,")
        append("queue=$queue,")
        append("waitMinutes=$waitMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = priority ?: 0
        result = 31 * result + (queue?.hashCode() ?: 0)
        result = 31 * result + (waitMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HopDestination

        if (priority != other.priority) return false
        if (queue != other.queue) return false
        if (waitMinutes != other.waitMinutes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.HopDestination = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional. When you set up a job to use queue hopping, you can specify a different relative priority for the job in the destination queue. If you don't specify, the relative priority will remain the same as in the previous queue.
         */
        var priority: kotlin.Int? = null
        /**
         * Optional unless the job is submitted on the default queue. When you set up a job to use queue hopping, you can specify a destination queue. This queue cannot be the original queue to which the job is submitted. If the original queue isn't the default queue and you don't specify the destination queue, the job will move to the default queue.
         */
        var queue: kotlin.String? = null
        /**
         * Required for setting up a job to use queue hopping. Minimum wait time in minutes until the job can hop to the destination queue. Valid range is 1 to 1440 minutes, inclusive.
         */
        var waitMinutes: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.HopDestination) : this() {
            this.priority = x.priority
            this.queue = x.queue
            this.waitMinutes = x.waitMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.HopDestination = HopDestination(this)
    }
}
