// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate from the video container. Set up sidecar captions in the same output group, but different output from your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html. When you work directly in your JSON job specification, include this object and any required children when you set destinationType to IMSC.
 */
class ImscDestinationSettings private constructor(builder: Builder) {
    /**
     * Set Accessibility subtitles to Enabled if the ISMC or WebVTT captions track is intended to provide accessibility for people who are deaf or hard of hearing. When you enable this feature, MediaConvert adds the following attributes under EXT-X-MEDIA in the HLS or CMAF manifest for this track: CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and AUTOSELECT="YES". Keep the default value, Disabled, if the captions track is not intended to provide such accessibility. MediaConvert will not add the above attributes.
     */
    val accessibility: aws.sdk.kotlin.services.mediaconvert.model.ImscAccessibilitySubs? = builder.accessibility
    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting for simplified output captions.
     */
    val stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.ImscStylePassthrough? = builder.stylePassthrough

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImscDestinationSettings(")
        append("accessibility=$accessibility,")
        append("stylePassthrough=$stylePassthrough)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessibility?.hashCode() ?: 0
        result = 31 * result + (stylePassthrough?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImscDestinationSettings

        if (accessibility != other.accessibility) return false
        if (stylePassthrough != other.stylePassthrough) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set Accessibility subtitles to Enabled if the ISMC or WebVTT captions track is intended to provide accessibility for people who are deaf or hard of hearing. When you enable this feature, MediaConvert adds the following attributes under EXT-X-MEDIA in the HLS or CMAF manifest for this track: CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and AUTOSELECT="YES". Keep the default value, Disabled, if the captions track is not intended to provide such accessibility. MediaConvert will not add the above attributes.
         */
        var accessibility: aws.sdk.kotlin.services.mediaconvert.model.ImscAccessibilitySubs? = null
        /**
         * Keep this setting enabled to have MediaConvert use the font style and position information from the captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable this setting for simplified output captions.
         */
        var stylePassthrough: aws.sdk.kotlin.services.mediaconvert.model.ImscStylePassthrough? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings) : this() {
            this.accessibility = x.accessibility
            this.stylePassthrough = x.stylePassthrough
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.ImscDestinationSettings = ImscDestinationSettings(this)
    }
}
