// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
 */
class JobTemplate private constructor(builder: Builder) {
    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     */
    val accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = builder.accelerationSettings
    /**
     * An identifier for this resource that is unique within all of AWS.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * An optional category you create to organize your job templates.
     */
    val category: kotlin.String? = builder.category
    /**
     * The timestamp in epoch seconds for Job template creation.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An optional description you create for each job template.
     */
    val description: kotlin.String? = builder.description
    /**
     * Optional list of hop destinations.
     */
    val hopDestinations: List<HopDestination>? = builder.hopDestinations
    /**
     * The timestamp in epoch seconds when the Job template was last updated.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * A name you create for each job template. Each name must be unique within your account.
     */
    val name: kotlin.String? = builder.name
    /**
     * Relative priority on the job.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue.
     */
    val queue: kotlin.String? = builder.queue
    /**
     * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
     */
    val settings: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings? = builder.settings
    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
     */
    val statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = builder.statusUpdateInterval
    /**
     * A job template can be of two types: system or custom. System or built-in job templates can't be modified or deleted by the user.
     */
    val type: aws.sdk.kotlin.services.mediaconvert.model.Type? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.JobTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobTemplate(")
        append("accelerationSettings=$accelerationSettings,")
        append("arn=$arn,")
        append("category=$category,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("hopDestinations=$hopDestinations,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("priority=$priority,")
        append("queue=$queue,")
        append("settings=$settings,")
        append("statusUpdateInterval=$statusUpdateInterval,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerationSettings?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hopDestinations?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (queue?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (statusUpdateInterval?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobTemplate

        if (accelerationSettings != other.accelerationSettings) return false
        if (arn != other.arn) return false
        if (category != other.category) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (hopDestinations != other.hopDestinations) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (queue != other.queue) return false
        if (settings != other.settings) return false
        if (statusUpdateInterval != other.statusUpdateInterval) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.JobTemplate = Builder(this).apply(block).build()

    class Builder {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         */
        var accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = null
        /**
         * An identifier for this resource that is unique within all of AWS.
         */
        var arn: kotlin.String? = null
        /**
         * An optional category you create to organize your job templates.
         */
        var category: kotlin.String? = null
        /**
         * The timestamp in epoch seconds for Job template creation.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description you create for each job template.
         */
        var description: kotlin.String? = null
        /**
         * Optional list of hop destinations.
         */
        var hopDestinations: List<HopDestination>? = null
        /**
         * The timestamp in epoch seconds when the Job template was last updated.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A name you create for each job template. Each name must be unique within your account.
         */
        var name: kotlin.String? = null
        /**
         * Relative priority on the job.
         */
        var priority: kotlin.Int? = null
        /**
         * Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue.
         */
        var queue: kotlin.String? = null
        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
         */
        var settings: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings? = null
        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
         */
        var statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = null
        /**
         * A job template can be of two types: system or custom. System or built-in job templates can't be modified or deleted by the user.
         */
        var type: aws.sdk.kotlin.services.mediaconvert.model.Type? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.JobTemplate) : this() {
            this.accelerationSettings = x.accelerationSettings
            this.arn = x.arn
            this.category = x.category
            this.createdAt = x.createdAt
            this.description = x.description
            this.hopDestinations = x.hopDestinations
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.priority = x.priority
            this.queue = x.queue
            this.settings = x.settings
            this.statusUpdateInterval = x.statusUpdateInterval
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.JobTemplate = JobTemplate(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings] inside the given [block]
         */
        fun accelerationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.Builder.() -> kotlin.Unit) {
            this.accelerationSettings = aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings] inside the given [block]
         */
        fun settings(block: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings.invoke(block)
        }
    }
}
