// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container (ContainerType) is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each transport stream program contains subsets of data, including audio, video, and metadata. Each of these subsets of data has a numerical label called a packet identifier (PID). Each transport stream program corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID. Downstream systems and players use the program map table to look up the PID for each type of data it accesses and then uses the PIDs to locate specific data within the asset.
 */
class M2TsSettings private constructor(builder: Builder) {
    /**
     * Selects between the DVB and ATSC buffer models for Dolby Digital audio.
     */
    val audioBufferModel: aws.sdk.kotlin.services.mediaconvert.model.M2TsAudioBufferModel? = builder.audioBufferModel
    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     */
    val audioDuration: aws.sdk.kotlin.services.mediaconvert.model.M2TsAudioDuration? = builder.audioDuration
    /**
     * The number of audio frames to insert for each PES packet.
     */
    val audioFramesPerPes: kotlin.Int? = builder.audioFramesPerPes
    /**
     * Specify the packet identifiers (PIDs) for any elementary audio streams you include in this output. Specify multiple PIDs as a JSON array. Default is the range 482-492.
     */
    val audioPids: List<Int>? = builder.audioPids
    /**
     * Specify the output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate. Other common values are 3750000, 7500000, and 15000000.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * Controls what buffer model to use for accurate interleaving. If set to MULTIPLEX, use multiplex buffer model. If set to NONE, this can lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.
     */
    val bufferModel: aws.sdk.kotlin.services.mediaconvert.model.M2TsBufferModel? = builder.bufferModel
    /**
     * If you select ALIGN_TO_VIDEO, MediaConvert writes captions and data packets with Presentation Timestamp (PTS) values greater than or equal to the first video packet PTS (MediaConvert drops captions and data packets with lesser PTS values). Keep the default value (AUTO) to allow all PTS values.
     */
    val dataPtsControl: aws.sdk.kotlin.services.mediaconvert.model.M2TsDataPtsControl? = builder.dataPtsControl
    /**
     * Use these settings to insert a DVB Network Information Table (NIT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
     */
    val dvbNitSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbNitSettings? = builder.dvbNitSettings
    /**
     * Use these settings to insert a DVB Service Description Table (SDT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
     */
    val dvbSdtSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings? = builder.dvbSdtSettings
    /**
     * Specify the packet identifiers (PIDs) for DVB subtitle data included in this output. Specify multiple PIDs as a JSON array. Default is the range 460-479.
     */
    val dvbSubPids: List<Int>? = builder.dvbSubPids
    /**
     * Use these settings to insert a DVB Time and Date Table (TDT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
     */
    val dvbTdtSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbTdtSettings? = builder.dvbTdtSettings
    /**
     * Specify the packet identifier (PID) for DVB teletext data you include in this output. Default is 499.
     */
    val dvbTeletextPid: kotlin.Int? = builder.dvbTeletextPid
    /**
     * When set to VIDEO_AND_FIXED_INTERVALS, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. When set to VIDEO_INTERVAL, these additional markers will not be inserted. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).
     */
    val ebpAudioInterval: aws.sdk.kotlin.services.mediaconvert.model.M2TsEbpAudioInterval? = builder.ebpAudioInterval
    /**
     * Selects which PIDs to place EBP markers on. They can either be placed only on the video PID, or on both the video PID and all audio PIDs. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).
     */
    val ebpPlacement: aws.sdk.kotlin.services.mediaconvert.model.M2TsEbpPlacement? = builder.ebpPlacement
    /**
     * Controls whether to include the ES Rate field in the PES header.
     */
    val esRateInPes: aws.sdk.kotlin.services.mediaconvert.model.M2TsEsRateInPes? = builder.esRateInPes
    /**
     * Keep the default value (DEFAULT) unless you know that your audio EBP markers are incorrectly appearing before your video EBP markers. To correct this problem, set this value to Force (FORCE).
     */
    val forceTsVideoEbpOrder: aws.sdk.kotlin.services.mediaconvert.model.M2TsForceTsVideoEbpOrder? = builder.forceTsVideoEbpOrder
    /**
     * The length, in seconds, of each fragment. Only used with EBP markers.
     */
    val fragmentTime: kotlin.Double? = builder.fragmentTime
    /**
     * To include key-length-value metadata in this output: Set KLV metadata insertion to Passthrough. MediaConvert reads KLV metadata present in your input and passes it through to the output transport stream. To exclude this KLV metadata: Set KLV metadata insertion to None or leave blank.
     */
    val klvMetadata: aws.sdk.kotlin.services.mediaconvert.model.M2TsKlvMetadata? = builder.klvMetadata
    /**
     * Specify the maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.
     */
    val maxPcrInterval: kotlin.Int? = builder.maxPcrInterval
    /**
     * When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.
     */
    val minEbpInterval: kotlin.Int? = builder.minEbpInterval
    /**
     * If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
     */
    val nielsenId3: aws.sdk.kotlin.services.mediaconvert.model.M2TsNielsenId3? = builder.nielsenId3
    /**
     * Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.
     */
    val nullPacketBitrate: kotlin.Double? = builder.nullPacketBitrate
    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     */
    val patInterval: kotlin.Int? = builder.patInterval
    /**
     * When set to PCR_EVERY_PES_PACKET, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This is effective only when the PCR PID is the same as the video or audio elementary stream.
     */
    val pcrControl: aws.sdk.kotlin.services.mediaconvert.model.M2TsPcrControl? = builder.pcrControl
    /**
     * Specify the packet identifier (PID) for the program clock reference (PCR) in this output. If you do not specify a value, the service will use the value for Video PID (VideoPid).
     */
    val pcrPid: kotlin.Int? = builder.pcrPid
    /**
     * Specify the number of milliseconds between instances of the program map table (PMT) in the output transport stream.
     */
    val pmtInterval: kotlin.Int? = builder.pmtInterval
    /**
     * Specify the packet identifier (PID) for the program map table (PMT) itself. Default is 480.
     */
    val pmtPid: kotlin.Int? = builder.pmtPid
    /**
     * Specify the packet identifier (PID) of the private metadata stream. Default is 503.
     */
    val privateMetadataPid: kotlin.Int? = builder.privateMetadataPid
    /**
     * Use Program number (programNumber) to specify the program number used in the program map table (PMT) for this output. Default is 1. Program numbers and program map tables are parts of MPEG-2 transport stream containers, used for organizing data.
     */
    val programNumber: kotlin.Int? = builder.programNumber
    /**
     * When set to CBR, inserts null packets into transport stream to fill specified bitrate. When set to VBR, the bitrate setting acts as the maximum bitrate, but the output will not be padded up to that bitrate.
     */
    val rateMode: aws.sdk.kotlin.services.mediaconvert.model.M2TsRateMode? = builder.rateMode
    /**
     * Include this in your job settings to put SCTE-35 markers in your HLS and transport stream outputs at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).
     */
    val scte35Esam: aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Esam? = builder.scte35Esam
    /**
     * Specify the packet identifier (PID) of the SCTE-35 stream in the transport stream.
     */
    val scte35Pid: kotlin.Int? = builder.scte35Pid
    /**
     * For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE). Also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml). Also enable ESAM SCTE-35 (include the property scte35Esam).
     */
    val scte35Source: aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Source? = builder.scte35Source
    /**
     * Inserts segmentation markers at each segmentation_time period. rai_segstart sets the Random Access Indicator bit in the adaptation field. rai_adapt sets the RAI bit and adds the current timecode in the private data bytes. psi_segstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebp_legacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
     */
    val segmentationMarkers: aws.sdk.kotlin.services.mediaconvert.model.M2TsSegmentationMarkers? = builder.segmentationMarkers
    /**
     * The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted. When a segmentation style of "reset_cadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of of $segmentation_time seconds. When a segmentation style of "maintain_cadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentation_time seconds. Note that EBP lookahead is a slight exception to this rule.
     */
    val segmentationStyle: aws.sdk.kotlin.services.mediaconvert.model.M2TsSegmentationStyle? = builder.segmentationStyle
    /**
     * Specify the length, in seconds, of each segment. Required unless markers is set to _none_.
     */
    val segmentationTime: kotlin.Double? = builder.segmentationTime
    /**
     * Packet Identifier (PID) of the ID3 metadata stream in the transport stream.
     */
    val timedMetadataPid: kotlin.Int? = builder.timedMetadataPid
    /**
     * Specify the ID for the transport stream itself in the program map table for this output. Transport stream IDs and program map tables are parts of MPEG-2 transport stream containers, used for organizing data.
     */
    val transportStreamId: kotlin.Int? = builder.transportStreamId
    /**
     * Specify the packet identifier (PID) of the elementary video stream in the transport stream.
     */
    val videoPid: kotlin.Int? = builder.videoPid

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("M2TsSettings(")
        append("audioBufferModel=$audioBufferModel,")
        append("audioDuration=$audioDuration,")
        append("audioFramesPerPes=$audioFramesPerPes,")
        append("audioPids=$audioPids,")
        append("bitrate=$bitrate,")
        append("bufferModel=$bufferModel,")
        append("dataPtsControl=$dataPtsControl,")
        append("dvbNitSettings=$dvbNitSettings,")
        append("dvbSdtSettings=$dvbSdtSettings,")
        append("dvbSubPids=$dvbSubPids,")
        append("dvbTdtSettings=$dvbTdtSettings,")
        append("dvbTeletextPid=$dvbTeletextPid,")
        append("ebpAudioInterval=$ebpAudioInterval,")
        append("ebpPlacement=$ebpPlacement,")
        append("esRateInPes=$esRateInPes,")
        append("forceTsVideoEbpOrder=$forceTsVideoEbpOrder,")
        append("fragmentTime=$fragmentTime,")
        append("klvMetadata=$klvMetadata,")
        append("maxPcrInterval=$maxPcrInterval,")
        append("minEbpInterval=$minEbpInterval,")
        append("nielsenId3=$nielsenId3,")
        append("nullPacketBitrate=$nullPacketBitrate,")
        append("patInterval=$patInterval,")
        append("pcrControl=$pcrControl,")
        append("pcrPid=$pcrPid,")
        append("pmtInterval=$pmtInterval,")
        append("pmtPid=$pmtPid,")
        append("privateMetadataPid=$privateMetadataPid,")
        append("programNumber=$programNumber,")
        append("rateMode=$rateMode,")
        append("scte35Esam=$scte35Esam,")
        append("scte35Pid=$scte35Pid,")
        append("scte35Source=$scte35Source,")
        append("segmentationMarkers=$segmentationMarkers,")
        append("segmentationStyle=$segmentationStyle,")
        append("segmentationTime=$segmentationTime,")
        append("timedMetadataPid=$timedMetadataPid,")
        append("transportStreamId=$transportStreamId,")
        append("videoPid=$videoPid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioBufferModel?.hashCode() ?: 0
        result = 31 * result + (audioDuration?.hashCode() ?: 0)
        result = 31 * result + (audioFramesPerPes ?: 0)
        result = 31 * result + (audioPids?.hashCode() ?: 0)
        result = 31 * result + (bitrate ?: 0)
        result = 31 * result + (bufferModel?.hashCode() ?: 0)
        result = 31 * result + (dataPtsControl?.hashCode() ?: 0)
        result = 31 * result + (dvbNitSettings?.hashCode() ?: 0)
        result = 31 * result + (dvbSdtSettings?.hashCode() ?: 0)
        result = 31 * result + (dvbSubPids?.hashCode() ?: 0)
        result = 31 * result + (dvbTdtSettings?.hashCode() ?: 0)
        result = 31 * result + (dvbTeletextPid ?: 0)
        result = 31 * result + (ebpAudioInterval?.hashCode() ?: 0)
        result = 31 * result + (ebpPlacement?.hashCode() ?: 0)
        result = 31 * result + (esRateInPes?.hashCode() ?: 0)
        result = 31 * result + (forceTsVideoEbpOrder?.hashCode() ?: 0)
        result = 31 * result + (fragmentTime?.hashCode() ?: 0)
        result = 31 * result + (klvMetadata?.hashCode() ?: 0)
        result = 31 * result + (maxPcrInterval ?: 0)
        result = 31 * result + (minEbpInterval ?: 0)
        result = 31 * result + (nielsenId3?.hashCode() ?: 0)
        result = 31 * result + (nullPacketBitrate?.hashCode() ?: 0)
        result = 31 * result + (patInterval ?: 0)
        result = 31 * result + (pcrControl?.hashCode() ?: 0)
        result = 31 * result + (pcrPid ?: 0)
        result = 31 * result + (pmtInterval ?: 0)
        result = 31 * result + (pmtPid ?: 0)
        result = 31 * result + (privateMetadataPid ?: 0)
        result = 31 * result + (programNumber ?: 0)
        result = 31 * result + (rateMode?.hashCode() ?: 0)
        result = 31 * result + (scte35Esam?.hashCode() ?: 0)
        result = 31 * result + (scte35Pid ?: 0)
        result = 31 * result + (scte35Source?.hashCode() ?: 0)
        result = 31 * result + (segmentationMarkers?.hashCode() ?: 0)
        result = 31 * result + (segmentationStyle?.hashCode() ?: 0)
        result = 31 * result + (segmentationTime?.hashCode() ?: 0)
        result = 31 * result + (timedMetadataPid ?: 0)
        result = 31 * result + (transportStreamId ?: 0)
        result = 31 * result + (videoPid ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as M2TsSettings

        if (audioBufferModel != other.audioBufferModel) return false
        if (audioDuration != other.audioDuration) return false
        if (audioFramesPerPes != other.audioFramesPerPes) return false
        if (audioPids != other.audioPids) return false
        if (bitrate != other.bitrate) return false
        if (bufferModel != other.bufferModel) return false
        if (dataPtsControl != other.dataPtsControl) return false
        if (dvbNitSettings != other.dvbNitSettings) return false
        if (dvbSdtSettings != other.dvbSdtSettings) return false
        if (dvbSubPids != other.dvbSubPids) return false
        if (dvbTdtSettings != other.dvbTdtSettings) return false
        if (dvbTeletextPid != other.dvbTeletextPid) return false
        if (ebpAudioInterval != other.ebpAudioInterval) return false
        if (ebpPlacement != other.ebpPlacement) return false
        if (esRateInPes != other.esRateInPes) return false
        if (forceTsVideoEbpOrder != other.forceTsVideoEbpOrder) return false
        if (fragmentTime != other.fragmentTime) return false
        if (klvMetadata != other.klvMetadata) return false
        if (maxPcrInterval != other.maxPcrInterval) return false
        if (minEbpInterval != other.minEbpInterval) return false
        if (nielsenId3 != other.nielsenId3) return false
        if (nullPacketBitrate != other.nullPacketBitrate) return false
        if (patInterval != other.patInterval) return false
        if (pcrControl != other.pcrControl) return false
        if (pcrPid != other.pcrPid) return false
        if (pmtInterval != other.pmtInterval) return false
        if (pmtPid != other.pmtPid) return false
        if (privateMetadataPid != other.privateMetadataPid) return false
        if (programNumber != other.programNumber) return false
        if (rateMode != other.rateMode) return false
        if (scte35Esam != other.scte35Esam) return false
        if (scte35Pid != other.scte35Pid) return false
        if (scte35Source != other.scte35Source) return false
        if (segmentationMarkers != other.segmentationMarkers) return false
        if (segmentationStyle != other.segmentationStyle) return false
        if (segmentationTime != other.segmentationTime) return false
        if (timedMetadataPid != other.timedMetadataPid) return false
        if (transportStreamId != other.transportStreamId) return false
        if (videoPid != other.videoPid) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Selects between the DVB and ATSC buffer models for Dolby Digital audio.
         */
        var audioBufferModel: aws.sdk.kotlin.services.mediaconvert.model.M2TsAudioBufferModel? = null
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
         */
        var audioDuration: aws.sdk.kotlin.services.mediaconvert.model.M2TsAudioDuration? = null
        /**
         * The number of audio frames to insert for each PES packet.
         */
        var audioFramesPerPes: kotlin.Int? = null
        /**
         * Specify the packet identifiers (PIDs) for any elementary audio streams you include in this output. Specify multiple PIDs as a JSON array. Default is the range 482-492.
         */
        var audioPids: List<Int>? = null
        /**
         * Specify the output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate. Other common values are 3750000, 7500000, and 15000000.
         */
        var bitrate: kotlin.Int? = null
        /**
         * Controls what buffer model to use for accurate interleaving. If set to MULTIPLEX, use multiplex buffer model. If set to NONE, this can lead to lower latency, but low-memory devices may not be able to play back the stream without interruptions.
         */
        var bufferModel: aws.sdk.kotlin.services.mediaconvert.model.M2TsBufferModel? = null
        /**
         * If you select ALIGN_TO_VIDEO, MediaConvert writes captions and data packets with Presentation Timestamp (PTS) values greater than or equal to the first video packet PTS (MediaConvert drops captions and data packets with lesser PTS values). Keep the default value (AUTO) to allow all PTS values.
         */
        var dataPtsControl: aws.sdk.kotlin.services.mediaconvert.model.M2TsDataPtsControl? = null
        /**
         * Use these settings to insert a DVB Network Information Table (NIT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
         */
        var dvbNitSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbNitSettings? = null
        /**
         * Use these settings to insert a DVB Service Description Table (SDT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
         */
        var dvbSdtSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings? = null
        /**
         * Specify the packet identifiers (PIDs) for DVB subtitle data included in this output. Specify multiple PIDs as a JSON array. Default is the range 460-479.
         */
        var dvbSubPids: List<Int>? = null
        /**
         * Use these settings to insert a DVB Time and Date Table (TDT) in the transport stream of this output. When you work directly in your JSON job specification, include this object only when your job has a transport stream output and the container settings contain the object M2tsSettings.
         */
        var dvbTdtSettings: aws.sdk.kotlin.services.mediaconvert.model.DvbTdtSettings? = null
        /**
         * Specify the packet identifier (PID) for DVB teletext data you include in this output. Default is 499.
         */
        var dvbTeletextPid: kotlin.Int? = null
        /**
         * When set to VIDEO_AND_FIXED_INTERVALS, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. When set to VIDEO_INTERVAL, these additional markers will not be inserted. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).
         */
        var ebpAudioInterval: aws.sdk.kotlin.services.mediaconvert.model.M2TsEbpAudioInterval? = null
        /**
         * Selects which PIDs to place EBP markers on. They can either be placed only on the video PID, or on both the video PID and all audio PIDs. Only applicable when EBP segmentation markers are is selected (segmentationMarkers is EBP or EBP_LEGACY).
         */
        var ebpPlacement: aws.sdk.kotlin.services.mediaconvert.model.M2TsEbpPlacement? = null
        /**
         * Controls whether to include the ES Rate field in the PES header.
         */
        var esRateInPes: aws.sdk.kotlin.services.mediaconvert.model.M2TsEsRateInPes? = null
        /**
         * Keep the default value (DEFAULT) unless you know that your audio EBP markers are incorrectly appearing before your video EBP markers. To correct this problem, set this value to Force (FORCE).
         */
        var forceTsVideoEbpOrder: aws.sdk.kotlin.services.mediaconvert.model.M2TsForceTsVideoEbpOrder? = null
        /**
         * The length, in seconds, of each fragment. Only used with EBP markers.
         */
        var fragmentTime: kotlin.Double? = null
        /**
         * To include key-length-value metadata in this output: Set KLV metadata insertion to Passthrough. MediaConvert reads KLV metadata present in your input and passes it through to the output transport stream. To exclude this KLV metadata: Set KLV metadata insertion to None or leave blank.
         */
        var klvMetadata: aws.sdk.kotlin.services.mediaconvert.model.M2TsKlvMetadata? = null
        /**
         * Specify the maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.
         */
        var maxPcrInterval: kotlin.Int? = null
        /**
         * When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.
         */
        var minEbpInterval: kotlin.Int? = null
        /**
         * If INSERT, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
         */
        var nielsenId3: aws.sdk.kotlin.services.mediaconvert.model.M2TsNielsenId3? = null
        /**
         * Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.
         */
        var nullPacketBitrate: kotlin.Double? = null
        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        var patInterval: kotlin.Int? = null
        /**
         * When set to PCR_EVERY_PES_PACKET, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This is effective only when the PCR PID is the same as the video or audio elementary stream.
         */
        var pcrControl: aws.sdk.kotlin.services.mediaconvert.model.M2TsPcrControl? = null
        /**
         * Specify the packet identifier (PID) for the program clock reference (PCR) in this output. If you do not specify a value, the service will use the value for Video PID (VideoPid).
         */
        var pcrPid: kotlin.Int? = null
        /**
         * Specify the number of milliseconds between instances of the program map table (PMT) in the output transport stream.
         */
        var pmtInterval: kotlin.Int? = null
        /**
         * Specify the packet identifier (PID) for the program map table (PMT) itself. Default is 480.
         */
        var pmtPid: kotlin.Int? = null
        /**
         * Specify the packet identifier (PID) of the private metadata stream. Default is 503.
         */
        var privateMetadataPid: kotlin.Int? = null
        /**
         * Use Program number (programNumber) to specify the program number used in the program map table (PMT) for this output. Default is 1. Program numbers and program map tables are parts of MPEG-2 transport stream containers, used for organizing data.
         */
        var programNumber: kotlin.Int? = null
        /**
         * When set to CBR, inserts null packets into transport stream to fill specified bitrate. When set to VBR, the bitrate setting acts as the maximum bitrate, but the output will not be padded up to that bitrate.
         */
        var rateMode: aws.sdk.kotlin.services.mediaconvert.model.M2TsRateMode? = null
        /**
         * Include this in your job settings to put SCTE-35 markers in your HLS and transport stream outputs at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).
         */
        var scte35Esam: aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Esam? = null
        /**
         * Specify the packet identifier (PID) of the SCTE-35 stream in the transport stream.
         */
        var scte35Pid: kotlin.Int? = null
        /**
         * For SCTE-35 markers from your input-- Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want SCTE-35 markers in this output. For SCTE-35 markers from an ESAM XML document-- Choose None (NONE). Also provide the ESAM XML as a string in the setting Signal processing notification XML (sccXml). Also enable ESAM SCTE-35 (include the property scte35Esam).
         */
        var scte35Source: aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Source? = null
        /**
         * Inserts segmentation markers at each segmentation_time period. rai_segstart sets the Random Access Indicator bit in the adaptation field. rai_adapt sets the RAI bit and adds the current timecode in the private data bytes. psi_segstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebp_legacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
         */
        var segmentationMarkers: aws.sdk.kotlin.services.mediaconvert.model.M2TsSegmentationMarkers? = null
        /**
         * The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted. When a segmentation style of "reset_cadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of of $segmentation_time seconds. When a segmentation style of "maintain_cadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentation_time seconds. Note that EBP lookahead is a slight exception to this rule.
         */
        var segmentationStyle: aws.sdk.kotlin.services.mediaconvert.model.M2TsSegmentationStyle? = null
        /**
         * Specify the length, in seconds, of each segment. Required unless markers is set to _none_.
         */
        var segmentationTime: kotlin.Double? = null
        /**
         * Packet Identifier (PID) of the ID3 metadata stream in the transport stream.
         */
        var timedMetadataPid: kotlin.Int? = null
        /**
         * Specify the ID for the transport stream itself in the program map table for this output. Transport stream IDs and program map tables are parts of MPEG-2 transport stream containers, used for organizing data.
         */
        var transportStreamId: kotlin.Int? = null
        /**
         * Specify the packet identifier (PID) of the elementary video stream in the transport stream.
         */
        var videoPid: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings) : this() {
            this.audioBufferModel = x.audioBufferModel
            this.audioDuration = x.audioDuration
            this.audioFramesPerPes = x.audioFramesPerPes
            this.audioPids = x.audioPids
            this.bitrate = x.bitrate
            this.bufferModel = x.bufferModel
            this.dataPtsControl = x.dataPtsControl
            this.dvbNitSettings = x.dvbNitSettings
            this.dvbSdtSettings = x.dvbSdtSettings
            this.dvbSubPids = x.dvbSubPids
            this.dvbTdtSettings = x.dvbTdtSettings
            this.dvbTeletextPid = x.dvbTeletextPid
            this.ebpAudioInterval = x.ebpAudioInterval
            this.ebpPlacement = x.ebpPlacement
            this.esRateInPes = x.esRateInPes
            this.forceTsVideoEbpOrder = x.forceTsVideoEbpOrder
            this.fragmentTime = x.fragmentTime
            this.klvMetadata = x.klvMetadata
            this.maxPcrInterval = x.maxPcrInterval
            this.minEbpInterval = x.minEbpInterval
            this.nielsenId3 = x.nielsenId3
            this.nullPacketBitrate = x.nullPacketBitrate
            this.patInterval = x.patInterval
            this.pcrControl = x.pcrControl
            this.pcrPid = x.pcrPid
            this.pmtInterval = x.pmtInterval
            this.pmtPid = x.pmtPid
            this.privateMetadataPid = x.privateMetadataPid
            this.programNumber = x.programNumber
            this.rateMode = x.rateMode
            this.scte35Esam = x.scte35Esam
            this.scte35Pid = x.scte35Pid
            this.scte35Source = x.scte35Source
            this.segmentationMarkers = x.segmentationMarkers
            this.segmentationStyle = x.segmentationStyle
            this.segmentationTime = x.segmentationTime
            this.timedMetadataPid = x.timedMetadataPid
            this.transportStreamId = x.transportStreamId
            this.videoPid = x.videoPid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings = M2TsSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DvbNitSettings] inside the given [block]
         */
        fun dvbNitSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DvbNitSettings.Builder.() -> kotlin.Unit) {
            this.dvbNitSettings = aws.sdk.kotlin.services.mediaconvert.model.DvbNitSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings] inside the given [block]
         */
        fun dvbSdtSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings.Builder.() -> kotlin.Unit) {
            this.dvbSdtSettings = aws.sdk.kotlin.services.mediaconvert.model.DvbSdtSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DvbTdtSettings] inside the given [block]
         */
        fun dvbTdtSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DvbTdtSettings.Builder.() -> kotlin.Unit) {
            this.dvbTdtSettings = aws.sdk.kotlin.services.mediaconvert.model.DvbTdtSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Esam] inside the given [block]
         */
        fun scte35Esam(block: aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Esam.Builder.() -> kotlin.Unit) {
            this.scte35Esam = aws.sdk.kotlin.services.mediaconvert.model.M2TsScte35Esam.invoke(block)
        }
    }
}
