// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * These settings relate to your QuickTime MOV output container.
 */
class MovSettings private constructor(builder: Builder) {
    /**
     * When enabled, include 'clap' atom if appropriate for the video output settings.
     */
    val clapAtom: aws.sdk.kotlin.services.mediaconvert.model.MovClapAtom? = builder.clapAtom
    /**
     * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     */
    val cslgAtom: aws.sdk.kotlin.services.mediaconvert.model.MovCslgAtom? = builder.cslgAtom
    /**
     * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable when the video codec is MPEG2.
     */
    val mpeg2FourCcControl: aws.sdk.kotlin.services.mediaconvert.model.MovMpeg2FourCcControl? = builder.mpeg2FourCcControl
    /**
     * To make this output compatible with Omenon, keep the default value, OMNEON. Unless you need Omneon compatibility, set this value to NONE. When you keep the default value, OMNEON, MediaConvert increases the length of the edit list atom. This might cause file rejections when a recipient of the output file doesn't expct this extra padding.
     */
    val paddingControl: aws.sdk.kotlin.services.mediaconvert.model.MovPaddingControl? = builder.paddingControl
    /**
     * Always keep the default value (SELF_CONTAINED) for this setting.
     */
    val reference: aws.sdk.kotlin.services.mediaconvert.model.MovReference? = builder.reference

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.MovSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MovSettings(")
        append("clapAtom=$clapAtom,")
        append("cslgAtom=$cslgAtom,")
        append("mpeg2FourCcControl=$mpeg2FourCcControl,")
        append("paddingControl=$paddingControl,")
        append("reference=$reference)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clapAtom?.hashCode() ?: 0
        result = 31 * result + (cslgAtom?.hashCode() ?: 0)
        result = 31 * result + (mpeg2FourCcControl?.hashCode() ?: 0)
        result = 31 * result + (paddingControl?.hashCode() ?: 0)
        result = 31 * result + (reference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MovSettings

        if (clapAtom != other.clapAtom) return false
        if (cslgAtom != other.cslgAtom) return false
        if (mpeg2FourCcControl != other.mpeg2FourCcControl) return false
        if (paddingControl != other.paddingControl) return false
        if (reference != other.reference) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.MovSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * When enabled, include 'clap' atom if appropriate for the video output settings.
         */
        var clapAtom: aws.sdk.kotlin.services.mediaconvert.model.MovClapAtom? = null
        /**
         * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         */
        var cslgAtom: aws.sdk.kotlin.services.mediaconvert.model.MovCslgAtom? = null
        /**
         * When set to XDCAM, writes MPEG2 video streams into the QuickTime file using XDCAM fourcc codes. This increases compatibility with Apple editors and players, but may decrease compatibility with other players. Only applicable when the video codec is MPEG2.
         */
        var mpeg2FourCcControl: aws.sdk.kotlin.services.mediaconvert.model.MovMpeg2FourCcControl? = null
        /**
         * To make this output compatible with Omenon, keep the default value, OMNEON. Unless you need Omneon compatibility, set this value to NONE. When you keep the default value, OMNEON, MediaConvert increases the length of the edit list atom. This might cause file rejections when a recipient of the output file doesn't expct this extra padding.
         */
        var paddingControl: aws.sdk.kotlin.services.mediaconvert.model.MovPaddingControl? = null
        /**
         * Always keep the default value (SELF_CONTAINED) for this setting.
         */
        var reference: aws.sdk.kotlin.services.mediaconvert.model.MovReference? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.MovSettings) : this() {
            this.clapAtom = x.clapAtom
            this.cslgAtom = x.cslgAtom
            this.mpeg2FourCcControl = x.mpeg2FourCcControl
            this.paddingControl = x.paddingControl
            this.reference = x.reference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.MovSettings = MovSettings(this)
    }
}
