// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
 */
class Mpeg2Settings private constructor(builder: Builder) {
    /**
     * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
     */
    val adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2AdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
     */
    val codecLevel: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2CodecLevel? = builder.codecLevel
    /**
     * Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
     */
    val codecProfile: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2CodecProfile? = builder.codecProfile
    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     */
    val dynamicSubGop: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2DynamicSubGop? = builder.dynamicSubGop
    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
     */
    val framerateControl: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2FramerateControl? = builder.framerateControl
    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
     */
    val framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2FramerateConversionAlgorithm? = builder.framerateConversionAlgorithm
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateDenominator: kotlin.Int? = builder.framerateDenominator
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateNumerator: kotlin.Int? = builder.framerateNumerator
    /**
     * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open GOPs and then require a closed GOP, set this value to 5. When you create a streaming output, we recommend that you keep the default value, 1, so that players starting mid-stream receive an IDR frame as quickly as possible. Don't set this value to 0; that would break output segmenting.
     */
    val gopClosedCadence: kotlin.Int? = builder.gopClosedCadence
    /**
     * Specify the interval between keyframes, in seconds or frames, for this output. Default: 12 Related settings: When you specify the GOP size in seconds, set GOP mode control (GopSizeUnits) to Specified, seconds (SECONDS). The default value for GOP mode control (GopSizeUnits) is Frames (FRAMES).
     */
    val gopSize: kotlin.Double? = builder.gopSize
    /**
     * Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
     */
    val gopSizeUnits: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2GopSizeUnits? = builder.gopSizeUnits
    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    val hrdBufferInitialFillPercentage: kotlin.Int? = builder.hrdBufferInitialFillPercentage
    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    val hrdBufferSize: kotlin.Int? = builder.hrdBufferSize
    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
     */
    val interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2InterlaceMode? = builder.interlaceMode
    /**
     * Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
     */
    val intraDcPrecision: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2IntraDcPrecision? = builder.intraDcPrecision
    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
     */
    val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the I-frames that it inserts for Scene change detection. When you specify a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
     */
    val minIInterval: kotlin.Int? = builder.minIInterval
    /**
     * Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
     */
    val numberBFramesBetweenReferenceFrames: kotlin.Int? = builder.numberBFramesBetweenReferenceFrames
    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     */
    val parControl: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2ParControl? = builder.parControl
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    val parDenominator: kotlin.Int? = builder.parDenominator
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    val parNumerator: kotlin.Int? = builder.parNumerator
    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     */
    val qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2QualityTuningLevel? = builder.qualityTuningLevel
    /**
     * Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
     */
    val rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2RateControlMode? = builder.rateControlMode
    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     */
    val scanTypeConversionMode: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2ScanTypeConversionMode? = builder.scanTypeConversionMode
    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
     */
    val sceneChangeDetect: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2SceneChangeDetect? = builder.sceneChangeDetect
    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     */
    val slowPal: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2SlowPal? = builder.slowPal
    /**
     * Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, to use the AWS Elemental default matrices. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
     */
    val softness: kotlin.Int? = builder.softness
    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     */
    val spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2SpatialAdaptiveQuantization? = builder.spatialAdaptiveQuantization
    /**
     * Specify whether this output's video uses the D10 syntax. Keep the default value to not use the syntax. Related settings: When you choose D10 (D_10) for your MXF profile (profile), you must also set this value to to D10 (D_10).
     */
    val syntax: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Syntax? = builder.syntax
    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
     */
    val telecine: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Telecine? = builder.telecine
    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
     */
    val temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2TemporalAdaptiveQuantization? = builder.temporalAdaptiveQuantization

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Mpeg2Settings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("bitrate=$bitrate,")
        append("codecLevel=$codecLevel,")
        append("codecProfile=$codecProfile,")
        append("dynamicSubGop=$dynamicSubGop,")
        append("framerateControl=$framerateControl,")
        append("framerateConversionAlgorithm=$framerateConversionAlgorithm,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("gopSize=$gopSize,")
        append("gopSizeUnits=$gopSizeUnits,")
        append("hrdBufferInitialFillPercentage=$hrdBufferInitialFillPercentage,")
        append("hrdBufferSize=$hrdBufferSize,")
        append("interlaceMode=$interlaceMode,")
        append("intraDcPrecision=$intraDcPrecision,")
        append("maxBitrate=$maxBitrate,")
        append("minIInterval=$minIInterval,")
        append("numberBFramesBetweenReferenceFrames=$numberBFramesBetweenReferenceFrames,")
        append("parControl=$parControl,")
        append("parDenominator=$parDenominator,")
        append("parNumerator=$parNumerator,")
        append("qualityTuningLevel=$qualityTuningLevel,")
        append("rateControlMode=$rateControlMode,")
        append("scanTypeConversionMode=$scanTypeConversionMode,")
        append("sceneChangeDetect=$sceneChangeDetect,")
        append("slowPal=$slowPal,")
        append("softness=$softness,")
        append("spatialAdaptiveQuantization=$spatialAdaptiveQuantization,")
        append("syntax=$syntax,")
        append("telecine=$telecine,")
        append("temporalAdaptiveQuantization=$temporalAdaptiveQuantization)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (bitrate ?: 0)
        result = 31 * result + (codecLevel?.hashCode() ?: 0)
        result = 31 * result + (codecProfile?.hashCode() ?: 0)
        result = 31 * result + (dynamicSubGop?.hashCode() ?: 0)
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateConversionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator ?: 0)
        result = 31 * result + (framerateNumerator ?: 0)
        result = 31 * result + (gopClosedCadence ?: 0)
        result = 31 * result + (gopSize?.hashCode() ?: 0)
        result = 31 * result + (gopSizeUnits?.hashCode() ?: 0)
        result = 31 * result + (hrdBufferInitialFillPercentage ?: 0)
        result = 31 * result + (hrdBufferSize ?: 0)
        result = 31 * result + (interlaceMode?.hashCode() ?: 0)
        result = 31 * result + (intraDcPrecision?.hashCode() ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (minIInterval ?: 0)
        result = 31 * result + (numberBFramesBetweenReferenceFrames ?: 0)
        result = 31 * result + (parControl?.hashCode() ?: 0)
        result = 31 * result + (parDenominator ?: 0)
        result = 31 * result + (parNumerator ?: 0)
        result = 31 * result + (qualityTuningLevel?.hashCode() ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        result = 31 * result + (scanTypeConversionMode?.hashCode() ?: 0)
        result = 31 * result + (sceneChangeDetect?.hashCode() ?: 0)
        result = 31 * result + (slowPal?.hashCode() ?: 0)
        result = 31 * result + (softness ?: 0)
        result = 31 * result + (spatialAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (syntax?.hashCode() ?: 0)
        result = 31 * result + (telecine?.hashCode() ?: 0)
        result = 31 * result + (temporalAdaptiveQuantization?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Mpeg2Settings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (bitrate != other.bitrate) return false
        if (codecLevel != other.codecLevel) return false
        if (codecProfile != other.codecProfile) return false
        if (dynamicSubGop != other.dynamicSubGop) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateConversionAlgorithm != other.framerateConversionAlgorithm) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (gopSize != other.gopSize) return false
        if (gopSizeUnits != other.gopSizeUnits) return false
        if (hrdBufferInitialFillPercentage != other.hrdBufferInitialFillPercentage) return false
        if (hrdBufferSize != other.hrdBufferSize) return false
        if (interlaceMode != other.interlaceMode) return false
        if (intraDcPrecision != other.intraDcPrecision) return false
        if (maxBitrate != other.maxBitrate) return false
        if (minIInterval != other.minIInterval) return false
        if (numberBFramesBetweenReferenceFrames != other.numberBFramesBetweenReferenceFrames) return false
        if (parControl != other.parControl) return false
        if (parDenominator != other.parDenominator) return false
        if (parNumerator != other.parNumerator) return false
        if (qualityTuningLevel != other.qualityTuningLevel) return false
        if (rateControlMode != other.rateControlMode) return false
        if (scanTypeConversionMode != other.scanTypeConversionMode) return false
        if (sceneChangeDetect != other.sceneChangeDetect) return false
        if (slowPal != other.slowPal) return false
        if (softness != other.softness) return false
        if (spatialAdaptiveQuantization != other.spatialAdaptiveQuantization) return false
        if (syntax != other.syntax) return false
        if (telecine != other.telecine) return false
        if (temporalAdaptiveQuantization != other.temporalAdaptiveQuantization) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
         */
        var adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2AdaptiveQuantization? = null
        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
         */
        var bitrate: kotlin.Int? = null
        /**
         * Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
         */
        var codecLevel: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2CodecLevel? = null
        /**
         * Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
         */
        var codecProfile: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2CodecProfile? = null
        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         */
        var dynamicSubGop: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2DynamicSubGop? = null
        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         */
        var framerateControl: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2FramerateControl? = null
        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         */
        var framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2FramerateConversionAlgorithm? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateDenominator: kotlin.Int? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateNumerator: kotlin.Int? = null
        /**
         * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open GOPs and then require a closed GOP, set this value to 5. When you create a streaming output, we recommend that you keep the default value, 1, so that players starting mid-stream receive an IDR frame as quickly as possible. Don't set this value to 0; that would break output segmenting.
         */
        var gopClosedCadence: kotlin.Int? = null
        /**
         * Specify the interval between keyframes, in seconds or frames, for this output. Default: 12 Related settings: When you specify the GOP size in seconds, set GOP mode control (GopSizeUnits) to Specified, seconds (SECONDS). The default value for GOP mode control (GopSizeUnits) is Frames (FRAMES).
         */
        var gopSize: kotlin.Double? = null
        /**
         * Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
         */
        var gopSizeUnits: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2GopSizeUnits? = null
        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         */
        var hrdBufferInitialFillPercentage: kotlin.Int? = null
        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         */
        var hrdBufferSize: kotlin.Int? = null
        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
         */
        var interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2InterlaceMode? = null
        /**
         * Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
         */
        var intraDcPrecision: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2IntraDcPrecision? = null
        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
         */
        var maxBitrate: kotlin.Int? = null
        /**
         * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the I-frames that it inserts for Scene change detection. When you specify a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
         */
        var minIInterval: kotlin.Int? = null
        /**
         * Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
         */
        var numberBFramesBetweenReferenceFrames: kotlin.Int? = null
        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
         */
        var parControl: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2ParControl? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         */
        var parDenominator: kotlin.Int? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         */
        var parNumerator: kotlin.Int? = null
        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         */
        var qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2QualityTuningLevel? = null
        /**
         * Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
         */
        var rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2RateControlMode? = null
        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         */
        var scanTypeConversionMode: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2ScanTypeConversionMode? = null
        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
         */
        var sceneChangeDetect: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2SceneChangeDetect? = null
        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
         */
        var slowPal: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2SlowPal? = null
        /**
         * Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, to use the AWS Elemental default matrices. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
         */
        var softness: kotlin.Int? = null
        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         */
        var spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2SpatialAdaptiveQuantization? = null
        /**
         * Specify whether this output's video uses the D10 syntax. Keep the default value to not use the syntax. Related settings: When you choose D10 (D_10) for your MXF profile (profile), you must also set this value to to D10 (D_10).
         */
        var syntax: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Syntax? = null
        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
         */
        var telecine: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Telecine? = null
        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
         */
        var temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2TemporalAdaptiveQuantization? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.bitrate = x.bitrate
            this.codecLevel = x.codecLevel
            this.codecProfile = x.codecProfile
            this.dynamicSubGop = x.dynamicSubGop
            this.framerateControl = x.framerateControl
            this.framerateConversionAlgorithm = x.framerateConversionAlgorithm
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopClosedCadence = x.gopClosedCadence
            this.gopSize = x.gopSize
            this.gopSizeUnits = x.gopSizeUnits
            this.hrdBufferInitialFillPercentage = x.hrdBufferInitialFillPercentage
            this.hrdBufferSize = x.hrdBufferSize
            this.interlaceMode = x.interlaceMode
            this.intraDcPrecision = x.intraDcPrecision
            this.maxBitrate = x.maxBitrate
            this.minIInterval = x.minIInterval
            this.numberBFramesBetweenReferenceFrames = x.numberBFramesBetweenReferenceFrames
            this.parControl = x.parControl
            this.parDenominator = x.parDenominator
            this.parNumerator = x.parNumerator
            this.qualityTuningLevel = x.qualityTuningLevel
            this.rateControlMode = x.rateControlMode
            this.scanTypeConversionMode = x.scanTypeConversionMode
            this.sceneChangeDetect = x.sceneChangeDetect
            this.slowPal = x.slowPal
            this.softness = x.softness
            this.spatialAdaptiveQuantization = x.spatialAdaptiveQuantization
            this.syntax = x.syntax
            this.telecine = x.telecine
            this.temporalAdaptiveQuantization = x.temporalAdaptiveQuantization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Mpeg2Settings = Mpeg2Settings(this)
    }
}
