// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default. When you enable Noise reducer (NoiseReducer), you must also select a value for Noise reducer filter (NoiseReducerFilter).
 */
class NoiseReducer private constructor(builder: Builder) {
    /**
     * Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
     */
    val filter: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilter? = builder.filter
    /**
     * Settings for a noise reducer filter
     */
    val filterSettings: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilterSettings? = builder.filterSettings
    /**
     * Noise reducer filter settings for spatial filter.
     */
    val spatialFilterSettings: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerSpatialFilterSettings? = builder.spatialFilterSettings
    /**
     * Noise reducer filter settings for temporal filter.
     */
    val temporalFilterSettings: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings? = builder.temporalFilterSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.NoiseReducer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NoiseReducer(")
        append("filter=$filter,")
        append("filterSettings=$filterSettings,")
        append("spatialFilterSettings=$spatialFilterSettings,")
        append("temporalFilterSettings=$temporalFilterSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (filterSettings?.hashCode() ?: 0)
        result = 31 * result + (spatialFilterSettings?.hashCode() ?: 0)
        result = 31 * result + (temporalFilterSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NoiseReducer

        if (filter != other.filter) return false
        if (filterSettings != other.filterSettings) return false
        if (spatialFilterSettings != other.spatialFilterSettings) return false
        if (temporalFilterSettings != other.temporalFilterSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.NoiseReducer = Builder(this).apply(block).build()

    class Builder {
        /**
         * Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
         */
        var filter: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilter? = null
        /**
         * Settings for a noise reducer filter
         */
        var filterSettings: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilterSettings? = null
        /**
         * Noise reducer filter settings for spatial filter.
         */
        var spatialFilterSettings: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerSpatialFilterSettings? = null
        /**
         * Noise reducer filter settings for temporal filter.
         */
        var temporalFilterSettings: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducer) : this() {
            this.filter = x.filter
            this.filterSettings = x.filterSettings
            this.spatialFilterSettings = x.spatialFilterSettings
            this.temporalFilterSettings = x.temporalFilterSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.NoiseReducer = NoiseReducer(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilterSettings] inside the given [block]
         */
        fun filterSettings(block: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilterSettings.Builder.() -> kotlin.Unit) {
            this.filterSettings = aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerFilterSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerSpatialFilterSettings] inside the given [block]
         */
        fun spatialFilterSettings(block: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerSpatialFilterSettings.Builder.() -> kotlin.Unit) {
            this.spatialFilterSettings = aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerSpatialFilterSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings] inside the given [block]
         */
        fun temporalFilterSettings(block: aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings.Builder.() -> kotlin.Unit) {
            this.temporalFilterSettings = aws.sdk.kotlin.services.mediaconvert.model.NoiseReducerTemporalFilterSettings.invoke(block)
        }
    }
}
