// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
 */
class Queue private constructor(builder: Builder) {
    /**
     * An identifier for this resource that is unique within all of AWS.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The timestamp in epoch seconds for when you created the queue.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An optional description that you create for each queue.
     */
    val description: kotlin.String? = builder.description
    /**
     * The timestamp in epoch seconds for when you most recently updated the queue.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * A name that you create for each queue. Each name must be unique within your account.
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
     */
    val pricingPlan: aws.sdk.kotlin.services.mediaconvert.model.PricingPlan? = builder.pricingPlan
    /**
     * The estimated number of jobs with a PROGRESSING status.
     */
    val progressingJobsCount: kotlin.Int? = builder.progressingJobsCount
    /**
     * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
     */
    val reservationPlan: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan? = builder.reservationPlan
    /**
     * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
     */
    val status: aws.sdk.kotlin.services.mediaconvert.model.QueueStatus? = builder.status
    /**
     * The estimated number of jobs with a SUBMITTED status.
     */
    val submittedJobsCount: kotlin.Int? = builder.submittedJobsCount
    /**
     * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
     */
    val type: aws.sdk.kotlin.services.mediaconvert.model.Type? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Queue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Queue(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("pricingPlan=$pricingPlan,")
        append("progressingJobsCount=$progressingJobsCount,")
        append("reservationPlan=$reservationPlan,")
        append("status=$status,")
        append("submittedJobsCount=$submittedJobsCount,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (progressingJobsCount ?: 0)
        result = 31 * result + (reservationPlan?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (submittedJobsCount ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Queue

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (pricingPlan != other.pricingPlan) return false
        if (progressingJobsCount != other.progressingJobsCount) return false
        if (reservationPlan != other.reservationPlan) return false
        if (status != other.status) return false
        if (submittedJobsCount != other.submittedJobsCount) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Queue = Builder(this).apply(block).build()

    class Builder {
        /**
         * An identifier for this resource that is unique within all of AWS.
         */
        var arn: kotlin.String? = null
        /**
         * The timestamp in epoch seconds for when you created the queue.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional description that you create for each queue.
         */
        var description: kotlin.String? = null
        /**
         * The timestamp in epoch seconds for when you most recently updated the queue.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A name that you create for each queue. Each name must be unique within your account.
         */
        var name: kotlin.String? = null
        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
         */
        var pricingPlan: aws.sdk.kotlin.services.mediaconvert.model.PricingPlan? = null
        /**
         * The estimated number of jobs with a PROGRESSING status.
         */
        var progressingJobsCount: kotlin.Int? = null
        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
         */
        var reservationPlan: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan? = null
        /**
         * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
         */
        var status: aws.sdk.kotlin.services.mediaconvert.model.QueueStatus? = null
        /**
         * The estimated number of jobs with a SUBMITTED status.
         */
        var submittedJobsCount: kotlin.Int? = null
        /**
         * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
         */
        var type: aws.sdk.kotlin.services.mediaconvert.model.Type? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Queue) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.description = x.description
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.pricingPlan = x.pricingPlan
            this.progressingJobsCount = x.progressingJobsCount
            this.reservationPlan = x.reservationPlan
            this.status = x.status
            this.submittedJobsCount = x.submittedJobsCount
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Queue = Queue(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan] inside the given [block]
         */
        fun reservationPlan(block: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan.Builder.() -> kotlin.Unit) {
            this.reservationPlan = aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan.invoke(block)
        }
    }
}
