// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
 */
class ReservationPlan private constructor(builder: Builder) {
    /**
     * The length of the term of your reserved queue pricing plan commitment.
     */
    val commitment: aws.sdk.kotlin.services.mediaconvert.model.Commitment? = builder.commitment
    /**
     * The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.
     */
    val expiresAt: aws.smithy.kotlin.runtime.time.Instant? = builder.expiresAt
    /**
     * The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.
     */
    val purchasedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.purchasedAt
    /**
     * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
     */
    val renewalType: aws.sdk.kotlin.services.mediaconvert.model.RenewalType? = builder.renewalType
    /**
     * Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can't decrease the number of RTS in your reserved queue.
     */
    val reservedSlots: kotlin.Int? = builder.reservedSlots
    /**
     * Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
     */
    val status: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservationPlan(")
        append("commitment=$commitment,")
        append("expiresAt=$expiresAt,")
        append("purchasedAt=$purchasedAt,")
        append("renewalType=$renewalType,")
        append("reservedSlots=$reservedSlots,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commitment?.hashCode() ?: 0
        result = 31 * result + (expiresAt?.hashCode() ?: 0)
        result = 31 * result + (purchasedAt?.hashCode() ?: 0)
        result = 31 * result + (renewalType?.hashCode() ?: 0)
        result = 31 * result + (reservedSlots ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservationPlan

        if (commitment != other.commitment) return false
        if (expiresAt != other.expiresAt) return false
        if (purchasedAt != other.purchasedAt) return false
        if (renewalType != other.renewalType) return false
        if (reservedSlots != other.reservedSlots) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan = Builder(this).apply(block).build()

    class Builder {
        /**
         * The length of the term of your reserved queue pricing plan commitment.
         */
        var commitment: aws.sdk.kotlin.services.mediaconvert.model.Commitment? = null
        /**
         * The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.
         */
        var expiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.
         */
        var purchasedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
         */
        var renewalType: aws.sdk.kotlin.services.mediaconvert.model.RenewalType? = null
        /**
         * Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can't decrease the number of RTS in your reserved queue.
         */
        var reservedSlots: kotlin.Int? = null
        /**
         * Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
         */
        var status: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan) : this() {
            this.commitment = x.commitment
            this.expiresAt = x.expiresAt
            this.purchasedAt = x.purchasedAt
            this.renewalType = x.renewalType
            this.reservedSlots = x.reservedSlots
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.ReservationPlan = ReservationPlan(this)
    }
}
