// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * If your output group type is CMAF, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is HLS, DASH, or Microsoft Smooth, use the SpekeKeyProvider settings instead.
 */
class SpekeKeyProviderCmaf private constructor(builder: Builder) {
    /**
     * If you want your key provider to encrypt the content keys that it provides to MediaConvert, set up a certificate with a master key using AWS Certificate Manager. Specify the certificate's Amazon Resource Name (ARN) here.
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * Specify the DRM system IDs that you want signaled in the DASH manifest that MediaConvert creates as part of this CMAF package. The DASH manifest can currently signal up to three system IDs. For more information, see https://dashif.org/identifiers/content_protection/.
     */
    val dashSignaledSystemIds: List<String>? = builder.dashSignaledSystemIds
    /**
     * Specify the DRM system ID that you want signaled in the HLS manifest that MediaConvert creates as part of this CMAF package. The HLS manifest can currently signal only one system ID. For more information, see https://dashif.org/identifiers/content_protection/.
     */
    val hlsSignaledSystemIds: List<String>? = builder.hlsSignaledSystemIds
    /**
     * Specify the resource ID that your SPEKE-compliant key provider uses to identify this content.
     */
    val resourceId: kotlin.String? = builder.resourceId
    /**
     * Specify the URL to the key server that your SPEKE-compliant DRM key provider uses to provide keys for encrypting your content.
     */
    val url: kotlin.String? = builder.url

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpekeKeyProviderCmaf(")
        append("certificateArn=$certificateArn,")
        append("dashSignaledSystemIds=$dashSignaledSystemIds,")
        append("hlsSignaledSystemIds=$hlsSignaledSystemIds,")
        append("resourceId=$resourceId,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (dashSignaledSystemIds?.hashCode() ?: 0)
        result = 31 * result + (hlsSignaledSystemIds?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpekeKeyProviderCmaf

        if (certificateArn != other.certificateArn) return false
        if (dashSignaledSystemIds != other.dashSignaledSystemIds) return false
        if (hlsSignaledSystemIds != other.hlsSignaledSystemIds) return false
        if (resourceId != other.resourceId) return false
        if (url != other.url) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf = Builder(this).apply(block).build()

    class Builder {
        /**
         * If you want your key provider to encrypt the content keys that it provides to MediaConvert, set up a certificate with a master key using AWS Certificate Manager. Specify the certificate's Amazon Resource Name (ARN) here.
         */
        var certificateArn: kotlin.String? = null
        /**
         * Specify the DRM system IDs that you want signaled in the DASH manifest that MediaConvert creates as part of this CMAF package. The DASH manifest can currently signal up to three system IDs. For more information, see https://dashif.org/identifiers/content_protection/.
         */
        var dashSignaledSystemIds: List<String>? = null
        /**
         * Specify the DRM system ID that you want signaled in the HLS manifest that MediaConvert creates as part of this CMAF package. The HLS manifest can currently signal only one system ID. For more information, see https://dashif.org/identifiers/content_protection/.
         */
        var hlsSignaledSystemIds: List<String>? = null
        /**
         * Specify the resource ID that your SPEKE-compliant key provider uses to identify this content.
         */
        var resourceId: kotlin.String? = null
        /**
         * Specify the URL to the key server that your SPEKE-compliant DRM key provider uses to provide keys for encrypting your content.
         */
        var url: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf) : this() {
            this.certificateArn = x.certificateArn
            this.dashSignaledSystemIds = x.dashSignaledSystemIds
            this.hlsSignaledSystemIds = x.hlsSignaledSystemIds
            this.resourceId = x.resourceId
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProviderCmaf = SpekeKeyProviderCmaf(this)
    }
}
