// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



class UpdateJobTemplateRequest private constructor(builder: Builder) {
    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
     */
    val accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = builder.accelerationSettings
    /**
     * The new category for the job template, if you are changing it.
     */
    val category: kotlin.String? = builder.category
    /**
     * The new description for the job template, if you are changing it.
     */
    val description: kotlin.String? = builder.description
    /**
     * Optional list of hop destinations.
     */
    val hopDestinations: List<HopDestination>? = builder.hopDestinations
    /**
     * The name of the job template you are modifying
     */
    val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * The new queue for the job template, if you are changing it.
     */
    val queue: kotlin.String? = builder.queue
    /**
     * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
     */
    val settings: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings? = builder.settings
    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
     */
    val statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = builder.statusUpdateInterval

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateJobTemplateRequest(")
        append("accelerationSettings=$accelerationSettings,")
        append("category=$category,")
        append("description=$description,")
        append("hopDestinations=$hopDestinations,")
        append("name=$name,")
        append("priority=$priority,")
        append("queue=$queue,")
        append("settings=$settings,")
        append("statusUpdateInterval=$statusUpdateInterval)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerationSettings?.hashCode() ?: 0
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hopDestinations?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (queue?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (statusUpdateInterval?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateJobTemplateRequest

        if (accelerationSettings != other.accelerationSettings) return false
        if (category != other.category) return false
        if (description != other.description) return false
        if (hopDestinations != other.hopDestinations) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (queue != other.queue) return false
        if (settings != other.settings) return false
        if (statusUpdateInterval != other.statusUpdateInterval) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
         */
        var accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = null
        /**
         * The new category for the job template, if you are changing it.
         */
        var category: kotlin.String? = null
        /**
         * The new description for the job template, if you are changing it.
         */
        var description: kotlin.String? = null
        /**
         * Optional list of hop destinations.
         */
        var hopDestinations: List<HopDestination>? = null
        /**
         * The name of the job template you are modifying
         */
        var name: kotlin.String? = null
        /**
         * Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
         */
        var priority: kotlin.Int? = null
        /**
         * The new queue for the job template, if you are changing it.
         */
        var queue: kotlin.String? = null
        /**
         * JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
         */
        var settings: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings? = null
        /**
         * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
         */
        var statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateRequest) : this() {
            this.accelerationSettings = x.accelerationSettings
            this.category = x.category
            this.description = x.description
            this.hopDestinations = x.hopDestinations
            this.name = x.name
            this.priority = x.priority
            this.queue = x.queue
            this.settings = x.settings
            this.statusUpdateInterval = x.statusUpdateInterval
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateRequest = UpdateJobTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings] inside the given [block]
         */
        fun accelerationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.Builder.() -> kotlin.Unit) {
            this.accelerationSettings = aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings] inside the given [block]
         */
        fun settings(block: aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings.invoke(block)
        }
    }
}
