// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
 */
class Vp9Settings private constructor(builder: Builder) {
    /**
     * Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
     */
    val bitrate: kotlin.Int? = builder.bitrate
    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
     */
    val framerateControl: aws.sdk.kotlin.services.mediaconvert.model.Vp9FramerateControl? = builder.framerateControl
    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
     */
    val framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.Vp9FramerateConversionAlgorithm? = builder.framerateConversionAlgorithm
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateDenominator: kotlin.Int? = builder.framerateDenominator
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    val framerateNumerator: kotlin.Int? = builder.framerateNumerator
    /**
     * GOP Length (keyframe interval) in frames. Must be greater than zero.
     */
    val gopSize: kotlin.Double? = builder.gopSize
    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    val hrdBufferSize: kotlin.Int? = builder.hrdBufferSize
    /**
     * Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
     */
    val maxBitrate: kotlin.Int? = builder.maxBitrate
    /**
     * Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.
     */
    val parControl: aws.sdk.kotlin.services.mediaconvert.model.Vp9ParControl? = builder.parControl
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    val parDenominator: kotlin.Int? = builder.parDenominator
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    val parNumerator: kotlin.Int? = builder.parNumerator
    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
     */
    val qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.Vp9QualityTuningLevel? = builder.qualityTuningLevel
    /**
     * With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
     */
    val rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.Vp9RateControlMode? = builder.rateControlMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Vp9Settings(")
        append("bitrate=$bitrate,")
        append("framerateControl=$framerateControl,")
        append("framerateConversionAlgorithm=$framerateConversionAlgorithm,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopSize=$gopSize,")
        append("hrdBufferSize=$hrdBufferSize,")
        append("maxBitrate=$maxBitrate,")
        append("parControl=$parControl,")
        append("parDenominator=$parDenominator,")
        append("parNumerator=$parNumerator,")
        append("qualityTuningLevel=$qualityTuningLevel,")
        append("rateControlMode=$rateControlMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitrate ?: 0
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateConversionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator ?: 0)
        result = 31 * result + (framerateNumerator ?: 0)
        result = 31 * result + (gopSize?.hashCode() ?: 0)
        result = 31 * result + (hrdBufferSize ?: 0)
        result = 31 * result + (maxBitrate ?: 0)
        result = 31 * result + (parControl?.hashCode() ?: 0)
        result = 31 * result + (parDenominator ?: 0)
        result = 31 * result + (parNumerator ?: 0)
        result = 31 * result + (qualityTuningLevel?.hashCode() ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Vp9Settings

        if (bitrate != other.bitrate) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateConversionAlgorithm != other.framerateConversionAlgorithm) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopSize != other.gopSize) return false
        if (hrdBufferSize != other.hrdBufferSize) return false
        if (maxBitrate != other.maxBitrate) return false
        if (parControl != other.parControl) return false
        if (parDenominator != other.parDenominator) return false
        if (parNumerator != other.parNumerator) return false
        if (qualityTuningLevel != other.qualityTuningLevel) return false
        if (rateControlMode != other.rateControlMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
         */
        var bitrate: kotlin.Int? = null
        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         */
        var framerateControl: aws.sdk.kotlin.services.mediaconvert.model.Vp9FramerateControl? = null
        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         */
        var framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.Vp9FramerateConversionAlgorithm? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateDenominator: kotlin.Int? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        var framerateNumerator: kotlin.Int? = null
        /**
         * GOP Length (keyframe interval) in frames. Must be greater than zero.
         */
        var gopSize: kotlin.Double? = null
        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         */
        var hrdBufferSize: kotlin.Int? = null
        /**
         * Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
         */
        var maxBitrate: kotlin.Int? = null
        /**
         * Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.
         */
        var parControl: aws.sdk.kotlin.services.mediaconvert.model.Vp9ParControl? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         */
        var parDenominator: kotlin.Int? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         */
        var parNumerator: kotlin.Int? = null
        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
         */
        var qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.Vp9QualityTuningLevel? = null
        /**
         * With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
         */
        var rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.Vp9RateControlMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings) : this() {
            this.bitrate = x.bitrate
            this.framerateControl = x.framerateControl
            this.framerateConversionAlgorithm = x.framerateConversionAlgorithm
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopSize = x.gopSize
            this.hrdBufferSize = x.hrdBufferSize
            this.maxBitrate = x.maxBitrate
            this.parControl = x.parControl
            this.parDenominator = x.parDenominator
            this.parNumerator = x.parNumerator
            this.qualityTuningLevel = x.qualityTuningLevel
            this.rateControlMode = x.rateControlMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Vp9Settings = Vp9Settings(this)
    }
}
