// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.transform

import aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings
import aws.sdk.kotlin.services.mediaconvert.model.HopDestination
import aws.sdk.kotlin.services.mediaconvert.model.JobTemplateSettings
import aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval
import aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateJobTemplateOperationSerializer: HttpSerialize<UpdateJobTemplateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateJobTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "2017-08-29",
                "jobTemplates",
                "${input.name}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateJobTemplateOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateJobTemplateOperationBody(context: ExecutionContext, input: UpdateJobTemplateRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCELERATIONSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accelerationSettings"))
    val CATEGORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("category"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HOPDESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hopDestinations"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val QUEUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queue"))
    val SETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("settings"))
    val STATUSUPDATEINTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusUpdateInterval"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCELERATIONSETTINGS_DESCRIPTOR)
        field(CATEGORY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HOPDESTINATIONS_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(QUEUE_DESCRIPTOR)
        field(SETTINGS_DESCRIPTOR)
        field(STATUSUPDATEINTERVAL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accelerationSettings?.let { field(ACCELERATIONSETTINGS_DESCRIPTOR, it, ::serializeAccelerationSettingsDocument) }
        input.category?.let { field(CATEGORY_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.hopDestinations != null) {
            listField(HOPDESTINATIONS_DESCRIPTOR) {
                for (el0 in input.hopDestinations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeHopDestinationDocument))
                }
            }
        }
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
        input.queue?.let { field(QUEUE_DESCRIPTOR, it) }
        input.settings?.let { field(SETTINGS_DESCRIPTOR, it, ::serializeJobTemplateSettingsDocument) }
        input.statusUpdateInterval?.let { field(STATUSUPDATEINTERVAL_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
