// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.mediaconvert.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.mediaconvert.model.*
import aws.sdk.kotlin.services.mediaconvert.model.AssociateCertificateRequest
import aws.sdk.kotlin.services.mediaconvert.model.AssociateCertificateResponse
import aws.sdk.kotlin.services.mediaconvert.model.CancelJobRequest
import aws.sdk.kotlin.services.mediaconvert.model.CancelJobResponse
import aws.sdk.kotlin.services.mediaconvert.model.CreateJobRequest
import aws.sdk.kotlin.services.mediaconvert.model.CreateJobResponse
import aws.sdk.kotlin.services.mediaconvert.model.CreateJobTemplateRequest
import aws.sdk.kotlin.services.mediaconvert.model.CreateJobTemplateResponse
import aws.sdk.kotlin.services.mediaconvert.model.CreatePresetRequest
import aws.sdk.kotlin.services.mediaconvert.model.CreatePresetResponse
import aws.sdk.kotlin.services.mediaconvert.model.CreateQueueRequest
import aws.sdk.kotlin.services.mediaconvert.model.CreateQueueResponse
import aws.sdk.kotlin.services.mediaconvert.model.DeleteJobTemplateRequest
import aws.sdk.kotlin.services.mediaconvert.model.DeleteJobTemplateResponse
import aws.sdk.kotlin.services.mediaconvert.model.DeletePolicyRequest
import aws.sdk.kotlin.services.mediaconvert.model.DeletePolicyResponse
import aws.sdk.kotlin.services.mediaconvert.model.DeletePresetRequest
import aws.sdk.kotlin.services.mediaconvert.model.DeletePresetResponse
import aws.sdk.kotlin.services.mediaconvert.model.DeleteQueueRequest
import aws.sdk.kotlin.services.mediaconvert.model.DeleteQueueResponse
import aws.sdk.kotlin.services.mediaconvert.model.DescribeEndpointsRequest
import aws.sdk.kotlin.services.mediaconvert.model.DescribeEndpointsResponse
import aws.sdk.kotlin.services.mediaconvert.model.DisassociateCertificateRequest
import aws.sdk.kotlin.services.mediaconvert.model.DisassociateCertificateResponse
import aws.sdk.kotlin.services.mediaconvert.model.GetJobRequest
import aws.sdk.kotlin.services.mediaconvert.model.GetJobResponse
import aws.sdk.kotlin.services.mediaconvert.model.GetJobTemplateRequest
import aws.sdk.kotlin.services.mediaconvert.model.GetJobTemplateResponse
import aws.sdk.kotlin.services.mediaconvert.model.GetPolicyRequest
import aws.sdk.kotlin.services.mediaconvert.model.GetPolicyResponse
import aws.sdk.kotlin.services.mediaconvert.model.GetPresetRequest
import aws.sdk.kotlin.services.mediaconvert.model.GetPresetResponse
import aws.sdk.kotlin.services.mediaconvert.model.GetQueueRequest
import aws.sdk.kotlin.services.mediaconvert.model.GetQueueResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListJobTemplatesRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListJobTemplatesResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListJobsRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListJobsResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListPresetsRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListPresetsResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListQueuesRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListQueuesResponse
import aws.sdk.kotlin.services.mediaconvert.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.mediaconvert.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.mediaconvert.model.PutPolicyRequest
import aws.sdk.kotlin.services.mediaconvert.model.PutPolicyResponse
import aws.sdk.kotlin.services.mediaconvert.model.TagResourceRequest
import aws.sdk.kotlin.services.mediaconvert.model.TagResourceResponse
import aws.sdk.kotlin.services.mediaconvert.model.UntagResourceRequest
import aws.sdk.kotlin.services.mediaconvert.model.UntagResourceResponse
import aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateRequest
import aws.sdk.kotlin.services.mediaconvert.model.UpdateJobTemplateResponse
import aws.sdk.kotlin.services.mediaconvert.model.UpdatePresetRequest
import aws.sdk.kotlin.services.mediaconvert.model.UpdatePresetResponse
import aws.sdk.kotlin.services.mediaconvert.model.UpdateQueueRequest
import aws.sdk.kotlin.services.mediaconvert.model.UpdateQueueResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Elemental MediaConvert
 */
public interface MediaConvertClient : SdkClient {

    override val serviceName: String
        get() = "MediaConvert"
    /**
     * MediaConvertClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MediaConvertClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMediaConvertClient(config)
        }

        public operator fun invoke(config: Config): MediaConvertClient = DefaultMediaConvertClient(config)

        /**
         * Construct a [MediaConvertClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MediaConvertClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMediaConvertClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
     */
    public suspend fun associateCertificate(input: AssociateCertificateRequest): AssociateCertificateResponse

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public suspend fun createJobTemplate(input: CreateJobTemplateRequest): CreateJobTemplateResponse

    /**
     * Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
     */
    public suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse

    /**
     * Permanently delete a job template you have created.
     */
    public suspend fun deleteJobTemplate(input: DeleteJobTemplateRequest): DeleteJobTemplateResponse

    /**
     * Permanently delete a policy that you created.
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest = DeletePolicyRequest {}): DeletePolicyResponse

    /**
     * Permanently delete a preset you have created.
     */
    public suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse

    /**
     * Permanently delete a queue you have created.
     */
    public suspend fun deleteQueue(input: DeleteQueueRequest): DeleteQueueResponse

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
     */
    public suspend fun describeEndpoints(input: DescribeEndpointsRequest = DescribeEndpointsRequest {}): DescribeEndpointsResponse

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.
     */
    public suspend fun disassociateCertificate(input: DisassociateCertificateRequest): DisassociateCertificateResponse

    /**
     * Retrieve the JSON for a specific completed transcoding job.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Retrieve the JSON for a specific job template.
     */
    public suspend fun getJobTemplate(input: GetJobTemplateRequest): GetJobTemplateResponse

    /**
     * Retrieve the JSON for your policy.
     */
    public suspend fun getPolicy(input: GetPolicyRequest = GetPolicyRequest {}): GetPolicyResponse

    /**
     * Retrieve the JSON for a specific preset.
     */
    public suspend fun getPreset(input: GetPresetRequest): GetPresetResponse

    /**
     * Retrieve the JSON for a specific queue.
     */
    public suspend fun getQueue(input: GetQueueRequest): GetQueueResponse

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
     */
    public suspend fun listJobTemplates(input: ListJobTemplatesRequest = ListJobTemplatesRequest {}): ListJobTemplatesResponse

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.
     */
    public suspend fun listJobs(input: ListJobsRequest = ListJobsRequest {}): ListJobsResponse

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
     */
    public suspend fun listPresets(input: ListPresetsRequest = ListPresetsRequest {}): ListPresetsResponse

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.
     */
    public suspend fun listQueues(input: ListQueuesRequest = ListQueuesRequest {}): ListQueuesResponse

    /**
     * Retrieve the tags for a MediaConvert resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Create or change your policy. For more information about policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     */
    public suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Modify one of your existing job templates.
     */
    public suspend fun updateJobTemplate(input: UpdateJobTemplateRequest): UpdateJobTemplateResponse

    /**
     * Modify one of your existing presets.
     */
    public suspend fun updatePreset(input: UpdatePresetRequest): UpdatePresetResponse

    /**
     * Modify one of your existing queues.
     */
    public suspend fun updateQueue(input: UpdateQueueRequest): UpdateQueueResponse
}

/**
 * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
 */
public suspend inline fun MediaConvertClient.associateCertificate(crossinline block: AssociateCertificateRequest.Builder.() -> Unit): AssociateCertificateResponse = associateCertificate(AssociateCertificateRequest.Builder().apply(block).build())

/**
 * Permanently cancel a job. Once you have canceled a job, you can't start it again.
 */
public suspend inline fun MediaConvertClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
public suspend inline fun MediaConvertClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
public suspend inline fun MediaConvertClient.createJobTemplate(crossinline block: CreateJobTemplateRequest.Builder.() -> Unit): CreateJobTemplateResponse = createJobTemplate(CreateJobTemplateRequest.Builder().apply(block).build())

/**
 * Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
public suspend inline fun MediaConvertClient.createPreset(crossinline block: CreatePresetRequest.Builder.() -> Unit): CreatePresetResponse = createPreset(CreatePresetRequest.Builder().apply(block).build())

/**
 * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
 */
public suspend inline fun MediaConvertClient.createQueue(crossinline block: CreateQueueRequest.Builder.() -> Unit): CreateQueueResponse = createQueue(CreateQueueRequest.Builder().apply(block).build())

/**
 * Permanently delete a job template you have created.
 */
public suspend inline fun MediaConvertClient.deleteJobTemplate(crossinline block: DeleteJobTemplateRequest.Builder.() -> Unit): DeleteJobTemplateResponse = deleteJobTemplate(DeleteJobTemplateRequest.Builder().apply(block).build())

/**
 * Permanently delete a policy that you created.
 */
public suspend inline fun MediaConvertClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Permanently delete a preset you have created.
 */
public suspend inline fun MediaConvertClient.deletePreset(crossinline block: DeletePresetRequest.Builder.() -> Unit): DeletePresetResponse = deletePreset(DeletePresetRequest.Builder().apply(block).build())

/**
 * Permanently delete a queue you have created.
 */
public suspend inline fun MediaConvertClient.deleteQueue(crossinline block: DeleteQueueRequest.Builder.() -> Unit): DeleteQueueResponse = deleteQueue(DeleteQueueRequest.Builder().apply(block).build())

/**
 * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
 */
public suspend inline fun MediaConvertClient.describeEndpoints(crossinline block: DescribeEndpointsRequest.Builder.() -> Unit): DescribeEndpointsResponse = describeEndpoints(DescribeEndpointsRequest.Builder().apply(block).build())

/**
 * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.
 */
public suspend inline fun MediaConvertClient.disassociateCertificate(crossinline block: DisassociateCertificateRequest.Builder.() -> Unit): DisassociateCertificateResponse = disassociateCertificate(DisassociateCertificateRequest.Builder().apply(block).build())

/**
 * Retrieve the JSON for a specific completed transcoding job.
 */
public suspend inline fun MediaConvertClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * Retrieve the JSON for a specific job template.
 */
public suspend inline fun MediaConvertClient.getJobTemplate(crossinline block: GetJobTemplateRequest.Builder.() -> Unit): GetJobTemplateResponse = getJobTemplate(GetJobTemplateRequest.Builder().apply(block).build())

/**
 * Retrieve the JSON for your policy.
 */
public suspend inline fun MediaConvertClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Retrieve the JSON for a specific preset.
 */
public suspend inline fun MediaConvertClient.getPreset(crossinline block: GetPresetRequest.Builder.() -> Unit): GetPresetResponse = getPreset(GetPresetRequest.Builder().apply(block).build())

/**
 * Retrieve the JSON for a specific queue.
 */
public suspend inline fun MediaConvertClient.getQueue(crossinline block: GetQueueRequest.Builder.() -> Unit): GetQueueResponse = getQueue(GetQueueRequest.Builder().apply(block).build())

/**
 * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
 */
public suspend inline fun MediaConvertClient.listJobTemplates(crossinline block: ListJobTemplatesRequest.Builder.() -> Unit): ListJobTemplatesResponse = listJobTemplates(ListJobTemplatesRequest.Builder().apply(block).build())

/**
 * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.
 */
public suspend inline fun MediaConvertClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
 */
public suspend inline fun MediaConvertClient.listPresets(crossinline block: ListPresetsRequest.Builder.() -> Unit): ListPresetsResponse = listPresets(ListPresetsRequest.Builder().apply(block).build())

/**
 * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.
 */
public suspend inline fun MediaConvertClient.listQueues(crossinline block: ListQueuesRequest.Builder.() -> Unit): ListQueuesResponse = listQueues(ListQueuesRequest.Builder().apply(block).build())

/**
 * Retrieve the tags for a MediaConvert resource.
 */
public suspend inline fun MediaConvertClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Create or change your policy. For more information about policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
public suspend inline fun MediaConvertClient.putPolicy(crossinline block: PutPolicyRequest.Builder.() -> Unit): PutPolicyResponse = putPolicy(PutPolicyRequest.Builder().apply(block).build())

/**
 * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
 */
public suspend inline fun MediaConvertClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
 */
public suspend inline fun MediaConvertClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Modify one of your existing job templates.
 */
public suspend inline fun MediaConvertClient.updateJobTemplate(crossinline block: UpdateJobTemplateRequest.Builder.() -> Unit): UpdateJobTemplateResponse = updateJobTemplate(UpdateJobTemplateRequest.Builder().apply(block).build())

/**
 * Modify one of your existing presets.
 */
public suspend inline fun MediaConvertClient.updatePreset(crossinline block: UpdatePresetRequest.Builder.() -> Unit): UpdatePresetResponse = updatePreset(UpdatePresetRequest.Builder().apply(block).build())

/**
 * Modify one of your existing queues.
 */
public suspend inline fun MediaConvertClient.updateQueue(crossinline block: UpdateQueueRequest.Builder.() -> Unit): UpdateQueueResponse = updateQueue(UpdateQueueRequest.Builder().apply(block).build())
