// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
 */
public class Ac3Settings private constructor(builder: Builder) {
    /**
     * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
     */
    public val bitrate: kotlin.Int = builder.bitrate
    /**
     * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     */
    public val bitstreamMode: aws.sdk.kotlin.services.mediaconvert.model.Ac3BitstreamMode? = builder.bitstreamMode
    /**
     * Dolby Digital coding mode. Determines number of channels.
     */
    public val codingMode: aws.sdk.kotlin.services.mediaconvert.model.Ac3CodingMode? = builder.codingMode
    /**
     * Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.
     */
    public val dialnorm: kotlin.Int = builder.dialnorm
    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     */
    public val dynamicRangeCompressionLine: aws.sdk.kotlin.services.mediaconvert.model.Ac3DynamicRangeCompressionLine? = builder.dynamicRangeCompressionLine
    /**
     * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that you use the mode-specific settings instead of Dynamic range compression profile (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile, line mode (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode (dynamicRangeCompressionRf). Note that when you specify values for all three settings, MediaConvert ignores the value of this setting in favor of the mode-specific settings. If you do use this setting instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the default Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating modes.
     */
    public val dynamicRangeCompressionProfile: aws.sdk.kotlin.services.mediaconvert.model.Ac3DynamicRangeCompressionProfile? = builder.dynamicRangeCompressionProfile
    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     */
    public val dynamicRangeCompressionRf: aws.sdk.kotlin.services.mediaconvert.model.Ac3DynamicRangeCompressionRf? = builder.dynamicRangeCompressionRf
    /**
     * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     */
    public val lfeFilter: aws.sdk.kotlin.services.mediaconvert.model.Ac3LfeFilter? = builder.lfeFilter
    /**
     * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     */
    public val metadataControl: aws.sdk.kotlin.services.mediaconvert.model.Ac3MetadataControl? = builder.metadataControl
    /**
     * This value is always 48000. It represents the sample rate in Hz.
     */
    public val sampleRate: kotlin.Int = builder.sampleRate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ac3Settings(")
        append("bitrate=$bitrate,")
        append("bitstreamMode=$bitstreamMode,")
        append("codingMode=$codingMode,")
        append("dialnorm=$dialnorm,")
        append("dynamicRangeCompressionLine=$dynamicRangeCompressionLine,")
        append("dynamicRangeCompressionProfile=$dynamicRangeCompressionProfile,")
        append("dynamicRangeCompressionRf=$dynamicRangeCompressionRf,")
        append("lfeFilter=$lfeFilter,")
        append("metadataControl=$metadataControl,")
        append("sampleRate=$sampleRate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitrate
        result = 31 * result + (bitstreamMode?.hashCode() ?: 0)
        result = 31 * result + (codingMode?.hashCode() ?: 0)
        result = 31 * result + (dialnorm)
        result = 31 * result + (dynamicRangeCompressionLine?.hashCode() ?: 0)
        result = 31 * result + (dynamicRangeCompressionProfile?.hashCode() ?: 0)
        result = 31 * result + (dynamicRangeCompressionRf?.hashCode() ?: 0)
        result = 31 * result + (lfeFilter?.hashCode() ?: 0)
        result = 31 * result + (metadataControl?.hashCode() ?: 0)
        result = 31 * result + (sampleRate)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ac3Settings

        if (bitrate != other.bitrate) return false
        if (bitstreamMode != other.bitstreamMode) return false
        if (codingMode != other.codingMode) return false
        if (dialnorm != other.dialnorm) return false
        if (dynamicRangeCompressionLine != other.dynamicRangeCompressionLine) return false
        if (dynamicRangeCompressionProfile != other.dynamicRangeCompressionProfile) return false
        if (dynamicRangeCompressionRf != other.dynamicRangeCompressionRf) return false
        if (lfeFilter != other.lfeFilter) return false
        if (metadataControl != other.metadataControl) return false
        if (sampleRate != other.sampleRate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
         */
        public var bitrate: kotlin.Int = 0
        /**
         * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         */
        public var bitstreamMode: aws.sdk.kotlin.services.mediaconvert.model.Ac3BitstreamMode? = null
        /**
         * Dolby Digital coding mode. Determines number of channels.
         */
        public var codingMode: aws.sdk.kotlin.services.mediaconvert.model.Ac3CodingMode? = null
        /**
         * Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.
         */
        public var dialnorm: kotlin.Int = 0
        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         */
        public var dynamicRangeCompressionLine: aws.sdk.kotlin.services.mediaconvert.model.Ac3DynamicRangeCompressionLine? = null
        /**
         * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that you use the mode-specific settings instead of Dynamic range compression profile (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile, line mode (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode (dynamicRangeCompressionRf). Note that when you specify values for all three settings, MediaConvert ignores the value of this setting in favor of the mode-specific settings. If you do use this setting instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the default Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating modes.
         */
        public var dynamicRangeCompressionProfile: aws.sdk.kotlin.services.mediaconvert.model.Ac3DynamicRangeCompressionProfile? = null
        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting, MediaConvert ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         */
        public var dynamicRangeCompressionRf: aws.sdk.kotlin.services.mediaconvert.model.Ac3DynamicRangeCompressionRf? = null
        /**
         * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
         */
        public var lfeFilter: aws.sdk.kotlin.services.mediaconvert.model.Ac3LfeFilter? = null
        /**
         * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
         */
        public var metadataControl: aws.sdk.kotlin.services.mediaconvert.model.Ac3MetadataControl? = null
        /**
         * This value is always 48000. It represents the sample rate in Hz.
         */
        public var sampleRate: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings) : this() {
            this.bitrate = x.bitrate
            this.bitstreamMode = x.bitstreamMode
            this.codingMode = x.codingMode
            this.dialnorm = x.dialnorm
            this.dynamicRangeCompressionLine = x.dynamicRangeCompressionLine
            this.dynamicRangeCompressionProfile = x.dynamicRangeCompressionProfile
            this.dynamicRangeCompressionRf = x.dynamicRangeCompressionRf
            this.lfeFilter = x.lfeFilter
            this.metadataControl = x.metadataControl
            this.sampleRate = x.sampleRate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Ac3Settings = Ac3Settings(this)
    }
}
