// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model

import kotlin.collections.List

/**
 * Apply audio timing corrections to help synchronize audio and video in your output. To apply timing corrections, your input must meet the following requirements: * Container: MP4, or MOV, with an accurate time-to-sample (STTS) table. * Audio track: AAC. Choose from the following audio timing correction settings: * Disabled (Default): Apply no correction. * Auto: Recommended for most inputs. MediaConvert analyzes the audio timing in your input and determines which correction setting to use, if needed. * Track: Adjust the duration of each audio frame by a constant amount to align the audio track length with STTS duration. Track-level correction does not affect pitch, and is recommended for tonal audio content such as music. * Frame: Adjust the duration of each audio frame by a variable amount to align audio frames with STTS timestamps. No corrections are made to already-aligned frames. Frame-level correction may affect the pitch of corrected frames, and is recommended for atonal audio content such as speech or percussion.
 */
public sealed class AudioDurationCorrection {

    public abstract val value: kotlin.String

    public object Auto : aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection() {
        override val value: kotlin.String = "AUTO"
        override fun toString(): kotlin.String = value
    }

    public object Disabled : aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection() {
        override val value: kotlin.String = "DISABLED"
        override fun toString(): kotlin.String = value
    }

    public object Frame : aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection() {
        override val value: kotlin.String = "FRAME"
        override fun toString(): kotlin.String = value
    }

    public object Track : aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection() {
        override val value: kotlin.String = "TRACK"
        override fun toString(): kotlin.String = value
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection() {
        override fun toString(): kotlin.String = value
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(str: kotlin.String): aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection = when(str) {
            "AUTO" -> Auto
            "DISABLED" -> Disabled
            "FRAME" -> Frame
            "TRACK" -> Track
            else -> SdkUnknown(str)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.mediaconvert.model.AudioDurationCorrection> = listOf(
            Auto,
            Disabled,
            Frame,
            Track
        )
    }
}
