// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based on characteristics of your input video. This feature optimizes video quality while minimizing the overall size of your ABR package.
 */
public class AutomatedAbrSettings private constructor(builder: Builder) {
    /**
     * Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper limit on the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered to viewers with the fastest internet connections. If you don't specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default.
     */
    public val maxAbrBitrate: kotlin.Int = builder.maxAbrBitrate
    /**
     * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The number of renditions is determined automatically, based on analysis of each job, but will never exceed this limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON job specification, MediaConvert defaults to a limit of 15.
     */
    public val maxRenditions: kotlin.Int = builder.maxRenditions
    /**
     * Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower limit on the bitrate of video delivered to viewers with slow internet connections. If you don't specify a value, MediaConvert uses 600,000 (600 kb/s) by default.
     */
    public val minAbrBitrate: kotlin.Int = builder.minAbrBitrate
    /**
     * Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will create in your ABR stack. You can use these rules if your ABR workflow has specific rendition size requirements, but you still want MediaConvert to optimize for video quality and overall file size.
     */
    public val rules: List<AutomatedAbrRule>? = builder.rules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomatedAbrSettings(")
        append("maxAbrBitrate=$maxAbrBitrate,")
        append("maxRenditions=$maxRenditions,")
        append("minAbrBitrate=$minAbrBitrate,")
        append("rules=$rules)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxAbrBitrate
        result = 31 * result + (maxRenditions)
        result = 31 * result + (minAbrBitrate)
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomatedAbrSettings

        if (maxAbrBitrate != other.maxAbrBitrate) return false
        if (maxRenditions != other.maxRenditions) return false
        if (minAbrBitrate != other.minAbrBitrate) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional. The maximum target bit rate used in your automated ABR stack. Use this value to set an upper limit on the bandwidth consumed by the highest-quality rendition. This is the rendition that is delivered to viewers with the fastest internet connections. If you don't specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default.
         */
        public var maxAbrBitrate: kotlin.Int = 0
        /**
         * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The number of renditions is determined automatically, based on analysis of each job, but will never exceed this limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON job specification, MediaConvert defaults to a limit of 15.
         */
        public var maxRenditions: kotlin.Int = 0
        /**
         * Optional. The minimum target bitrate used in your automated ABR stack. Use this value to set a lower limit on the bitrate of video delivered to viewers with slow internet connections. If you don't specify a value, MediaConvert uses 600,000 (600 kb/s) by default.
         */
        public var minAbrBitrate: kotlin.Int = 0
        /**
         * Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will create in your ABR stack. You can use these rules if your ABR workflow has specific rendition size requirements, but you still want MediaConvert to optimize for video quality and overall file size.
         */
        public var rules: List<AutomatedAbrRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings) : this() {
            this.maxAbrBitrate = x.maxAbrBitrate
            this.maxRenditions = x.maxRenditions
            this.minAbrBitrate = x.minAbrBitrate
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.AutomatedAbrSettings = AutomatedAbrSettings(this)
    }
}
