// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
 */
public class Av1Settings private constructor(builder: Builder) {
    /**
     * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
     */
    public val adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Av1AdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Specify the Bit depth (Av1BitDepth). You can choose 8-bit (BIT_8) or 10-bit (BIT_10).
     */
    public val bitDepth: aws.sdk.kotlin.services.mediaconvert.model.Av1BitDepth? = builder.bitDepth
    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
     */
    public val framerateControl: aws.sdk.kotlin.services.mediaconvert.model.Av1FramerateControl? = builder.framerateControl
    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
     */
    public val framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.Av1FramerateConversionAlgorithm? = builder.framerateConversionAlgorithm
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    public val framerateDenominator: kotlin.Int = builder.framerateDenominator
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    public val framerateNumerator: kotlin.Int = builder.framerateNumerator
    /**
     * Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn't support GOP length in seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames + 1) * x), where x is an integer value.
     */
    public val gopSize: kotlin.Double = builder.gopSize
    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
     */
    public val maxBitrate: kotlin.Int = builder.maxBitrate
    /**
     * Specify from the number of B-frames, in the range of 0-15. For AV1 encoding, we recommend using 7 or 15. Choose a larger number for a lower bitrate and smaller file size; choose a smaller number for better video quality.
     */
    public val numberBFramesBetweenReferenceFrames: kotlin.Int = builder.numberBFramesBetweenReferenceFrames
    /**
     * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
     */
    public val qvbrSettings: aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings? = builder.qvbrSettings
    /**
     * 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR). You can''t use CBR or VBR.'
     */
    public val rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.Av1RateControlMode? = builder.rateControlMode
    /**
     * Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive pictures, this value must be less than or equal to the number of macroblock rows. For interlaced pictures, this value must be less than or equal to half the number of macroblock rows.
     */
    public val slices: kotlin.Int = builder.slices
    /**
     * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
     */
    public val spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Av1SpatialAdaptiveQuantization? = builder.spatialAdaptiveQuantization

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Av1Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Av1Settings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("bitDepth=$bitDepth,")
        append("framerateControl=$framerateControl,")
        append("framerateConversionAlgorithm=$framerateConversionAlgorithm,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopSize=$gopSize,")
        append("maxBitrate=$maxBitrate,")
        append("numberBFramesBetweenReferenceFrames=$numberBFramesBetweenReferenceFrames,")
        append("qvbrSettings=$qvbrSettings,")
        append("rateControlMode=$rateControlMode,")
        append("slices=$slices,")
        append("spatialAdaptiveQuantization=$spatialAdaptiveQuantization)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (bitDepth?.hashCode() ?: 0)
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateConversionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator)
        result = 31 * result + (framerateNumerator)
        result = 31 * result + (gopSize.hashCode())
        result = 31 * result + (maxBitrate)
        result = 31 * result + (numberBFramesBetweenReferenceFrames)
        result = 31 * result + (qvbrSettings?.hashCode() ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        result = 31 * result + (slices)
        result = 31 * result + (spatialAdaptiveQuantization?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Av1Settings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (bitDepth != other.bitDepth) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateConversionAlgorithm != other.framerateConversionAlgorithm) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopSize != other.gopSize) return false
        if (maxBitrate != other.maxBitrate) return false
        if (numberBFramesBetweenReferenceFrames != other.numberBFramesBetweenReferenceFrames) return false
        if (qvbrSettings != other.qvbrSettings) return false
        if (rateControlMode != other.rateControlMode) return false
        if (slices != other.slices) return false
        if (spatialAdaptiveQuantization != other.spatialAdaptiveQuantization) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Av1Settings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to Spatial adaptive quantization (spatialAdaptiveQuantization).
         */
        public var adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Av1AdaptiveQuantization? = null
        /**
         * Specify the Bit depth (Av1BitDepth). You can choose 8-bit (BIT_8) or 10-bit (BIT_10).
         */
        public var bitDepth: aws.sdk.kotlin.services.mediaconvert.model.Av1BitDepth? = null
        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         */
        public var framerateControl: aws.sdk.kotlin.services.mediaconvert.model.Av1FramerateControl? = null
        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         */
        public var framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.Av1FramerateConversionAlgorithm? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        public var framerateDenominator: kotlin.Int = 0
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        public var framerateNumerator: kotlin.Int = 0
        /**
         * Specify the GOP length (keyframe interval) in frames. With AV1, MediaConvert doesn't support GOP length in seconds. This value must be greater than zero and preferably equal to 1 + ((numberBFrames + 1) * x), where x is an integer value.
         */
        public var gopSize: kotlin.Double = 0.0
        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
         */
        public var maxBitrate: kotlin.Int = 0
        /**
         * Specify from the number of B-frames, in the range of 0-15. For AV1 encoding, we recommend using 7 or 15. Choose a larger number for a lower bitrate and smaller file size; choose a smaller number for better video quality.
         */
        public var numberBFramesBetweenReferenceFrames: kotlin.Int = 0
        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
         */
        public var qvbrSettings: aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings? = null
        /**
         * 'With AV1 outputs, for rate control mode, MediaConvert supports only quality-defined variable bitrate (QVBR). You can''t use CBR or VBR.'
         */
        public var rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.Av1RateControlMode? = null
        /**
         * Specify the number of slices per picture. This value must be 1, 2, 4, 8, 16, or 32. For progressive pictures, this value must be less than or equal to the number of macroblock rows. For interlaced pictures, this value must be less than or equal to half the number of macroblock rows.
         */
        public var slices: kotlin.Int = 0
        /**
         * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
         */
        public var spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.Av1SpatialAdaptiveQuantization? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Av1Settings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.bitDepth = x.bitDepth
            this.framerateControl = x.framerateControl
            this.framerateConversionAlgorithm = x.framerateConversionAlgorithm
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopSize = x.gopSize
            this.maxBitrate = x.maxBitrate
            this.numberBFramesBetweenReferenceFrames = x.numberBFramesBetweenReferenceFrames
            this.qvbrSettings = x.qvbrSettings
            this.rateControlMode = x.rateControlMode
            this.slices = x.slices
            this.spatialAdaptiveQuantization = x.spatialAdaptiveQuantization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Av1Settings = Av1Settings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings] inside the given [block]
         */
        public fun qvbrSettings(block: aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings.Builder.() -> kotlin.Unit) {
            this.qvbrSettings = aws.sdk.kotlin.services.mediaconvert.model.Av1QvbrSettings.invoke(block)
        }
    }
}
