// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
 */
public class CmfcSettings private constructor(builder: Builder) {
    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     */
    public val audioDuration: aws.sdk.kotlin.services.mediaconvert.model.CmfcAudioDuration? = builder.audioDuration
    /**
     * Specify the audio rendition group for this audio rendition. Specify up to one value for each audio output in your output group. This value appears in your HLS parent manifest in the EXT-X-MEDIA tag of TYPE=AUDIO, as the value for the GROUP-ID attribute. For example, if you specify "audio_aac_1" for Audio group ID, it appears in your manifest like this: #EXT-X-MEDIA:TYPE=AUDIO,GROUP-ID="audio_aac_1". Related setting: To associate the rendition group that this audio track belongs to with a video rendition, include the same value that you provide here for that video output's setting Audio rendition sets (audioRenditionSets).
     */
    public val audioGroupId: kotlin.String? = builder.audioGroupId
    /**
     * List the audio rendition groups that you want included with this video rendition. Use a comma-separated list. For example, say you want to include the audio rendition groups that have the audio group IDs "audio_aac_1" and "audio_dolby". Then you would specify this value: "audio_aac_1,audio_dolby". Related setting: The rendition groups that you include in your comma-separated list should all match values that you specify in the setting Audio group ID (AudioGroupId) for audio renditions in the same output group as this video rendition. Default behavior: If you don't specify anything here and for Audio group ID, MediaConvert puts each audio variant in its own audio rendition group and associates it with every video variant. Each value in your list appears in your HLS parent manifest in the EXT-X-STREAM-INF tag as the value for the AUDIO attribute. To continue the previous example, say that the file name for the child manifest for your video rendition is "amazing_video_1.m3u8". Then, in your parent manifest, each value will appear on separate lines, like this: #EXT-X-STREAM-INF:AUDIO="audio_aac_1"... amazing_video_1.m3u8 #EXT-X-STREAM-INF:AUDIO="audio_dolby"... amazing_video_1.m3u8
     */
    public val audioRenditionSets: kotlin.String? = builder.audioRenditionSets
    /**
     * Use this setting to control the values that MediaConvert puts in your HLS parent playlist to control how the client player selects which audio track to play. The other options for this setting determine the values that MediaConvert writes for the DEFAULT and AUTOSELECT attributes of the EXT-X-MEDIA entry for the audio variant. For more information about these attributes, see the Apple documentation article https://developer.apple.com/documentation/http_live_streaming/example_playlists_for_http_live_streaming/adding_alternate_media_to_a_playlist. Choose Alternate audio, auto select, default (ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT) to set DEFAULT=YES and AUTOSELECT=YES. Choose this value for only one variant in your output group. Choose Alternate audio, auto select, not default (ALTERNATE_AUDIO_AUTO_SELECT) to set DEFAULT=NO and AUTOSELECT=YES. Choose Alternate Audio, Not Auto Select to set DEFAULT=NO and AUTOSELECT=NO. When you don't specify a value for this setting, MediaConvert defaults to Alternate audio, auto select, default. When there is more than one variant in your output group, you must explicitly choose a value for this setting.
     */
    public val audioTrackType: aws.sdk.kotlin.services.mediaconvert.model.CmfcAudioTrackType? = builder.audioTrackType
    /**
     * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you choose Flag (FLAG), MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag (DONT_FLAG), MediaConvert leaves this parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple documentation.
     */
    public val descriptiveVideoServiceFlag: aws.sdk.kotlin.services.mediaconvert.model.CmfcDescriptiveVideoServiceFlag? = builder.descriptiveVideoServiceFlag
    /**
     * Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames for this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default value Exclude (EXCLUDE).
     */
    public val iFrameOnlyManifest: aws.sdk.kotlin.services.mediaconvert.model.CmfcIFrameOnlyManifest? = builder.iFrameOnlyManifest
    /**
     * To include key-length-value metadata in this output: Set KLV metadata insertion to Passthrough. MediaConvert reads KLV metadata present in your input and writes each instance to a separate event message box in the output, according to MISB ST1910.1. To exclude this KLV metadata: Set KLV metadata insertion to None or leave blank.
     */
    public val klvMetadata: aws.sdk.kotlin.services.mediaconvert.model.CmfcKlvMetadata? = builder.klvMetadata
    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).
     */
    public val scte35Esam: aws.sdk.kotlin.services.mediaconvert.model.CmfcScte35Esam? = builder.scte35Esam
    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want those SCTE-35 markers in this output.
     */
    public val scte35Source: aws.sdk.kotlin.services.mediaconvert.model.CmfcScte35Source? = builder.scte35Source
    /**
     * To include ID3 metadata in this output: Set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). Specify this ID3 metadata in Custom ID3 metadata inserter (timedMetadataInsertion). MediaConvert writes each instance of ID3 metadata in a separate Event Message (eMSG) box. To exclude this ID3 metadata: Set ID3 metadata to None (NONE) or leave blank.
     */
    public val timedMetadata: aws.sdk.kotlin.services.mediaconvert.model.CmfcTimedMetadata? = builder.timedMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CmfcSettings(")
        append("audioDuration=$audioDuration,")
        append("audioGroupId=$audioGroupId,")
        append("audioRenditionSets=$audioRenditionSets,")
        append("audioTrackType=$audioTrackType,")
        append("descriptiveVideoServiceFlag=$descriptiveVideoServiceFlag,")
        append("iFrameOnlyManifest=$iFrameOnlyManifest,")
        append("klvMetadata=$klvMetadata,")
        append("scte35Esam=$scte35Esam,")
        append("scte35Source=$scte35Source,")
        append("timedMetadata=$timedMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioDuration?.hashCode() ?: 0
        result = 31 * result + (audioGroupId?.hashCode() ?: 0)
        result = 31 * result + (audioRenditionSets?.hashCode() ?: 0)
        result = 31 * result + (audioTrackType?.hashCode() ?: 0)
        result = 31 * result + (descriptiveVideoServiceFlag?.hashCode() ?: 0)
        result = 31 * result + (iFrameOnlyManifest?.hashCode() ?: 0)
        result = 31 * result + (klvMetadata?.hashCode() ?: 0)
        result = 31 * result + (scte35Esam?.hashCode() ?: 0)
        result = 31 * result + (scte35Source?.hashCode() ?: 0)
        result = 31 * result + (timedMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CmfcSettings

        if (audioDuration != other.audioDuration) return false
        if (audioGroupId != other.audioGroupId) return false
        if (audioRenditionSets != other.audioRenditionSets) return false
        if (audioTrackType != other.audioTrackType) return false
        if (descriptiveVideoServiceFlag != other.descriptiveVideoServiceFlag) return false
        if (iFrameOnlyManifest != other.iFrameOnlyManifest) return false
        if (klvMetadata != other.klvMetadata) return false
        if (scte35Esam != other.scte35Esam) return false
        if (scte35Source != other.scte35Source) return false
        if (timedMetadata != other.timedMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to very small duration differences between video and audio. For this situation, choose Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
         */
        public var audioDuration: aws.sdk.kotlin.services.mediaconvert.model.CmfcAudioDuration? = null
        /**
         * Specify the audio rendition group for this audio rendition. Specify up to one value for each audio output in your output group. This value appears in your HLS parent manifest in the EXT-X-MEDIA tag of TYPE=AUDIO, as the value for the GROUP-ID attribute. For example, if you specify "audio_aac_1" for Audio group ID, it appears in your manifest like this: #EXT-X-MEDIA:TYPE=AUDIO,GROUP-ID="audio_aac_1". Related setting: To associate the rendition group that this audio track belongs to with a video rendition, include the same value that you provide here for that video output's setting Audio rendition sets (audioRenditionSets).
         */
        public var audioGroupId: kotlin.String? = null
        /**
         * List the audio rendition groups that you want included with this video rendition. Use a comma-separated list. For example, say you want to include the audio rendition groups that have the audio group IDs "audio_aac_1" and "audio_dolby". Then you would specify this value: "audio_aac_1,audio_dolby". Related setting: The rendition groups that you include in your comma-separated list should all match values that you specify in the setting Audio group ID (AudioGroupId) for audio renditions in the same output group as this video rendition. Default behavior: If you don't specify anything here and for Audio group ID, MediaConvert puts each audio variant in its own audio rendition group and associates it with every video variant. Each value in your list appears in your HLS parent manifest in the EXT-X-STREAM-INF tag as the value for the AUDIO attribute. To continue the previous example, say that the file name for the child manifest for your video rendition is "amazing_video_1.m3u8". Then, in your parent manifest, each value will appear on separate lines, like this: #EXT-X-STREAM-INF:AUDIO="audio_aac_1"... amazing_video_1.m3u8 #EXT-X-STREAM-INF:AUDIO="audio_dolby"... amazing_video_1.m3u8
         */
        public var audioRenditionSets: kotlin.String? = null
        /**
         * Use this setting to control the values that MediaConvert puts in your HLS parent playlist to control how the client player selects which audio track to play. The other options for this setting determine the values that MediaConvert writes for the DEFAULT and AUTOSELECT attributes of the EXT-X-MEDIA entry for the audio variant. For more information about these attributes, see the Apple documentation article https://developer.apple.com/documentation/http_live_streaming/example_playlists_for_http_live_streaming/adding_alternate_media_to_a_playlist. Choose Alternate audio, auto select, default (ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT) to set DEFAULT=YES and AUTOSELECT=YES. Choose this value for only one variant in your output group. Choose Alternate audio, auto select, not default (ALTERNATE_AUDIO_AUTO_SELECT) to set DEFAULT=NO and AUTOSELECT=YES. Choose Alternate Audio, Not Auto Select to set DEFAULT=NO and AUTOSELECT=NO. When you don't specify a value for this setting, MediaConvert defaults to Alternate audio, auto select, default. When there is more than one variant in your output group, you must explicitly choose a value for this setting.
         */
        public var audioTrackType: aws.sdk.kotlin.services.mediaconvert.model.CmfcAudioTrackType? = null
        /**
         * Specify whether to flag this audio track as descriptive video service (DVS) in your HLS parent manifest. When you choose Flag (FLAG), MediaConvert includes the parameter CHARACTERISTICS="public.accessibility.describes-video" in the EXT-X-MEDIA entry for this track. When you keep the default choice, Don't flag (DONT_FLAG), MediaConvert leaves this parameter out. The DVS flag can help with accessibility on Apple devices. For more information, see the Apple documentation.
         */
        public var descriptiveVideoServiceFlag: aws.sdk.kotlin.services.mediaconvert.model.CmfcDescriptiveVideoServiceFlag? = null
        /**
         * Choose Include (INCLUDE) to have MediaConvert generate an HLS child manifest that lists only the I-frames for this rendition, in addition to your regular manifest for this rendition. You might use this manifest as part of a workflow that creates preview functions for your video. MediaConvert adds both the I-frame only child manifest and the regular child manifest to the parent manifest. When you don't need the I-frame only child manifest, keep the default value Exclude (EXCLUDE).
         */
        public var iFrameOnlyManifest: aws.sdk.kotlin.services.mediaconvert.model.CmfcIFrameOnlyManifest? = null
        /**
         * To include key-length-value metadata in this output: Set KLV metadata insertion to Passthrough. MediaConvert reads KLV metadata present in your input and writes each instance to a separate event message box in the output, according to MISB ST1910.1. To exclude this KLV metadata: Set KLV metadata insertion to None or leave blank.
         */
        public var klvMetadata: aws.sdk.kotlin.services.mediaconvert.model.CmfcKlvMetadata? = null
        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC XML (sccXml).
         */
        public var scte35Esam: aws.sdk.kotlin.services.mediaconvert.model.CmfcScte35Esam? = null
        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         */
        public var scte35Source: aws.sdk.kotlin.services.mediaconvert.model.CmfcScte35Source? = null
        /**
         * To include ID3 metadata in this output: Set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). Specify this ID3 metadata in Custom ID3 metadata inserter (timedMetadataInsertion). MediaConvert writes each instance of ID3 metadata in a separate Event Message (eMSG) box. To exclude this ID3 metadata: Set ID3 metadata to None (NONE) or leave blank.
         */
        public var timedMetadata: aws.sdk.kotlin.services.mediaconvert.model.CmfcTimedMetadata? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings) : this() {
            this.audioDuration = x.audioDuration
            this.audioGroupId = x.audioGroupId
            this.audioRenditionSets = x.audioRenditionSets
            this.audioTrackType = x.audioTrackType
            this.descriptiveVideoServiceFlag = x.descriptiveVideoServiceFlag
            this.iFrameOnlyManifest = x.iFrameOnlyManifest
            this.klvMetadata = x.klvMetadata
            this.scte35Esam = x.scte35Esam
            this.scte35Source = x.scte35Source
            this.timedMetadata = x.timedMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings = CmfcSettings(this)
    }
}
