// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Container specific settings.
 */
public class ContainerSettings private constructor(builder: Builder) {
    /**
     * These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
     */
    public val cmfcSettings: aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings? = builder.cmfcSettings
    /**
     * Container for this output. Some containers require a container settings object. If not specified, the default object will be created.
     */
    public val container: aws.sdk.kotlin.services.mediaconvert.model.ContainerType? = builder.container
    /**
     * Settings for F4v container
     */
    public val f4VSettings: aws.sdk.kotlin.services.mediaconvert.model.F4VSettings? = builder.f4VSettings
    /**
     * MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container (ContainerType) is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each transport stream program contains subsets of data, including audio, video, and metadata. Each of these subsets of data has a numerical label called a packet identifier (PID). Each transport stream program corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID. Downstream systems and players use the program map table to look up the PID for each type of data it accesses and then uses the PIDs to locate specific data within the asset.
     */
    public val m2TsSettings: aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings? = builder.m2TsSettings
    /**
     * These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in your HLS outputs.
     */
    public val m3U8Settings: aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings? = builder.m3U8Settings
    /**
     * These settings relate to your QuickTime MOV output container.
     */
    public val movSettings: aws.sdk.kotlin.services.mediaconvert.model.MovSettings? = builder.movSettings
    /**
     * These settings relate to your MP4 output container. You can create audio only outputs with this container. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio-only.html#output-codecs-and-containers-supported-for-audio-only.
     */
    public val mp4Settings: aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings? = builder.mp4Settings
    /**
     * These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
     */
    public val mpdSettings: aws.sdk.kotlin.services.mediaconvert.model.MpdSettings? = builder.mpdSettings
    /**
     * These settings relate to your MXF output container.
     */
    public val mxfSettings: aws.sdk.kotlin.services.mediaconvert.model.MxfSettings? = builder.mxfSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerSettings(")
        append("cmfcSettings=$cmfcSettings,")
        append("container=$container,")
        append("f4VSettings=$f4VSettings,")
        append("m2TsSettings=$m2TsSettings,")
        append("m3U8Settings=$m3U8Settings,")
        append("movSettings=$movSettings,")
        append("mp4Settings=$mp4Settings,")
        append("mpdSettings=$mpdSettings,")
        append("mxfSettings=$mxfSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cmfcSettings?.hashCode() ?: 0
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (f4VSettings?.hashCode() ?: 0)
        result = 31 * result + (m2TsSettings?.hashCode() ?: 0)
        result = 31 * result + (m3U8Settings?.hashCode() ?: 0)
        result = 31 * result + (movSettings?.hashCode() ?: 0)
        result = 31 * result + (mp4Settings?.hashCode() ?: 0)
        result = 31 * result + (mpdSettings?.hashCode() ?: 0)
        result = 31 * result + (mxfSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerSettings

        if (cmfcSettings != other.cmfcSettings) return false
        if (container != other.container) return false
        if (f4VSettings != other.f4VSettings) return false
        if (m2TsSettings != other.m2TsSettings) return false
        if (m3U8Settings != other.m3U8Settings) return false
        if (movSettings != other.movSettings) return false
        if (mp4Settings != other.mp4Settings) return false
        if (mpdSettings != other.mpdSettings) return false
        if (mxfSettings != other.mxfSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * These settings relate to the fragmented MP4 container for the segments in your CMAF outputs.
         */
        public var cmfcSettings: aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings? = null
        /**
         * Container for this output. Some containers require a container settings object. If not specified, the default object will be created.
         */
        public var container: aws.sdk.kotlin.services.mediaconvert.model.ContainerType? = null
        /**
         * Settings for F4v container
         */
        public var f4VSettings: aws.sdk.kotlin.services.mediaconvert.model.F4VSettings? = null
        /**
         * MPEG-2 TS container settings. These apply to outputs in a File output group when the output's container (ContainerType) is MPEG-2 Transport Stream (M2TS). In these assets, data is organized by the program map table (PMT). Each transport stream program contains subsets of data, including audio, video, and metadata. Each of these subsets of data has a numerical label called a packet identifier (PID). Each transport stream program corresponds to one MediaConvert output. The PMT lists the types of data in a program along with their PID. Downstream systems and players use the program map table to look up the PID for each type of data it accesses and then uses the PIDs to locate specific data within the asset.
         */
        public var m2TsSettings: aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings? = null
        /**
         * These settings relate to the MPEG-2 transport stream (MPEG2-TS) container for the MPEG2-TS segments in your HLS outputs.
         */
        public var m3U8Settings: aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings? = null
        /**
         * These settings relate to your QuickTime MOV output container.
         */
        public var movSettings: aws.sdk.kotlin.services.mediaconvert.model.MovSettings? = null
        /**
         * These settings relate to your MP4 output container. You can create audio only outputs with this container. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio-only.html#output-codecs-and-containers-supported-for-audio-only.
         */
        public var mp4Settings: aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings? = null
        /**
         * These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
         */
        public var mpdSettings: aws.sdk.kotlin.services.mediaconvert.model.MpdSettings? = null
        /**
         * These settings relate to your MXF output container.
         */
        public var mxfSettings: aws.sdk.kotlin.services.mediaconvert.model.MxfSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings) : this() {
            this.cmfcSettings = x.cmfcSettings
            this.container = x.container
            this.f4VSettings = x.f4VSettings
            this.m2TsSettings = x.m2TsSettings
            this.m3U8Settings = x.m3U8Settings
            this.movSettings = x.movSettings
            this.mp4Settings = x.mp4Settings
            this.mpdSettings = x.mpdSettings
            this.mxfSettings = x.mxfSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.ContainerSettings = ContainerSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings] inside the given [block]
         */
        public fun cmfcSettings(block: aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings.Builder.() -> kotlin.Unit) {
            this.cmfcSettings = aws.sdk.kotlin.services.mediaconvert.model.CmfcSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.F4VSettings] inside the given [block]
         */
        public fun f4VSettings(block: aws.sdk.kotlin.services.mediaconvert.model.F4VSettings.Builder.() -> kotlin.Unit) {
            this.f4VSettings = aws.sdk.kotlin.services.mediaconvert.model.F4VSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings] inside the given [block]
         */
        public fun m2TsSettings(block: aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings.Builder.() -> kotlin.Unit) {
            this.m2TsSettings = aws.sdk.kotlin.services.mediaconvert.model.M2TsSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings] inside the given [block]
         */
        public fun m3U8Settings(block: aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings.Builder.() -> kotlin.Unit) {
            this.m3U8Settings = aws.sdk.kotlin.services.mediaconvert.model.M3U8Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MovSettings] inside the given [block]
         */
        public fun movSettings(block: aws.sdk.kotlin.services.mediaconvert.model.MovSettings.Builder.() -> kotlin.Unit) {
            this.movSettings = aws.sdk.kotlin.services.mediaconvert.model.MovSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings] inside the given [block]
         */
        public fun mp4Settings(block: aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings.Builder.() -> kotlin.Unit) {
            this.mp4Settings = aws.sdk.kotlin.services.mediaconvert.model.Mp4Settings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MpdSettings] inside the given [block]
         */
        public fun mpdSettings(block: aws.sdk.kotlin.services.mediaconvert.model.MpdSettings.Builder.() -> kotlin.Unit) {
            this.mpdSettings = aws.sdk.kotlin.services.mediaconvert.model.MpdSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.MxfSettings] inside the given [block]
         */
        public fun mxfSettings(block: aws.sdk.kotlin.services.mediaconvert.model.MxfSettings.Builder.() -> kotlin.Unit) {
            this.mxfSettings = aws.sdk.kotlin.services.mediaconvert.model.MxfSettings.invoke(block)
        }
    }
}
