// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



public class CreateJobRequest private constructor(builder: Builder) {
    /**
     * Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
     */
    public val accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = builder.accelerationSettings
    /**
     * Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will appear on the billing report unsorted.
     */
    public val billingTagsSource: aws.sdk.kotlin.services.mediaconvert.model.BillingTagsSource? = builder.billingTagsSource
    /**
     * Optional. Idempotency token for CreateJob operation.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
     */
    public val hopDestinations: List<HopDestination>? = builder.hopDestinations
    /**
     * Optional. When you create a job, you can either specify a job template or specify the transcoding settings individually.
     */
    public val jobTemplate: kotlin.String? = builder.jobTemplate
    /**
     * Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
     */
    public val queue: kotlin.String? = builder.queue
    /**
     * Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     */
    public val role: kotlin.String? = builder.role
    /**
     * JobSettings contains all the transcode settings for a job.
     */
    public val settings: aws.sdk.kotlin.services.mediaconvert.model.JobSettings? = builder.settings
    /**
     * Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
     */
    public val simulateReservedQueue: aws.sdk.kotlin.services.mediaconvert.model.SimulateReservedQueue? = builder.simulateReservedQueue
    /**
     * Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
     */
    public val statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = builder.statusUpdateInterval
    /**
     * Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key. Use standard AWS tags on your job for automatic integration with AWS services and for custom integrations and workflows.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs. Use only for existing integrations or workflows that rely on job metadata tags. Otherwise, we recommend that you use standard AWS tags.
     */
    public val userMetadata: Map<String, String>? = builder.userMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("accelerationSettings=$accelerationSettings,")
        append("billingTagsSource=$billingTagsSource,")
        append("clientRequestToken=$clientRequestToken,")
        append("hopDestinations=$hopDestinations,")
        append("jobTemplate=$jobTemplate,")
        append("priority=$priority,")
        append("queue=$queue,")
        append("role=$role,")
        append("settings=$settings,")
        append("simulateReservedQueue=$simulateReservedQueue,")
        append("statusUpdateInterval=$statusUpdateInterval,")
        append("tags=$tags,")
        append("userMetadata=$userMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accelerationSettings?.hashCode() ?: 0
        result = 31 * result + (billingTagsSource?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (hopDestinations?.hashCode() ?: 0)
        result = 31 * result + (jobTemplate?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (queue?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (simulateReservedQueue?.hashCode() ?: 0)
        result = 31 * result + (statusUpdateInterval?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (accelerationSettings != other.accelerationSettings) return false
        if (billingTagsSource != other.billingTagsSource) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (hopDestinations != other.hopDestinations) return false
        if (jobTemplate != other.jobTemplate) return false
        if (priority != other.priority) return false
        if (queue != other.queue) return false
        if (role != other.role) return false
        if (settings != other.settings) return false
        if (simulateReservedQueue != other.simulateReservedQueue) return false
        if (statusUpdateInterval != other.statusUpdateInterval) return false
        if (tags != other.tags) return false
        if (userMetadata != other.userMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CreateJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
         */
        public var accelerationSettings: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings? = null
        /**
         * Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will appear on the billing report unsorted.
         */
        public var billingTagsSource: aws.sdk.kotlin.services.mediaconvert.model.BillingTagsSource? = null
        /**
         * Optional. Idempotency token for CreateJob operation.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
         */
        public var hopDestinations: List<HopDestination>? = null
        /**
         * Optional. When you create a job, you can either specify a job template or specify the transcoding settings individually.
         */
        public var jobTemplate: kotlin.String? = null
        /**
         * Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
         */
        public var priority: kotlin.Int = 0
        /**
         * Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
         */
        public var queue: kotlin.String? = null
        /**
         * Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
         */
        public var role: kotlin.String? = null
        /**
         * JobSettings contains all the transcode settings for a job.
         */
        public var settings: aws.sdk.kotlin.services.mediaconvert.model.JobSettings? = null
        /**
         * Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
         */
        public var simulateReservedQueue: aws.sdk.kotlin.services.mediaconvert.model.SimulateReservedQueue? = null
        /**
         * Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
         */
        public var statusUpdateInterval: aws.sdk.kotlin.services.mediaconvert.model.StatusUpdateInterval? = null
        /**
         * Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key. Use standard AWS tags on your job for automatic integration with AWS services and for custom integrations and workflows.
         */
        public var tags: Map<String, String>? = null
        /**
         * Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs. Use only for existing integrations or workflows that rely on job metadata tags. Otherwise, we recommend that you use standard AWS tags.
         */
        public var userMetadata: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CreateJobRequest) : this() {
            this.accelerationSettings = x.accelerationSettings
            this.billingTagsSource = x.billingTagsSource
            this.clientRequestToken = x.clientRequestToken
            this.hopDestinations = x.hopDestinations
            this.jobTemplate = x.jobTemplate
            this.priority = x.priority
            this.queue = x.queue
            this.role = x.role
            this.settings = x.settings
            this.simulateReservedQueue = x.simulateReservedQueue
            this.statusUpdateInterval = x.statusUpdateInterval
            this.tags = x.tags
            this.userMetadata = x.userMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings] inside the given [block]
         */
        public fun accelerationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.Builder.() -> kotlin.Unit) {
            this.accelerationSettings = aws.sdk.kotlin.services.mediaconvert.model.AccelerationSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.JobSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.mediaconvert.model.JobSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.mediaconvert.model.JobSettings.invoke(block)
        }
    }
}
