// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



public class CreateQueueRequest private constructor(builder: Builder) {
    /**
     * Optional. A description of the queue that you are creating.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the queue that you are creating.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use the API to create a queue, the default is on-demand.
     */
    public val pricingPlan: aws.sdk.kotlin.services.mediaconvert.model.PricingPlan? = builder.pricingPlan
    /**
     * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
     */
    public val reservationPlanSettings: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings? = builder.reservationPlanSettings
    /**
     * Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
     */
    public val status: aws.sdk.kotlin.services.mediaconvert.model.QueueStatus? = builder.status
    /**
     * The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.CreateQueueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateQueueRequest(")
        append("description=$description,")
        append("name=$name,")
        append("pricingPlan=$pricingPlan,")
        append("reservationPlanSettings=$reservationPlanSettings,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (reservationPlanSettings?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateQueueRequest

        if (description != other.description) return false
        if (name != other.name) return false
        if (pricingPlan != other.pricingPlan) return false
        if (reservationPlanSettings != other.reservationPlanSettings) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.CreateQueueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional. A description of the queue that you are creating.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the queue that you are creating.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use the API to create a queue, the default is on-demand.
         */
        public var pricingPlan: aws.sdk.kotlin.services.mediaconvert.model.PricingPlan? = null
        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
         */
        public var reservationPlanSettings: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings? = null
        /**
         * Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
         */
        public var status: aws.sdk.kotlin.services.mediaconvert.model.QueueStatus? = null
        /**
         * The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.CreateQueueRequest) : this() {
            this.description = x.description
            this.name = x.name
            this.pricingPlan = x.pricingPlan
            this.reservationPlanSettings = x.reservationPlanSettings
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.CreateQueueRequest = CreateQueueRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings] inside the given [block]
         */
        public fun reservationPlanSettings(block: aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings.Builder.() -> kotlin.Unit) {
            this.reservationPlanSettings = aws.sdk.kotlin.services.mediaconvert.model.ReservationPlanSettings.invoke(block)
        }
    }
}
