// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings related to your File output group. MediaConvert uses this group of settings to generate a single standalone file, rather than a streaming package. When you work directly in your JSON job specification, include this object and any required children when you set Type, under OutputGroupSettings, to FILE_GROUP_SETTINGS.
 */
public class FileGroupSettings private constructor(builder: Builder) {
    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * Settings associated with the destination. Will vary based on the type of destination
     */
    public val destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = builder.destinationSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.FileGroupSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileGroupSettings(")
        append("destination=$destination,")
        append("destinationSettings=$destinationSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (destinationSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileGroupSettings

        if (destination != other.destination) return false
        if (destinationSettings != other.destinationSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.FileGroupSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input file. If your job has multiple inputs, the service uses the filename of the first input file.
         */
        public var destination: kotlin.String? = null
        /**
         * Settings associated with the destination. Will vary based on the type of destination
         */
        public var destinationSettings: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.FileGroupSettings) : this() {
            this.destination = x.destination
            this.destinationSettings = x.destinationSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.FileGroupSettings = FileGroupSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings] inside the given [block]
         */
        public fun destinationSettings(block: aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.Builder.() -> kotlin.Unit) {
            this.destinationSettings = aws.sdk.kotlin.services.mediaconvert.model.DestinationSettings.invoke(block)
        }
    }
}
