// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the URI of the input caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.
 */
public class FileSourceSettings private constructor(builder: Builder) {
    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     */
    public val convert608To708: aws.sdk.kotlin.services.mediaconvert.model.FileSourceConvert608To708? = builder.convert608To708
    /**
     * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame rates between your input captions and input video, specify the frame rate of the captions file. Specify this value as a fraction. When you work directly in your JSON job specification, use the settings framerateNumerator and framerateDenominator. For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
     */
    public val framerate: aws.sdk.kotlin.services.mediaconvert.model.CaptionSourceFramerate? = builder.framerate
    /**
     * External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp', 'stl', 'srt', 'xml', 'smi', 'webvtt', and 'vtt'.
     */
    public val sourceFile: kotlin.String? = builder.sourceFile
    /**
     * Optional. Use this setting when you need to adjust the sync between your sidecar captions and your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/time-delta-use-cases.html. Enter a positive or negative number to modify the times in the captions file. For example, type 15 to add 15 seconds to all the times in the captions file. Type -5 to subtract 5 seconds from the times in the captions file. You can optionally specify your time delta in milliseconds instead of seconds. When you do so, set the related setting, Time delta units (TimeDeltaUnits) to Milliseconds (MILLISECONDS). Note that, when you specify a time delta for timecode-based caption sources, such as SCC and STL, and your time delta isn't a multiple of the input frame rate, MediaConvert snaps the captions to the nearest frame. For example, when your input video frame rate is 25 fps and you specify 1010ms for time delta, MediaConvert delays your captions by 1000 ms.
     */
    public val timeDelta: kotlin.Int = builder.timeDelta
    /**
     * When you use the setting Time delta (TimeDelta) to adjust the sync between your sidecar captions and your video, use this setting to specify the units for the delta that you specify. When you don't specify a value for Time delta units (TimeDeltaUnits), MediaConvert uses seconds by default.
     */
    public val timeDeltaUnits: aws.sdk.kotlin.services.mediaconvert.model.FileSourceTimeDeltaUnits? = builder.timeDeltaUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.FileSourceSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileSourceSettings(")
        append("convert608To708=$convert608To708,")
        append("framerate=$framerate,")
        append("sourceFile=$sourceFile,")
        append("timeDelta=$timeDelta,")
        append("timeDeltaUnits=$timeDeltaUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = convert608To708?.hashCode() ?: 0
        result = 31 * result + (framerate?.hashCode() ?: 0)
        result = 31 * result + (sourceFile?.hashCode() ?: 0)
        result = 31 * result + (timeDelta)
        result = 31 * result + (timeDeltaUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileSourceSettings

        if (convert608To708 != other.convert608To708) return false
        if (framerate != other.framerate) return false
        if (sourceFile != other.sourceFile) return false
        if (timeDelta != other.timeDelta) return false
        if (timeDeltaUnits != other.timeDeltaUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.FileSourceSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         */
        public var convert608To708: aws.sdk.kotlin.services.mediaconvert.model.FileSourceConvert608To708? = null
        /**
         * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame rates between your input captions and input video, specify the frame rate of the captions file. Specify this value as a fraction. When you work directly in your JSON job specification, use the settings framerateNumerator and framerateDenominator. For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
         */
        public var framerate: aws.sdk.kotlin.services.mediaconvert.model.CaptionSourceFramerate? = null
        /**
         * External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp', 'stl', 'srt', 'xml', 'smi', 'webvtt', and 'vtt'.
         */
        public var sourceFile: kotlin.String? = null
        /**
         * Optional. Use this setting when you need to adjust the sync between your sidecar captions and your video. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/time-delta-use-cases.html. Enter a positive or negative number to modify the times in the captions file. For example, type 15 to add 15 seconds to all the times in the captions file. Type -5 to subtract 5 seconds from the times in the captions file. You can optionally specify your time delta in milliseconds instead of seconds. When you do so, set the related setting, Time delta units (TimeDeltaUnits) to Milliseconds (MILLISECONDS). Note that, when you specify a time delta for timecode-based caption sources, such as SCC and STL, and your time delta isn't a multiple of the input frame rate, MediaConvert snaps the captions to the nearest frame. For example, when your input video frame rate is 25 fps and you specify 1010ms for time delta, MediaConvert delays your captions by 1000 ms.
         */
        public var timeDelta: kotlin.Int = 0
        /**
         * When you use the setting Time delta (TimeDelta) to adjust the sync between your sidecar captions and your video, use this setting to specify the units for the delta that you specify. When you don't specify a value for Time delta units (TimeDeltaUnits), MediaConvert uses seconds by default.
         */
        public var timeDeltaUnits: aws.sdk.kotlin.services.mediaconvert.model.FileSourceTimeDeltaUnits? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.FileSourceSettings) : this() {
            this.convert608To708 = x.convert608To708
            this.framerate = x.framerate
            this.sourceFile = x.sourceFile
            this.timeDelta = x.timeDelta
            this.timeDeltaUnits = x.timeDeltaUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.FileSourceSettings = FileSourceSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.CaptionSourceFramerate] inside the given [block]
         */
        public fun framerate(block: aws.sdk.kotlin.services.mediaconvert.model.CaptionSourceFramerate.Builder.() -> kotlin.Unit) {
            this.framerate = aws.sdk.kotlin.services.mediaconvert.model.CaptionSourceFramerate.invoke(block)
        }
    }
}
