// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
 */
public class H264Settings private constructor(builder: Builder) {
    /**
     * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
     */
    public val adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264AdaptiveQuantization? = builder.adaptiveQuantization
    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
     */
    public val bitrate: kotlin.Int = builder.bitrate
    /**
     * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to specify, choose Auto (AUTO).
     */
    public val codecLevel: aws.sdk.kotlin.services.mediaconvert.model.H264CodecLevel? = builder.codecLevel
    /**
     * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     */
    public val codecProfile: aws.sdk.kotlin.services.mediaconvert.model.H264CodecProfile? = builder.codecProfile
    /**
     * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
     */
    public val dynamicSubGop: aws.sdk.kotlin.services.mediaconvert.model.H264DynamicSubGop? = builder.dynamicSubGop
    /**
     * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     */
    public val entropyEncoding: aws.sdk.kotlin.services.mediaconvert.model.H264EntropyEncoding? = builder.entropyEncoding
    /**
     * The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
     */
    public val fieldEncoding: aws.sdk.kotlin.services.mediaconvert.model.H264FieldEncoding? = builder.fieldEncoding
    /**
     * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     */
    public val flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264FlickerAdaptiveQuantization? = builder.flickerAdaptiveQuantization
    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
     */
    public val framerateControl: aws.sdk.kotlin.services.mediaconvert.model.H264FramerateControl? = builder.framerateControl
    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
     */
    public val framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.H264FramerateConversionAlgorithm? = builder.framerateConversionAlgorithm
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    public val framerateDenominator: kotlin.Int = builder.framerateDenominator
    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     */
    public val framerateNumerator: kotlin.Int = builder.framerateNumerator
    /**
     * If enable, use reference B frames for GOP structures that have B frames > 1.
     */
    public val gopBReference: aws.sdk.kotlin.services.mediaconvert.model.H264GopBReference? = builder.gopBReference
    /**
     * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open GOPs and then require a closed GOP, set this value to 5. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. If you do explicitly specify a value, for segmented outputs, don't set this value to 0.
     */
    public val gopClosedCadence: kotlin.Int = builder.gopClosedCadence
    /**
     * Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of seconds. MediaConvert will interpret this value as frames or seconds depending on the value you choose for GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP size, leave GOP size blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS, DASH, or CMAF, leave GOP size blank and set GOP mode control to Auto in each output in your output group.
     */
    public val gopSize: kotlin.Double = builder.gopSize
    /**
     * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
     */
    public val gopSizeUnits: aws.sdk.kotlin.services.mediaconvert.model.H264GopSizeUnits? = builder.gopSizeUnits
    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public val hrdBufferInitialFillPercentage: kotlin.Int = builder.hrdBufferInitialFillPercentage
    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    public val hrdBufferSize: kotlin.Int = builder.hrdBufferSize
    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
     */
    public val interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.H264InterlaceMode? = builder.interlaceMode
    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
     */
    public val maxBitrate: kotlin.Int = builder.maxBitrate
    /**
     * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. When you explicitly specify a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
     */
    public val minIInterval: kotlin.Int = builder.minIInterval
    /**
     * This setting to determines the number of B-frames that MediaConvert puts between reference frames in this output. We recommend that you use automatic behavior to allow the transcoder to choose the best value based on characteristics of your input video. In the console, choose AUTO to select this automatic behavior. When you manually edit your JSON job specification, leave this setting out to choose automatic behavior. When you want to specify this number explicitly, choose a whole number from 0 through 7.
     */
    public val numberBFramesBetweenReferenceFrames: kotlin.Int = builder.numberBFramesBetweenReferenceFrames
    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
     */
    public val numberReferenceFrames: kotlin.Int = builder.numberReferenceFrames
    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
     */
    public val parControl: aws.sdk.kotlin.services.mediaconvert.model.H264ParControl? = builder.parControl
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    public val parDenominator: kotlin.Int = builder.parDenominator
    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    public val parNumerator: kotlin.Int = builder.parNumerator
    /**
     * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
     */
    public val qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.H264QualityTuningLevel? = builder.qualityTuningLevel
    /**
     * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
     */
    public val qvbrSettings: aws.sdk.kotlin.services.mediaconvert.model.H264QvbrSettings? = builder.qvbrSettings
    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
     */
    public val rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.H264RateControlMode? = builder.rateControlMode
    /**
     * Places a PPS header on each encoded picture, even if repeated.
     */
    public val repeatPps: aws.sdk.kotlin.services.mediaconvert.model.H264RepeatPps? = builder.repeatPps
    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     */
    public val scanTypeConversionMode: aws.sdk.kotlin.services.mediaconvert.model.H264ScanTypeConversionMode? = builder.scanTypeConversionMode
    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     */
    public val sceneChangeDetect: aws.sdk.kotlin.services.mediaconvert.model.H264SceneChangeDetect? = builder.sceneChangeDetect
    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    public val slices: kotlin.Int = builder.slices
    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     */
    public val slowPal: aws.sdk.kotlin.services.mediaconvert.model.H264SlowPal? = builder.slowPal
    /**
     * Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
     */
    public val softness: kotlin.Int = builder.softness
    /**
     * Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     */
    public val spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264SpatialAdaptiveQuantization? = builder.spatialAdaptiveQuantization
    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     */
    public val syntax: aws.sdk.kotlin.services.mediaconvert.model.H264Syntax? = builder.syntax
    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
     */
    public val telecine: aws.sdk.kotlin.services.mediaconvert.model.H264Telecine? = builder.telecine
    /**
     * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     */
    public val temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264TemporalAdaptiveQuantization? = builder.temporalAdaptiveQuantization
    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     */
    public val unregisteredSeiTimecode: aws.sdk.kotlin.services.mediaconvert.model.H264UnregisteredSeiTimecode? = builder.unregisteredSeiTimecode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.H264Settings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("H264Settings(")
        append("adaptiveQuantization=$adaptiveQuantization,")
        append("bitrate=$bitrate,")
        append("codecLevel=$codecLevel,")
        append("codecProfile=$codecProfile,")
        append("dynamicSubGop=$dynamicSubGop,")
        append("entropyEncoding=$entropyEncoding,")
        append("fieldEncoding=$fieldEncoding,")
        append("flickerAdaptiveQuantization=$flickerAdaptiveQuantization,")
        append("framerateControl=$framerateControl,")
        append("framerateConversionAlgorithm=$framerateConversionAlgorithm,")
        append("framerateDenominator=$framerateDenominator,")
        append("framerateNumerator=$framerateNumerator,")
        append("gopBReference=$gopBReference,")
        append("gopClosedCadence=$gopClosedCadence,")
        append("gopSize=$gopSize,")
        append("gopSizeUnits=$gopSizeUnits,")
        append("hrdBufferInitialFillPercentage=$hrdBufferInitialFillPercentage,")
        append("hrdBufferSize=$hrdBufferSize,")
        append("interlaceMode=$interlaceMode,")
        append("maxBitrate=$maxBitrate,")
        append("minIInterval=$minIInterval,")
        append("numberBFramesBetweenReferenceFrames=$numberBFramesBetweenReferenceFrames,")
        append("numberReferenceFrames=$numberReferenceFrames,")
        append("parControl=$parControl,")
        append("parDenominator=$parDenominator,")
        append("parNumerator=$parNumerator,")
        append("qualityTuningLevel=$qualityTuningLevel,")
        append("qvbrSettings=$qvbrSettings,")
        append("rateControlMode=$rateControlMode,")
        append("repeatPps=$repeatPps,")
        append("scanTypeConversionMode=$scanTypeConversionMode,")
        append("sceneChangeDetect=$sceneChangeDetect,")
        append("slices=$slices,")
        append("slowPal=$slowPal,")
        append("softness=$softness,")
        append("spatialAdaptiveQuantization=$spatialAdaptiveQuantization,")
        append("syntax=$syntax,")
        append("telecine=$telecine,")
        append("temporalAdaptiveQuantization=$temporalAdaptiveQuantization,")
        append("unregisteredSeiTimecode=$unregisteredSeiTimecode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adaptiveQuantization?.hashCode() ?: 0
        result = 31 * result + (bitrate)
        result = 31 * result + (codecLevel?.hashCode() ?: 0)
        result = 31 * result + (codecProfile?.hashCode() ?: 0)
        result = 31 * result + (dynamicSubGop?.hashCode() ?: 0)
        result = 31 * result + (entropyEncoding?.hashCode() ?: 0)
        result = 31 * result + (fieldEncoding?.hashCode() ?: 0)
        result = 31 * result + (flickerAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (framerateControl?.hashCode() ?: 0)
        result = 31 * result + (framerateConversionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (framerateDenominator)
        result = 31 * result + (framerateNumerator)
        result = 31 * result + (gopBReference?.hashCode() ?: 0)
        result = 31 * result + (gopClosedCadence)
        result = 31 * result + (gopSize.hashCode())
        result = 31 * result + (gopSizeUnits?.hashCode() ?: 0)
        result = 31 * result + (hrdBufferInitialFillPercentage)
        result = 31 * result + (hrdBufferSize)
        result = 31 * result + (interlaceMode?.hashCode() ?: 0)
        result = 31 * result + (maxBitrate)
        result = 31 * result + (minIInterval)
        result = 31 * result + (numberBFramesBetweenReferenceFrames)
        result = 31 * result + (numberReferenceFrames)
        result = 31 * result + (parControl?.hashCode() ?: 0)
        result = 31 * result + (parDenominator)
        result = 31 * result + (parNumerator)
        result = 31 * result + (qualityTuningLevel?.hashCode() ?: 0)
        result = 31 * result + (qvbrSettings?.hashCode() ?: 0)
        result = 31 * result + (rateControlMode?.hashCode() ?: 0)
        result = 31 * result + (repeatPps?.hashCode() ?: 0)
        result = 31 * result + (scanTypeConversionMode?.hashCode() ?: 0)
        result = 31 * result + (sceneChangeDetect?.hashCode() ?: 0)
        result = 31 * result + (slices)
        result = 31 * result + (slowPal?.hashCode() ?: 0)
        result = 31 * result + (softness)
        result = 31 * result + (spatialAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (syntax?.hashCode() ?: 0)
        result = 31 * result + (telecine?.hashCode() ?: 0)
        result = 31 * result + (temporalAdaptiveQuantization?.hashCode() ?: 0)
        result = 31 * result + (unregisteredSeiTimecode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as H264Settings

        if (adaptiveQuantization != other.adaptiveQuantization) return false
        if (bitrate != other.bitrate) return false
        if (codecLevel != other.codecLevel) return false
        if (codecProfile != other.codecProfile) return false
        if (dynamicSubGop != other.dynamicSubGop) return false
        if (entropyEncoding != other.entropyEncoding) return false
        if (fieldEncoding != other.fieldEncoding) return false
        if (flickerAdaptiveQuantization != other.flickerAdaptiveQuantization) return false
        if (framerateControl != other.framerateControl) return false
        if (framerateConversionAlgorithm != other.framerateConversionAlgorithm) return false
        if (framerateDenominator != other.framerateDenominator) return false
        if (framerateNumerator != other.framerateNumerator) return false
        if (gopBReference != other.gopBReference) return false
        if (gopClosedCadence != other.gopClosedCadence) return false
        if (gopSize != other.gopSize) return false
        if (gopSizeUnits != other.gopSizeUnits) return false
        if (hrdBufferInitialFillPercentage != other.hrdBufferInitialFillPercentage) return false
        if (hrdBufferSize != other.hrdBufferSize) return false
        if (interlaceMode != other.interlaceMode) return false
        if (maxBitrate != other.maxBitrate) return false
        if (minIInterval != other.minIInterval) return false
        if (numberBFramesBetweenReferenceFrames != other.numberBFramesBetweenReferenceFrames) return false
        if (numberReferenceFrames != other.numberReferenceFrames) return false
        if (parControl != other.parControl) return false
        if (parDenominator != other.parDenominator) return false
        if (parNumerator != other.parNumerator) return false
        if (qualityTuningLevel != other.qualityTuningLevel) return false
        if (qvbrSettings != other.qvbrSettings) return false
        if (rateControlMode != other.rateControlMode) return false
        if (repeatPps != other.repeatPps) return false
        if (scanTypeConversionMode != other.scanTypeConversionMode) return false
        if (sceneChangeDetect != other.sceneChangeDetect) return false
        if (slices != other.slices) return false
        if (slowPal != other.slowPal) return false
        if (softness != other.softness) return false
        if (spatialAdaptiveQuantization != other.spatialAdaptiveQuantization) return false
        if (syntax != other.syntax) return false
        if (telecine != other.telecine) return false
        if (temporalAdaptiveQuantization != other.temporalAdaptiveQuantization) return false
        if (unregisteredSeiTimecode != other.unregisteredSeiTimecode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.H264Settings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
         */
        public var adaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264AdaptiveQuantization? = null
        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
         */
        public var bitrate: kotlin.Int = 0
        /**
         * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to specify, choose Auto (AUTO).
         */
        public var codecLevel: aws.sdk.kotlin.services.mediaconvert.model.H264CodecLevel? = null
        /**
         * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         */
        public var codecProfile: aws.sdk.kotlin.services.mediaconvert.model.H264CodecProfile? = null
        /**
         * Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
         */
        public var dynamicSubGop: aws.sdk.kotlin.services.mediaconvert.model.H264DynamicSubGop? = null
        /**
         * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         */
        public var entropyEncoding: aws.sdk.kotlin.services.mediaconvert.model.H264EntropyEncoding? = null
        /**
         * The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
         */
        public var fieldEncoding: aws.sdk.kotlin.services.mediaconvert.model.H264FieldEncoding? = null
        /**
         * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
         */
        public var flickerAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264FlickerAdaptiveQuantization? = null
        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         */
        public var framerateControl: aws.sdk.kotlin.services.mediaconvert.model.H264FramerateControl? = null
        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
         */
        public var framerateConversionAlgorithm: aws.sdk.kotlin.services.mediaconvert.model.H264FramerateConversionAlgorithm? = null
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        public var framerateDenominator: kotlin.Int = 0
        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
         */
        public var framerateNumerator: kotlin.Int = 0
        /**
         * If enable, use reference B frames for GOP structures that have B frames > 1.
         */
        public var gopBReference: aws.sdk.kotlin.services.mediaconvert.model.H264GopBReference? = null
        /**
         * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open GOPs and then require a closed GOP, set this value to 5. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. If you do explicitly specify a value, for segmented outputs, don't set this value to 0.
         */
        public var gopClosedCadence: kotlin.Int = 0
        /**
         * Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of seconds. MediaConvert will interpret this value as frames or seconds depending on the value you choose for GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP size, leave GOP size blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS, DASH, or CMAF, leave GOP size blank and set GOP mode control to Auto in each output in your output group.
         */
        public var gopSize: kotlin.Double = 0.0
        /**
         * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
         */
        public var gopSizeUnits: aws.sdk.kotlin.services.mediaconvert.model.H264GopSizeUnits? = null
        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         */
        public var hrdBufferInitialFillPercentage: kotlin.Int = 0
        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         */
        public var hrdBufferSize: kotlin.Int = 0
        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
         */
        public var interlaceMode: aws.sdk.kotlin.services.mediaconvert.model.H264InterlaceMode? = null
        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
         */
        public var maxBitrate: kotlin.Int = 0
        /**
         * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the transcoder automatically choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping the default empty value. When you explicitly specify a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
         */
        public var minIInterval: kotlin.Int = 0
        /**
         * This setting to determines the number of B-frames that MediaConvert puts between reference frames in this output. We recommend that you use automatic behavior to allow the transcoder to choose the best value based on characteristics of your input video. In the console, choose AUTO to select this automatic behavior. When you manually edit your JSON job specification, leave this setting out to choose automatic behavior. When you want to specify this number explicitly, choose a whole number from 0 through 7.
         */
        public var numberBFramesBetweenReferenceFrames: kotlin.Int = 0
        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
         */
        public var numberReferenceFrames: kotlin.Int = 0
        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
         */
        public var parControl: aws.sdk.kotlin.services.mediaconvert.model.H264ParControl? = null
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         */
        public var parDenominator: kotlin.Int = 0
        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         */
        public var parNumerator: kotlin.Int = 0
        /**
         * Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
         */
        public var qualityTuningLevel: aws.sdk.kotlin.services.mediaconvert.model.H264QualityTuningLevel? = null
        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
         */
        public var qvbrSettings: aws.sdk.kotlin.services.mediaconvert.model.H264QvbrSettings? = null
        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
         */
        public var rateControlMode: aws.sdk.kotlin.services.mediaconvert.model.H264RateControlMode? = null
        /**
         * Places a PPS header on each encoded picture, even if repeated.
         */
        public var repeatPps: aws.sdk.kotlin.services.mediaconvert.model.H264RepeatPps? = null
        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         */
        public var scanTypeConversionMode: aws.sdk.kotlin.services.mediaconvert.model.H264ScanTypeConversionMode? = null
        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         */
        public var sceneChangeDetect: aws.sdk.kotlin.services.mediaconvert.model.H264SceneChangeDetect? = null
        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         */
        public var slices: kotlin.Int = 0
        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
         */
        public var slowPal: aws.sdk.kotlin.services.mediaconvert.model.H264SlowPal? = null
        /**
         * Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
         */
        public var softness: kotlin.Int = 0
        /**
         * Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
         */
        public var spatialAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264SpatialAdaptiveQuantization? = null
        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         */
        public var syntax: aws.sdk.kotlin.services.mediaconvert.model.H264Syntax? = null
        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
         */
        public var telecine: aws.sdk.kotlin.services.mediaconvert.model.H264Telecine? = null
        /**
         * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
         */
        public var temporalAdaptiveQuantization: aws.sdk.kotlin.services.mediaconvert.model.H264TemporalAdaptiveQuantization? = null
        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         */
        public var unregisteredSeiTimecode: aws.sdk.kotlin.services.mediaconvert.model.H264UnregisteredSeiTimecode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.H264Settings) : this() {
            this.adaptiveQuantization = x.adaptiveQuantization
            this.bitrate = x.bitrate
            this.codecLevel = x.codecLevel
            this.codecProfile = x.codecProfile
            this.dynamicSubGop = x.dynamicSubGop
            this.entropyEncoding = x.entropyEncoding
            this.fieldEncoding = x.fieldEncoding
            this.flickerAdaptiveQuantization = x.flickerAdaptiveQuantization
            this.framerateControl = x.framerateControl
            this.framerateConversionAlgorithm = x.framerateConversionAlgorithm
            this.framerateDenominator = x.framerateDenominator
            this.framerateNumerator = x.framerateNumerator
            this.gopBReference = x.gopBReference
            this.gopClosedCadence = x.gopClosedCadence
            this.gopSize = x.gopSize
            this.gopSizeUnits = x.gopSizeUnits
            this.hrdBufferInitialFillPercentage = x.hrdBufferInitialFillPercentage
            this.hrdBufferSize = x.hrdBufferSize
            this.interlaceMode = x.interlaceMode
            this.maxBitrate = x.maxBitrate
            this.minIInterval = x.minIInterval
            this.numberBFramesBetweenReferenceFrames = x.numberBFramesBetweenReferenceFrames
            this.numberReferenceFrames = x.numberReferenceFrames
            this.parControl = x.parControl
            this.parDenominator = x.parDenominator
            this.parNumerator = x.parNumerator
            this.qualityTuningLevel = x.qualityTuningLevel
            this.qvbrSettings = x.qvbrSettings
            this.rateControlMode = x.rateControlMode
            this.repeatPps = x.repeatPps
            this.scanTypeConversionMode = x.scanTypeConversionMode
            this.sceneChangeDetect = x.sceneChangeDetect
            this.slices = x.slices
            this.slowPal = x.slowPal
            this.softness = x.softness
            this.spatialAdaptiveQuantization = x.spatialAdaptiveQuantization
            this.syntax = x.syntax
            this.telecine = x.telecine
            this.temporalAdaptiveQuantization = x.temporalAdaptiveQuantization
            this.unregisteredSeiTimecode = x.unregisteredSeiTimecode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.H264Settings = H264Settings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.H264QvbrSettings] inside the given [block]
         */
        public fun qvbrSettings(block: aws.sdk.kotlin.services.mediaconvert.model.H264QvbrSettings.Builder.() -> kotlin.Unit) {
            this.qvbrSettings = aws.sdk.kotlin.services.mediaconvert.model.H264QvbrSettings.invoke(block)
        }
    }
}
