// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for HLS encryption
 */
public class HlsEncryptionSettings private constructor(builder: Builder) {
    /**
     * This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then the Initialization Vector will follow the segment number by default.
     */
    public val constantInitializationVector: kotlin.String? = builder.constantInitializationVector
    /**
     * Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in the web interface also disables encryption.
     */
    public val encryptionMethod: aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionType? = builder.encryptionMethod
    /**
     * The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the manifest.
     */
    public val initializationVectorInManifest: aws.sdk.kotlin.services.mediaconvert.model.HlsInitializationVectorInManifest? = builder.initializationVectorInManifest
    /**
     * Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline Apple HLS FairPlay content protection.
     */
    public val offlineEncrypted: aws.sdk.kotlin.services.mediaconvert.model.HlsOfflineEncrypted? = builder.offlineEncrypted
    /**
     * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
     */
    public val spekeKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider? = builder.spekeKeyProvider
    /**
     * Use these settings to set up encryption with a static key provider.
     */
    public val staticKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider? = builder.staticKeyProvider
    /**
     * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
     */
    public val type: aws.sdk.kotlin.services.mediaconvert.model.HlsKeyProviderType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsEncryptionSettings(")
        append("constantInitializationVector=$constantInitializationVector,")
        append("encryptionMethod=$encryptionMethod,")
        append("initializationVectorInManifest=$initializationVectorInManifest,")
        append("offlineEncrypted=$offlineEncrypted,")
        append("spekeKeyProvider=$spekeKeyProvider,")
        append("staticKeyProvider=$staticKeyProvider,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constantInitializationVector?.hashCode() ?: 0
        result = 31 * result + (encryptionMethod?.hashCode() ?: 0)
        result = 31 * result + (initializationVectorInManifest?.hashCode() ?: 0)
        result = 31 * result + (offlineEncrypted?.hashCode() ?: 0)
        result = 31 * result + (spekeKeyProvider?.hashCode() ?: 0)
        result = 31 * result + (staticKeyProvider?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsEncryptionSettings

        if (constantInitializationVector != other.constantInitializationVector) return false
        if (encryptionMethod != other.encryptionMethod) return false
        if (initializationVectorInManifest != other.initializationVectorInManifest) return false
        if (offlineEncrypted != other.offlineEncrypted) return false
        if (spekeKeyProvider != other.spekeKeyProvider) return false
        if (staticKeyProvider != other.staticKeyProvider) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is a 128-bit, 16-byte hex value represented by a 32-character text string. If this parameter is not set then the Initialization Vector will follow the segment number by default.
         */
        public var constantInitializationVector: kotlin.String? = null
        /**
         * Encrypts the segments with the given encryption scheme. Leave blank to disable. Selecting 'Disabled' in the web interface also disables encryption.
         */
        public var encryptionMethod: aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionType? = null
        /**
         * The Initialization Vector is a 128-bit number used in conjunction with the key for encrypting blocks. If set to INCLUDE, Initialization Vector is listed in the manifest. Otherwise Initialization Vector is not in the manifest.
         */
        public var initializationVectorInManifest: aws.sdk.kotlin.services.mediaconvert.model.HlsInitializationVectorInManifest? = null
        /**
         * Enable this setting to insert the EXT-X-SESSION-KEY element into the master playlist. This allows for offline Apple HLS FairPlay content protection.
         */
        public var offlineEncrypted: aws.sdk.kotlin.services.mediaconvert.model.HlsOfflineEncrypted? = null
        /**
         * If your output group type is HLS, DASH, or Microsoft Smooth, use these settings when doing DRM encryption with a SPEKE-compliant key provider. If your output group type is CMAF, use the SpekeKeyProviderCmaf settings instead.
         */
        public var spekeKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider? = null
        /**
         * Use these settings to set up encryption with a static key provider.
         */
        public var staticKeyProvider: aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider? = null
        /**
         * Specify whether your DRM encryption key is static or from a key provider that follows the SPEKE standard. For more information about SPEKE, see https://docs.aws.amazon.com/speke/latest/documentation/what-is-speke.html.
         */
        public var type: aws.sdk.kotlin.services.mediaconvert.model.HlsKeyProviderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings) : this() {
            this.constantInitializationVector = x.constantInitializationVector
            this.encryptionMethod = x.encryptionMethod
            this.initializationVectorInManifest = x.initializationVectorInManifest
            this.offlineEncrypted = x.offlineEncrypted
            this.spekeKeyProvider = x.spekeKeyProvider
            this.staticKeyProvider = x.staticKeyProvider
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.HlsEncryptionSettings = HlsEncryptionSettings(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider] inside the given [block]
         */
        public fun spekeKeyProvider(block: aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider.Builder.() -> kotlin.Unit) {
            this.spekeKeyProvider = aws.sdk.kotlin.services.mediaconvert.model.SpekeKeyProvider.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider] inside the given [block]
         */
        public fun staticKeyProvider(block: aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider.Builder.() -> kotlin.Unit) {
            this.staticKeyProvider = aws.sdk.kotlin.services.mediaconvert.model.StaticKeyProvider.invoke(block)
        }
    }
}
