// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Use inputs to define the source files used in your transcoding job. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/specify-input-settings.html. You can use multiple video inputs to do input stitching. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/assembling-multiple-inputs-and-input-clips.html
 */
public class Input private constructor(builder: Builder) {
    /**
     * Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single output audio tab (AudioDescription). Note that, if you're working with embedded audio, it's simpler to assign multiple input tracks into a single audio selector rather than use an audio selector group.
     */
    public val audioSelectorGroups: Map<String, AudioSelectorGroup>? = builder.audioSelectorGroups
    /**
     * Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your outputs. You can use multiple Audio selectors per input.
     */
    public val audioSelectors: Map<String, AudioSelector>? = builder.audioSelectors
    /**
     * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up to 20 captions selectors per input.
     */
    public val captionSelectors: Map<String, CaptionSelector>? = builder.captionSelectors
    /**
     * Use Cropping selection (crop) to specify the video area that the service will include in the output video frame. If you specify a value here, it will override any value that you specify in the output setting Cropping selection (crop).
     */
    public val crop: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = builder.crop
    /**
     * Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually controllable for MPEG2 and uncompressed video inputs.
     */
    public val deblockFilter: aws.sdk.kotlin.services.mediaconvert.model.InputDeblockFilter? = builder.deblockFilter
    /**
     * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt your content.
     */
    public val decryptionSettings: aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings? = builder.decryptionSettings
    /**
     * Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and uncompressed video inputs.
     */
    public val denoiseFilter: aws.sdk.kotlin.services.mediaconvert.model.InputDenoiseFilter? = builder.denoiseFilter
    /**
     * Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in a separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file to provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here and your input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved metadata and uses only the the metadata from this external XML file. Note that your IAM service role must grant MediaConvert read permissions to this file. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
     */
    public val dolbyVisionMetadataXml: kotlin.String? = builder.dolbyVisionMetadataXml
    /**
     * Specify the source file for your transcoding job. You can use multiple inputs in a single job. The service concatenates these inputs, in the order that you specify them in the job, to create the outputs. If your input format is IMF, specify your input by providing the path to your CPL. For example, "s3://bucket/vf/cpl.xml". If the CPL is in an incomplete IMP, make sure to use *Supplemental IMPs* (SupplementalImps) to specify any supplemental IMPs that contain assets referenced by the CPL.
     */
    public val fileInput: kotlin.String? = builder.fileInput
    /**
     * Specify how the transcoding service applies the denoise and deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The input is filtered regardless of input type.
     */
    public val filterEnable: aws.sdk.kotlin.services.mediaconvert.model.InputFilterEnable? = builder.filterEnable
    /**
     * Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and Denoise). The range is -5 to 5. Default is 0.
     */
    public val filterStrength: kotlin.Int = builder.filterStrength
    /**
     * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each input individually. This setting is disabled by default.
     */
    public val imageInserter: aws.sdk.kotlin.services.mediaconvert.model.ImageInserter? = builder.imageInserter
    /**
     * (InputClippings) contains sets of start and end times that together specify a portion of the input to be used in the outputs. If you provide only a start time, the clip will be the entire input from that point to the end. If you provide only an end time, it will be the entire input up to that point. When you specify more than one input clip, the transcoding service creates the job outputs by stringing the clips together in the order you specify them.
     */
    public val inputClippings: List<InputClipping>? = builder.inputClippings
    /**
     * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto (AUTO). Auto is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced. Doing so creates horizontal interlacing artifacts.
     */
    public val inputScanType: aws.sdk.kotlin.services.mediaconvert.model.InputScanType? = builder.inputScanType
    /**
     * Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black. If you specify a value here, it will override any value that you specify in the output setting Selection placement (position). If you specify a value here, this will override any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you specify a value here, this will ignore anything that you specify for the setting Scaling Behavior (scalingBehavior).
     */
    public val position: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = builder.position
    /**
     * Use Program (programNumber) to select a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported. Default is the first program within the transport stream. If the program you specify doesn't exist, the transcoding service will use this default.
     */
    public val programNumber: kotlin.Int = builder.programNumber
    /**
     * Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
     */
    public val psiControl: aws.sdk.kotlin.services.mediaconvert.model.InputPsiControl? = builder.psiControl
    /**
     * Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're using for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a trailing slash or the ASSETMAP.xml files. For example &#91;"s3://bucket/ov/", "s3://bucket/vf2/ASSETMAP.xml"&#93;. You don't need to specify the IMP that contains your input CPL, because the service automatically detects it.
     */
    public val supplementalImps: List<String>? = builder.supplementalImps
    /**
     * Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the service counts input video frames. This input frame count affects only the behavior of features that apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you don't specify a value for Timecode source, the service will use Embedded by default. For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */
    public val timecodeSource: aws.sdk.kotlin.services.mediaconvert.model.InputTimecodeSource? = builder.timecodeSource
    /**
     * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you must set the Timecode source setting, located under the input settings (InputTimecodeSource), to Specified start (SPECIFIEDSTART). For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
     */
    public val timecodeStart: kotlin.String? = builder.timecodeStart
    /**
     * When you include Video generator, MediaConvert creates a video input with black frames. Use this setting if you do not have a video input or if you want to add black video frames before, or after, other inputs. You can specify Video generator, or you can specify an Input file, but you cannot specify both. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/video-generator.html
     */
    public val videoGenerator: aws.sdk.kotlin.services.mediaconvert.model.InputVideoGenerator? = builder.videoGenerator
    /**
     * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video selector.
     */
    public val videoSelector: aws.sdk.kotlin.services.mediaconvert.model.VideoSelector? = builder.videoSelector

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.Input = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Input(")
        append("audioSelectorGroups=$audioSelectorGroups,")
        append("audioSelectors=$audioSelectors,")
        append("captionSelectors=$captionSelectors,")
        append("crop=$crop,")
        append("deblockFilter=$deblockFilter,")
        append("decryptionSettings=$decryptionSettings,")
        append("denoiseFilter=$denoiseFilter,")
        append("dolbyVisionMetadataXml=$dolbyVisionMetadataXml,")
        append("fileInput=$fileInput,")
        append("filterEnable=$filterEnable,")
        append("filterStrength=$filterStrength,")
        append("imageInserter=$imageInserter,")
        append("inputClippings=$inputClippings,")
        append("inputScanType=$inputScanType,")
        append("position=$position,")
        append("programNumber=$programNumber,")
        append("psiControl=$psiControl,")
        append("supplementalImps=$supplementalImps,")
        append("timecodeSource=$timecodeSource,")
        append("timecodeStart=$timecodeStart,")
        append("videoGenerator=$videoGenerator,")
        append("videoSelector=$videoSelector)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioSelectorGroups?.hashCode() ?: 0
        result = 31 * result + (audioSelectors?.hashCode() ?: 0)
        result = 31 * result + (captionSelectors?.hashCode() ?: 0)
        result = 31 * result + (crop?.hashCode() ?: 0)
        result = 31 * result + (deblockFilter?.hashCode() ?: 0)
        result = 31 * result + (decryptionSettings?.hashCode() ?: 0)
        result = 31 * result + (denoiseFilter?.hashCode() ?: 0)
        result = 31 * result + (dolbyVisionMetadataXml?.hashCode() ?: 0)
        result = 31 * result + (fileInput?.hashCode() ?: 0)
        result = 31 * result + (filterEnable?.hashCode() ?: 0)
        result = 31 * result + (filterStrength)
        result = 31 * result + (imageInserter?.hashCode() ?: 0)
        result = 31 * result + (inputClippings?.hashCode() ?: 0)
        result = 31 * result + (inputScanType?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (programNumber)
        result = 31 * result + (psiControl?.hashCode() ?: 0)
        result = 31 * result + (supplementalImps?.hashCode() ?: 0)
        result = 31 * result + (timecodeSource?.hashCode() ?: 0)
        result = 31 * result + (timecodeStart?.hashCode() ?: 0)
        result = 31 * result + (videoGenerator?.hashCode() ?: 0)
        result = 31 * result + (videoSelector?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Input

        if (audioSelectorGroups != other.audioSelectorGroups) return false
        if (audioSelectors != other.audioSelectors) return false
        if (captionSelectors != other.captionSelectors) return false
        if (crop != other.crop) return false
        if (deblockFilter != other.deblockFilter) return false
        if (decryptionSettings != other.decryptionSettings) return false
        if (denoiseFilter != other.denoiseFilter) return false
        if (dolbyVisionMetadataXml != other.dolbyVisionMetadataXml) return false
        if (fileInput != other.fileInput) return false
        if (filterEnable != other.filterEnable) return false
        if (filterStrength != other.filterStrength) return false
        if (imageInserter != other.imageInserter) return false
        if (inputClippings != other.inputClippings) return false
        if (inputScanType != other.inputScanType) return false
        if (position != other.position) return false
        if (programNumber != other.programNumber) return false
        if (psiControl != other.psiControl) return false
        if (supplementalImps != other.supplementalImps) return false
        if (timecodeSource != other.timecodeSource) return false
        if (timecodeStart != other.timecodeStart) return false
        if (videoGenerator != other.videoGenerator) return false
        if (videoSelector != other.videoSelector) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.Input = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use audio selector groups to combine multiple sidecar audio inputs so that you can assign them to a single output audio tab (AudioDescription). Note that, if you're working with embedded audio, it's simpler to assign multiple input tracks into a single audio selector rather than use an audio selector group.
         */
        public var audioSelectorGroups: Map<String, AudioSelectorGroup>? = null
        /**
         * Use Audio selectors (AudioSelectors) to specify a track or set of tracks from the input that you will use in your outputs. You can use multiple Audio selectors per input.
         */
        public var audioSelectors: Map<String, AudioSelector>? = null
        /**
         * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up to 20 captions selectors per input.
         */
        public var captionSelectors: Map<String, CaptionSelector>? = null
        /**
         * Use Cropping selection (crop) to specify the video area that the service will include in the output video frame. If you specify a value here, it will override any value that you specify in the output setting Cropping selection (crop).
         */
        public var crop: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = null
        /**
         * Enable Deblock (InputDeblockFilter) to produce smoother motion in the output. Default is disabled. Only manually controllable for MPEG2 and uncompressed video inputs.
         */
        public var deblockFilter: aws.sdk.kotlin.services.mediaconvert.model.InputDeblockFilter? = null
        /**
         * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt your content.
         */
        public var decryptionSettings: aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings? = null
        /**
         * Enable Denoise (InputDenoiseFilter) to filter noise from the input. Default is disabled. Only applicable to MPEG2, H.264, H.265, and uncompressed video inputs.
         */
        public var denoiseFilter: aws.sdk.kotlin.services.mediaconvert.model.InputDenoiseFilter? = null
        /**
         * Use this setting only when your video source has Dolby Vision studio mastering metadata that is carried in a separate XML file. Specify the Amazon S3 location for the metadata XML file. MediaConvert uses this file to provide global and frame-level metadata for Dolby Vision preprocessing. When you specify a file here and your input also has interleaved global and frame level metadata, MediaConvert ignores the interleaved metadata and uses only the the metadata from this external XML file. Note that your IAM service role must grant MediaConvert read permissions to this file. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
         */
        public var dolbyVisionMetadataXml: kotlin.String? = null
        /**
         * Specify the source file for your transcoding job. You can use multiple inputs in a single job. The service concatenates these inputs, in the order that you specify them in the job, to create the outputs. If your input format is IMF, specify your input by providing the path to your CPL. For example, "s3://bucket/vf/cpl.xml". If the CPL is in an incomplete IMP, make sure to use *Supplemental IMPs* (SupplementalImps) to specify any supplemental IMPs that contain assets referenced by the CPL.
         */
        public var fileInput: kotlin.String? = null
        /**
         * Specify how the transcoding service applies the denoise and deblock filters. You must also enable the filters separately, with Denoise (InputDenoiseFilter) and Deblock (InputDeblockFilter). * Auto - The transcoding service determines whether to apply filtering, depending on input type and quality. * Disable - The input is not filtered. This is true even if you use the API to enable them in (InputDeblockFilter) and (InputDeblockFilter). * Force - The input is filtered regardless of input type.
         */
        public var filterEnable: aws.sdk.kotlin.services.mediaconvert.model.InputFilterEnable? = null
        /**
         * Use Filter strength (FilterStrength) to adjust the magnitude the input filter settings (Deblock and Denoise). The range is -5 to 5. Default is 0.
         */
        public var filterStrength: kotlin.Int = 0
        /**
         * Enable the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each input individually. This setting is disabled by default.
         */
        public var imageInserter: aws.sdk.kotlin.services.mediaconvert.model.ImageInserter? = null
        /**
         * (InputClippings) contains sets of start and end times that together specify a portion of the input to be used in the outputs. If you provide only a start time, the clip will be the entire input from that point to the end. If you provide only an end time, it will be the entire input up to that point. When you specify more than one input clip, the transcoding service creates the job outputs by stringing the clips together in the order you specify them.
         */
        public var inputClippings: List<InputClipping>? = null
        /**
         * When you have a progressive segmented frame (PsF) input, use this setting to flag the input as PsF. MediaConvert doesn't automatically detect PsF. Therefore, flagging your input as PsF results in better preservation of video quality when you do deinterlacing and frame rate conversion. If you don't specify, the default value is Auto (AUTO). Auto is the correct setting for all inputs that are not PsF. Don't set this value to PsF when your input is interlaced. Doing so creates horizontal interlacing artifacts.
         */
        public var inputScanType: aws.sdk.kotlin.services.mediaconvert.model.InputScanType? = null
        /**
         * Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black. If you specify a value here, it will override any value that you specify in the output setting Selection placement (position). If you specify a value here, this will override any AFD values in your input, even if you set Respond to AFD (RespondToAfd) to Respond (RESPOND). If you specify a value here, this will ignore anything that you specify for the setting Scaling Behavior (scalingBehavior).
         */
        public var position: aws.sdk.kotlin.services.mediaconvert.model.Rectangle? = null
        /**
         * Use Program (programNumber) to select a specific program from within a multi-program transport stream. Note that Quad 4K is not currently supported. Default is the first program within the transport stream. If the program you specify doesn't exist, the transcoding service will use this default.
         */
        public var programNumber: kotlin.Int = 0
        /**
         * Set PSI control (InputPsiControl) for transport stream inputs to specify which data the demux process to scans. * Ignore PSI - Scan all PIDs for audio and video. * Use PSI - Scan only PSI data.
         */
        public var psiControl: aws.sdk.kotlin.services.mediaconvert.model.InputPsiControl? = null
        /**
         * Provide a list of any necessary supplemental IMPs. You need supplemental IMPs if the CPL that you're using for your input is in an incomplete IMP. Specify either the supplemental IMP directories with a trailing slash or the ASSETMAP.xml files. For example &#91;"s3://bucket/ov/", "s3://bucket/vf2/ASSETMAP.xml"&#93;. You don't need to specify the IMP that contains your input CPL, because the service automatically detects it.
         */
        public var supplementalImps: List<String>? = null
        /**
         * Use this Timecode source setting, located under the input settings (InputTimecodeSource), to specify how the service counts input video frames. This input frame count affects only the behavior of features that apply to a single input at a time, such as input clipping and synchronizing some captions formats. Choose Embedded (EMBEDDED) to use the timecodes in your input video. Choose Start at zero (ZEROBASED) to start the first frame at zero. Choose Specified start (SPECIFIEDSTART) to start the first frame at the timecode that you specify in the setting Start timecode (timecodeStart). If you don't specify a value for Timecode source, the service will use Embedded by default. For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
         */
        public var timecodeSource: aws.sdk.kotlin.services.mediaconvert.model.InputTimecodeSource? = null
        /**
         * Specify the timecode that you want the service to use for this input's initial frame. To use this setting, you must set the Timecode source setting, located under the input settings (InputTimecodeSource), to Specified start (SPECIFIEDSTART). For more information about timecodes, see https://docs.aws.amazon.com/console/mediaconvert/timecode.
         */
        public var timecodeStart: kotlin.String? = null
        /**
         * When you include Video generator, MediaConvert creates a video input with black frames. Use this setting if you do not have a video input or if you want to add black video frames before, or after, other inputs. You can specify Video generator, or you can specify an Input file, but you cannot specify both. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/video-generator.html
         */
        public var videoGenerator: aws.sdk.kotlin.services.mediaconvert.model.InputVideoGenerator? = null
        /**
         * Input video selectors contain the video settings for the input. Each of your inputs can have up to one video selector.
         */
        public var videoSelector: aws.sdk.kotlin.services.mediaconvert.model.VideoSelector? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.Input) : this() {
            this.audioSelectorGroups = x.audioSelectorGroups
            this.audioSelectors = x.audioSelectors
            this.captionSelectors = x.captionSelectors
            this.crop = x.crop
            this.deblockFilter = x.deblockFilter
            this.decryptionSettings = x.decryptionSettings
            this.denoiseFilter = x.denoiseFilter
            this.dolbyVisionMetadataXml = x.dolbyVisionMetadataXml
            this.fileInput = x.fileInput
            this.filterEnable = x.filterEnable
            this.filterStrength = x.filterStrength
            this.imageInserter = x.imageInserter
            this.inputClippings = x.inputClippings
            this.inputScanType = x.inputScanType
            this.position = x.position
            this.programNumber = x.programNumber
            this.psiControl = x.psiControl
            this.supplementalImps = x.supplementalImps
            this.timecodeSource = x.timecodeSource
            this.timecodeStart = x.timecodeStart
            this.videoGenerator = x.videoGenerator
            this.videoSelector = x.videoSelector
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.Input = Input(this)

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Rectangle] inside the given [block]
         */
        public fun crop(block: aws.sdk.kotlin.services.mediaconvert.model.Rectangle.Builder.() -> kotlin.Unit) {
            this.crop = aws.sdk.kotlin.services.mediaconvert.model.Rectangle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings] inside the given [block]
         */
        public fun decryptionSettings(block: aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings.Builder.() -> kotlin.Unit) {
            this.decryptionSettings = aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.ImageInserter] inside the given [block]
         */
        public fun imageInserter(block: aws.sdk.kotlin.services.mediaconvert.model.ImageInserter.Builder.() -> kotlin.Unit) {
            this.imageInserter = aws.sdk.kotlin.services.mediaconvert.model.ImageInserter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.Rectangle] inside the given [block]
         */
        public fun position(block: aws.sdk.kotlin.services.mediaconvert.model.Rectangle.Builder.() -> kotlin.Unit) {
            this.position = aws.sdk.kotlin.services.mediaconvert.model.Rectangle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.InputVideoGenerator] inside the given [block]
         */
        public fun videoGenerator(block: aws.sdk.kotlin.services.mediaconvert.model.InputVideoGenerator.Builder.() -> kotlin.Unit) {
            this.videoGenerator = aws.sdk.kotlin.services.mediaconvert.model.InputVideoGenerator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.mediaconvert.model.VideoSelector] inside the given [block]
         */
        public fun videoSelector(block: aws.sdk.kotlin.services.mediaconvert.model.VideoSelector.Builder.() -> kotlin.Unit) {
            this.videoSelector = aws.sdk.kotlin.services.mediaconvert.model.VideoSelector.invoke(block)
        }
    }
}
