// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt your content.
 */
public class InputDecryptionSettings private constructor(builder: Builder) {
    /**
     * Specify the encryption mode that you used to encrypt your input files.
     */
    public val decryptionMode: aws.sdk.kotlin.services.mediaconvert.model.DecryptionMode? = builder.decryptionMode
    /**
     * Warning! Don't provide your encryption key in plaintext. Your job settings could be intercepted, making your encrypted content vulnerable. Specify the encrypted version of the data key that you used to encrypt your content. The data key must be encrypted by AWS Key Management Service (KMS). The key can be 128, 192, or 256 bits.
     */
    public val encryptedDecryptionKey: kotlin.String? = builder.encryptedDecryptionKey
    /**
     * Specify the initialization vector that you used when you encrypted your content before uploading it to Amazon S3. You can use a 16-byte initialization vector with any encryption mode. Or, you can use a 12-byte initialization vector with GCM or CTR. MediaConvert accepts only initialization vectors that are base64-encoded.
     */
    public val initializationVector: kotlin.String? = builder.initializationVector
    /**
     * Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if that Region is different from the one you are using for AWS Elemental MediaConvert.
     */
    public val kmsKeyRegion: kotlin.String? = builder.kmsKeyRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputDecryptionSettings(")
        append("decryptionMode=$decryptionMode,")
        append("encryptedDecryptionKey=$encryptedDecryptionKey,")
        append("initializationVector=$initializationVector,")
        append("kmsKeyRegion=$kmsKeyRegion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = decryptionMode?.hashCode() ?: 0
        result = 31 * result + (encryptedDecryptionKey?.hashCode() ?: 0)
        result = 31 * result + (initializationVector?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputDecryptionSettings

        if (decryptionMode != other.decryptionMode) return false
        if (encryptedDecryptionKey != other.encryptedDecryptionKey) return false
        if (initializationVector != other.initializationVector) return false
        if (kmsKeyRegion != other.kmsKeyRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify the encryption mode that you used to encrypt your input files.
         */
        public var decryptionMode: aws.sdk.kotlin.services.mediaconvert.model.DecryptionMode? = null
        /**
         * Warning! Don't provide your encryption key in plaintext. Your job settings could be intercepted, making your encrypted content vulnerable. Specify the encrypted version of the data key that you used to encrypt your content. The data key must be encrypted by AWS Key Management Service (KMS). The key can be 128, 192, or 256 bits.
         */
        public var encryptedDecryptionKey: kotlin.String? = null
        /**
         * Specify the initialization vector that you used when you encrypted your content before uploading it to Amazon S3. You can use a 16-byte initialization vector with any encryption mode. Or, you can use a 12-byte initialization vector with GCM or CTR. MediaConvert accepts only initialization vectors that are base64-encoded.
         */
        public var initializationVector: kotlin.String? = null
        /**
         * Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if that Region is different from the one you are using for AWS Elemental MediaConvert.
         */
        public var kmsKeyRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings) : this() {
            this.decryptionMode = x.decryptionMode
            this.encryptedDecryptionKey = x.encryptedDecryptionKey
            this.initializationVector = x.initializationVector
            this.kmsKeyRegion = x.kmsKeyRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.InputDecryptionSettings = InputDecryptionSettings(this)
    }
}
