// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediaconvert.model



/**
 * These settings apply to a specific graphic overlay. You can include multiple overlays in your job.
 */
public class InsertableImage private constructor(builder: Builder) {
    /**
     * Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.
     */
    public val duration: kotlin.Int = builder.duration
    /**
     * Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
     */
    public val fadeIn: kotlin.Int = builder.fadeIn
    /**
     * Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
     */
    public val fadeOut: kotlin.Int = builder.fadeOut
    /**
     * Specify the height of the inserted image in pixels. If you specify a value that's larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.
     */
    public val height: kotlin.Int = builder.height
    /**
     * Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.
     */
    public val imageInserterInput: kotlin.String? = builder.imageInserterInput
    /**
     * Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.
     */
    public val imagex: kotlin.Int = builder.imagex
    /**
     * Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.
     */
    public val imagey: kotlin.Int = builder.imagey
    /**
     * Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.
     */
    public val layer: kotlin.Int = builder.layer
    /**
     * Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.
     */
    public val opacity: kotlin.Int = builder.opacity
    /**
     * Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
     */
    public val startTime: kotlin.String? = builder.startTime
    /**
     * Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.
     */
    public val width: kotlin.Int = builder.width

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.mediaconvert.model.InsertableImage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsertableImage(")
        append("duration=$duration,")
        append("fadeIn=$fadeIn,")
        append("fadeOut=$fadeOut,")
        append("height=$height,")
        append("imageInserterInput=$imageInserterInput,")
        append("imagex=$imagex,")
        append("imagey=$imagey,")
        append("layer=$layer,")
        append("opacity=$opacity,")
        append("startTime=$startTime,")
        append("width=$width)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration
        result = 31 * result + (fadeIn)
        result = 31 * result + (fadeOut)
        result = 31 * result + (height)
        result = 31 * result + (imageInserterInput?.hashCode() ?: 0)
        result = 31 * result + (imagex)
        result = 31 * result + (imagey)
        result = 31 * result + (layer)
        result = 31 * result + (opacity)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (width)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsertableImage

        if (duration != other.duration) return false
        if (fadeIn != other.fadeIn) return false
        if (fadeOut != other.fadeOut) return false
        if (height != other.height) return false
        if (imageInserterInput != other.imageInserterInput) return false
        if (imagex != other.imagex) return false
        if (imagey != other.imagey) return false
        if (layer != other.layer) return false
        if (opacity != other.opacity) return false
        if (startTime != other.startTime) return false
        if (width != other.width) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.mediaconvert.model.InsertableImage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.
         */
        public var duration: kotlin.Int = 0
        /**
         * Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
         */
        public var fadeIn: kotlin.Int = 0
        /**
         * Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
         */
        public var fadeOut: kotlin.Int = 0
        /**
         * Specify the height of the inserted image in pixels. If you specify a value that's larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.
         */
        public var height: kotlin.Int = 0
        /**
         * Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.
         */
        public var imageInserterInput: kotlin.String? = null
        /**
         * Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.
         */
        public var imagex: kotlin.Int = 0
        /**
         * Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.
         */
        public var imagey: kotlin.Int = 0
        /**
         * Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.
         */
        public var layer: kotlin.Int = 0
        /**
         * Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.
         */
        public var opacity: kotlin.Int = 0
        /**
         * Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
         */
        public var startTime: kotlin.String? = null
        /**
         * Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.
         */
        public var width: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.mediaconvert.model.InsertableImage) : this() {
            this.duration = x.duration
            this.fadeIn = x.fadeIn
            this.fadeOut = x.fadeOut
            this.height = x.height
            this.imageInserterInput = x.imageInserterInput
            this.imagex = x.imagex
            this.imagey = x.imagey
            this.layer = x.layer
            this.opacity = x.opacity
            this.startTime = x.startTime
            this.width = x.width
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.mediaconvert.model.InsertableImage = InsertableImage(this)
    }
}
